<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class NumerationBlockForm extends ABMForm {
  /**
   * Crea un formulario de ABM de un bloque de numeracin
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   * 
   * @return Form
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 00122D05
	parent::__construct($orm, $context);
	
	$from = new TextComponent();
	$from->setLabel("Desde")
		 ->setMaps('from');
	
	$to = new TextComponent();
	$to->setLabel("Hasta")
		->setMaps('to');
	
	$resellerOptions = $orm->query('Reseller')
						->attributes('id AS value', 'provider.name as description')
						->find();
	
	$reseller = new SelectComponent();
	$reseller->setLabel("Revendedor")
			 ->setMaps('reseller')
			 ->setOptions($resellerOptions);

	$compBotonete = new ButtonComponent();
	$compBotonete->setAction('submit')
				 ->setValue("Aceptar");

	$oLayout1 = new GridLayout(3 /*4*/, 1);
	$oLayout1->addComponent($from, 1, 1)
			 ->addComponent($to, 2, 1)
			 ->addComponent($reseller, 3, 1)
			 /*->addComponent($compBotonete, 4, 1)*/;

	$this->setClass("NumerationBlock")
		   ->setTitle("Bloques de Numeración")
		   ->setMethod("post")
			->setFormType(Form::FORM_OK_CANCEL)
		   ->addComponent($oLayout1);
	$this->setAction($context->getCurrentAction()->getStringCommand());
	return $this;
    // Bouml preserved body end 00122D05
  }

}
?>