<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class LineTypeForm extends ABMForm {
  /**
   * Crea un formulario de ABM de un tipo de lnea
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   * 
   * @return Form
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 00122F85
	parent::__construct($orm, $context);


	$description = new TextComponent();
	$description->setLabel("Tipo de Linea")
				->setMaps('description')
				->setSize("40");

	/*$compBotonete = new ButtonComponent();
	$compBotonete->setLabel("")
				 ->setId('id_sumb')
				 ->setName('subm')
				 ->setAction('submit')
				 ->setValue("Aceptar");*/

	$oLayout1 = new GridLayout(1 /*2*/, 1);
	$oLayout1->addComponent($description, 1, 1)
			 /*->addComponent($compBotonete, 2, 1)*/;

	$this->setClass("LineType")
		   ->setTitle("Tipo de Linea")
			->setFormType(Form::FORM_OK_CANCEL)
		   ->setMethod("post")
		   ->setId("id_form_lineType")
		   ->addComponent($oLayout1);
	$this->setAction($context->getCurrentAction()->getStringCommand());
	return $this;
    // Bouml preserved body end 00122F85
  }

}
?>