<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class LineForm extends ABMForm {
  /**
   * Crea un formulario de ABM de una Lnea
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   * 
   * @return Form
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 00122F05
	parent::__construct($orm, $context);
	
	$this->setClass("Line")
		   ->setTitle("Lineas")
		   ->setMethod("post")
			->setFormType(Form::FORM_OK_CANCEL)
		   ->setId("id_form_lines");
	
	$this->context = $context;
	$site_id = $this->getValueOf("site_id");
	
	$line = new TextComponent();
	$line->setLabel("Linea")
		 ->setMaps('line');
	
	$description = new TextComponent();
	$description->setLabel("Descripcion")
				->setMaps('description');
	
	$status = new SelectComponent();
	$status->setLabel("Estado")
			->setMaps('status')
			->setSelected("1")
			->setOptions(array(array("value" => "1", "description" => "Activo"), array("value" => "0", "description" => "Inactivo")));

	$oSite = $orm->query("Site")->filterBy("id", "=", $site_id)->findOne();
	if (!is_a($oSite, "Site"))
		throw new Exception ("No se encuentra el sitio asociado a la linea.");

	$oServiceProvider = $oSite->getServiceProvider();
	if (!is_a($oServiceProvider, "ServiceProvider"))
		throw new Exception ("El sitio no tiene un Service Provider asociado");

	if ($oServiceProvider->getProduct()->getId() == "2") {
		//Central Virtual
		$lineTypeOptions = $orm->query('lineType')
								->attributes('id AS value', 'description')
								->find();
		$lineType = new SelectComponent();
		$lineType->setLabel("Tipo de Linea")
				 ->setMaps('lineType')
				 ->setOptional(false)
				 ->setOptions($lineTypeOptions);
		$cLT = 1;
	} else {
		$lineType = new HiddenComponent(null, "lineType", "lineType", "1"); //Interno.
		$cLT = 0;
	}
	$interno = new TextComponent();
	$interno->setLabel("Nro Interno")
			->setMaps('interno');
	
	$passwordSip = new TextComponent();
	$passwordSip->setLabel("Password Sip")
				->setMaps('passwordSip');
	
	$aRecursos = $orm->query('Site')
					 ->attributes(	'serviceProvider.resources.id AS value', 
									'serviceProvider.resources.description AS description', 
									'serviceProvider.resources.field AS field')
					 ->filterBy('id', '=', $site_id)
					 ->find();
	
	$aComponentesAgregados = array();
	
	$def = $orm->getDefinition('Line');
	
	for ($i = 0; $i < count($aRecursos); $i++) {
		$definido = $def->getFieldDefinition($aRecursos[$i]["field"]);
		if ($definido) {
			if (isset($definido["type"])) {
				switch ($definido["type"]) {
					case ORM_TYPES::ORM_ENTITY:
						$clase = $definido["class"];
						$valores = $orm->query($clase)->attributes('id AS value', 'description')->find();
						break;
					default:
						$valores = array(array("value" => "0", "description" => "No"), array("value" => "1", "description" => "Si"));
						break;
				}
				$tmp = new SelectComponent();
				$tmp->setLabel($aRecursos[$i]["description"])
					->setMaps($aRecursos[$i]["field"])
					->setOptional(true)
					->setOptions($valores);
				$aComponentesAgregados[] = $tmp;
			}
		}
	}
	
	//Agrego el componente hidden de site_id
	$sitio = new HiddenComponent();
	$sitio->setName("site_id")
		  ->setMaps('site')
		  ->setValue($site_id);
	
	$servicePackOptions = $orm->query('Site')
								->attributes('serviceProvider.servicePacks.id AS value', 'serviceProvider.servicePacks.description AS description')
								->filterBy('serviceProvider.servicePacks.fieldName', 'IS NULL')
								->filterBy('id', '=', $site_id)
								->find();
	
	$servicePack = new SelectComponent();
	$servicePack->setLabel("Service Pack")
			 ->setMaps('servicePack')
			 ->setOptions($servicePackOptions);
	
	$subscription = new TextComponent();
	$subscription->setLabel("ID Subscription Tenfold")
				 ->setMaps('subscription');
	
	$ssi = new TextComponent();
	$ssi->setLabel("ID ruta SSI")
		->setMaps('ssi');
	
	
	if (is_array($aComponentesAgregados)) {
		$ag = count($aComponentesAgregados);
	} else {
		$ag = 0;
	}
	
	if (is_array($servicePackOptions) && (count($servicePackOptions) > 0) ) {
		$cSP = 1;
	} else {
		$cSP = 0;
	}

	$oLayout1 = new GridLayout(9+$ag+$cSP, 1);
	$oLayout1->addComponent($line, 1, 1);
	if ($cLT) $oLayout1->addComponent($lineType, 2, 1);
	if ($cSP) $oLayout1->addComponent($servicePack, 2 + $cLT, 1);
	$oLayout1->addComponent($status, 2 + $cSP + $cLT, 1)
			 ->addComponent($interno, 3 + $cSP + $cLT, 1)
			 ->addComponent($passwordSip, 4 + $cSP + $cLT, 1);
	
	$j = 0;
	if (is_array($aComponentesAgregados)) {
		for ($j = 0; $j < count($aComponentesAgregados); $j++) {
			$oLayout1->addComponent($aComponentesAgregados[$j], 5 + $j + $cSP + $cLT, 1);
		}
	}
	
	$oLayout1->addComponent($subscription, 7 + $j + $cSP + $cLT, 1)
			 ->addComponent($ssi, 8 + $j + $cSP + $cLT, 1);
	
	$this->addComponent($oLayout1)->addComponent($sitio);
	
	if (!$cLT) $this->addComponent($lineType);
	
	$this->setAction($context->getCurrentAction()->getStringCommand());
	return $this;
    // Bouml preserved body end 00122F05
  }

}
?>