<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/models/wholesale/Client.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class ClientForm extends ABMForm {
  /**
   * Crea un formulario de ABM de un cliente
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   * 
   * @return Form
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 00122D85
	parent::__construct($orm, $context);
	
	$this->setClass("Client")
		   ->setTitle("Cliente")
		   ->setMethod("post")
			->setFormType(Form::FORM_OK_CANCEL)
		   ->setId("id_form_client");
	
	$clientNumber = new TextComponent();
	$clientNumber->setLabel("Nro Cliente")
				->setMaps('clientNumber');
	
	$razonSocial = new TextComponent();
	$razonSocial->setLabel("Razón Social")
				->setSize(70)
				->setMaps('name');
	
	$userOptions = $orm->query('User')->filterBy("provider.id", '=', $context->getProvider()->getId())
						  ->attributes('id AS value', 'name as description')
						  ->find();
	
	$user = new SelectComponent();
	$user->setLabel("Usuario")
			    ->setMaps('user')
				->setOptions($userOptions);
	
	$contactName = new TextComponent();
	$contactName->setLabel("Nombre de Contacto")
			->setMaps('contactName')
			->setSize(40);
	
	$contactLastName = new TextComponent();
	$contactLastName->setLabel("Apellido de Contacto")
			->setMaps('contactLastName')
			->setSize(40);
	
	$mail = new TextComponent();
	$mail->setLabel("Email")
			->setMaps('mail')
			->setSize(40);
	
	$phone = new TextComponent();
	$phone->setLabel("Telefono")
			->setMaps('phone')
			->setSize(40);
	
	$alternativePhone = new TextComponent();
	$alternativePhone->setLabel("Telefono 2")
			->setMaps('alternativePhone')
			->setSize(40);
	
	$clientType = new SelectComponent();
	$clientType->setLabel("Tipo de Cliente")
			->setMaps('status')
			->setSelected("1")
			->setOptions(array(array("value" => Client::DIRECT_CLIENT, "description" => "Cliente Directo"), array("value" => Client::WEB_CLIENT, "description" => "Cliente Web")));
	
	$status = new SelectComponent();
	$status->setLabel("Estado")
			->setMaps('status')
			->setSelected("1")
			->setOptions(array(array("value" => "1", "description" => "Activo"), array("value" => "0", "description" => "Inactivo")));

	$payplanOptions = $orm->query('PayPlan')
						  ->attributes('id AS value', 'description')
						  ->find();
	
	$payplan = new SelectComponent();
	$payplan->setLabel("Plan de Pago")
			    ->setMaps('payPlan')
				->setOptions($payplanOptions);


	$oLayout1 = new GridLayout(11, 1);
	$oLayout1->addComponent($clientNumber, 1, 1)
			 ->addComponent($razonSocial, 2, 1)
			 ->addComponent($user, 3, 1)
			 ->addComponent($contactName, 4, 1)
			 ->addComponent($contactLastName, 5, 1)
			 ->addComponent($mail, 6, 1)
			 ->addComponent($phone, 7, 1)
			 ->addComponent($alternativePhone, 8, 1)
			 ->addComponent($clientType, 9, 1)
			 ->addComponent($status, 10, 1)
			 ->addComponent($payplan, 11, 1);

	$this->addComponent($oLayout1);
	
	$this->setAction($context->getCurrentAction()->getStringCommand());
	return $this;
    // Bouml preserved body end 00122D85
  }

  /**
   * Funcin invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return Client el objeto ya guardado si todo sali bien y un FALSE sino.
   */
  public function save($context, $orm)
  {
    // Bouml preserved body begin 0012A485
	$id = $this->getValueOf('id');
	//Validaciones
	$valido = $this->validate();

	if ($id === null) {
		//Caso alta
		$oClient = new Client();
		$this->setValuesToObject($oClient);
		$oClient->setReseller($context->getManager('Wholesale')->getCurrentReseller());
	} else {
		//Caso modificar
		$oClient = $orm->retrieve('Client', $this->getValueOf('id'));
		if (!$oClient) $oClient = $orm->load('Client', $this->getValueOf('id'));
		$this->setValuesToObject($oClient);
	}
	if ($valido === true) {
		$orm->save($oClient);
		return $oClient;
	} else {
		//Seteo error de contexto de validacion xd.-
		return $valido;
	}
    // Bouml preserved body end 0012A485
  }

}
?>