<?php
require_once 'iplan/security/AbstractManager.php';
require_once 'iplan/security/Renderable.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/security/User.php';
require_once 'iplan/models/wholesale/Reseller.php';
require_once 'iplan/models/wholesale/Client.php';
require_once 'iplan/models/wholesale/forms/ResellerForm.php';
require_once 'iplan/models/wholesale/forms/ResourceForm.php';
require_once 'iplan/models/wholesale/forms/ServiceProviderForm.php';
require_once 'iplan/models/wholesale/forms/PayPlanForm.php';
require_once 'iplan/models/wholesale/forms/ClientForm.php';
require_once 'iplan/models/wholesale/forms/SiteForm.php';
require_once 'iplan/models/wholesale/forms/LineForm.php';
require_once 'iplan/models/wholesale/forms/LineTypeForm.php';
require_once 'iplan/models/wholesale/forms/RecepcionistTypeForm.php';
require_once 'iplan/models/wholesale/forms/ServicePackForm.php';
require_once 'iplan/models/wholesale/CDR.php';
require_once 'iplan/models/wholesale/NumerationBlock.php';
require_once 'iplan/models/wholesale/forms/NumerationBlockForm.php';
require_once 'iplan/models/wholesale/Price.php';
require_once 'iplan/models/wholesale/PrefixGroup.php';
require_once 'iplan/models/wholesale/Prefix.php';
require_once 'iplan/models/wholesale/PricesList.php';
require_once 'iplan/models/wholesale/forms/PricesListForm.php';



/**
* Author: Jorge Alexis Viqueira
* 
*/
class WholesaleManager extends AbstractManager {
  /**
   * Retorna una lista de m�todos que pueden ser invocados desde la aplicaci�n.
   * 
   * @return array Un arreglo (clave, valor) donde la clave es un string con el nombre ficticio de la operaci�n y el valor el nombre del m�todo que le corresponde.
   */
  public function __listActions()
  {
    // Bouml preserved body begin 00119A85
	return array('listResellers', 'saveReseller', 'listClients', 'saveClient', 'listSites', 'saveSite', 'listLines', 'saveLine', 'listCDRs');
    // Bouml preserved body end 00119A85
  }

  /**
   * Recupera la lista de Resellers (Proveedores y/o revendedores)
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listResellers(&$context, $ajax)
  {
    // Bouml preserved body begin 00119A05
	$orm = $this->application->getORM();

	//Filtro de la consulta
	$oLayout1 = new GridLayout(1, 3);
	$oLayout1->addComponent(new TextComponent('Nombre', 'flt_name', 'provider.name'), 1, 1)
			 ->addComponent(new TextComponent('Tenfold ID', 'flt_tenfold', 'tenfoldId'), 1, 2)
			 ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 3);
	
	$oFilter = new Form();
	$oFilter->addComponent($oLayout1)
            ->setAction("Wholesale.listResellers")
            ->setTitle("Filtros")
		    ->setMethod("post")
			->setContext($context)
			->loadValues();
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('Identificador', 'id', false, null, true, null, null, true))
			->addColumn(new Column('Revendedor', 'rName'))
			->addColumn(new Column('Proveedor', 'provider.name'))
			->addColumn(new Column('Prefijo', 'prefix'))
			->addColumn(new Column('Tenfold ID', 'tenfoldId', true))
			->addColumn(new Column('C&O', 'accountAndOrder', false, '{{ accountAndOrder == 1 ? \'Si\' : \'No\' }}'))
			->addColumn(new Column('Creado', 'created'))
			->addColumn(new Column('Modificado', 'modified'))
			->addColumn(new Column('Eliminado','disabled'))
			->addColumn(new Column('Estado', 'status', false, '{{ status == 1 ? \'Activo\' : \'Inactivo\' }}'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
							new ActionButton($context, 'Wholesale.modifyReseller', 'id', null, 'inline-popup', 'row'),
							new ActionButton($context, 'Wholesale.listClients', array('reseller_id' => 'id'), null, 'inline-popup', 'row'),
							new ActionButton($context, 'Wholesale.addClient', array('reseller_id' => 'id'), null, 'inline-popup', 'row'),
							new ActionButton($context, 'Wholesale.deleteReseller', 'id', null, 'alert inline', 'list')
						)))
			->addAction(new ActionButton($context, 'Wholesale.addReseller', null, null, 'inline-popup', 'list'))
			->addAction(new ActionButton($context, 'Wholesale.exportResellersCsv', $oFilter->toURL(), null, 'inline', 'none'))
			->setFilter($oFilter)
			->setListFunction(
				function (WholesaleManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
					//Busco Resellers
					$query = $orm->query('Reseller')
							->attributes('id', 'name AS rName', 'provider.name','prefix', 'tenfoldId', 'accountAndOrder', 'created', 'modified', 'disabled', 'status')
							->filterBy('id', 'IN', $manager->getOwnedResellersIds());
					$oWebList->applyFilter($query)
							 ->limitQuery($query);
					$mainResult = $query->find();
					return $mainResult;
				}
			);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 00119A05
  }

  /**
   * Muestra el detalle del revedendor.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function detailReseller(&$context, $ajax)
  {
    // Bouml preserved body begin 0012DD05
	return new Renderable('sorry.xhtml');
    // Bouml preserved body end 0012DD05
  }

  /**
   * Guarda/Modifica un Reseller del sistema.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function saveReseller(&$context, $ajax)
  {
    // Bouml preserved body begin 0011B785
	$orm = $this->application->getORM();
	$oFormOption = new Form();
	$combo = new SelectComponent('Elija una opción:', 'ProviderOption');
	$combo->setOptions(array(array('value'=>'1', 'description'=>'El provider ya existe'), array('value'=>'2', 'description'=>'Tengo que crear el provider')));
	$layout = new GridLayout(1, 2);
	$layout->addComponent($combo, 1, 1)
		   ->addComponent(new ButtonComponent('Cambiar', 'submit'),1,2);
	$oFormOption->setAction("Wholesale.addReseller")
				->addComponent($layout)
				->setMethod('POST')
				->setContext($context)
				->setTitle('Provider');

	$compose = new ComposedForm();
	$compose->setDefaultForm($oFormOption)
			->addCondition('existe', 'ResellerForm', true, array('ProviderOption' => 1),
							function (ApplicationContext $context, ABMForm $resellerForm, Form $optionForm) {
								return true;
							})
			->addCondition('crearProvider', 'ProviderForm', false, array('ProviderOption' => 2),
							function (ApplicationContext $context, ABMForm $providerForm, Form $optionForm) {
								$providerForm->setValueOf('owner', $context->getProvider()->getId());
								return true;
							})
			->addCondition('creado', 'ResellerForm', true, array('crearProvider.success'),
							function (ApplicationContext $context, ABMForm $resellerForm, ABMForm $providerForm) {
								$providerId = $providerForm->getValueOf('id');
								$resellerForm->setValueOf('provider', $providerId);
								return true;
							});
	return $compose->deploy($context, $this->application->getORM());
    // Bouml preserved body end 0011B785
  }

  /**
   * Funci�n de uso interno que se llama desde los formularios que REALMENTE tienen los datos del reseller, no del ComposedForm
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function saveRealReseller(&$context, $ajax)
  {
    // Bouml preserved body begin 0012D885
	$orm = $this->application->getORM();
	$oReseller = new ResellerForm($orm, $context);	
	return $oReseller->deploy($context, $orm);
    // Bouml preserved body end 0012D885
  }

  /**
   * Recupera la lista de Clientes
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listClients(&$context, $ajax)
  {
    // Bouml preserved body begin 00119B05
	$orm = $this->application->getORM();

	//Se crea el formulario de filtrado
	$compNroClient = new TextComponent('Nro Cliente', 'flt_numero','clientNumber');
	$compNroClient->setValidate("numeric");
	
	$compRazonSocial = new TextComponent("Razón Social", "razon_social", "name");
	$compRazonSocial->setSize(25);
	
	$compStatus = new SelectComponent('Estado', 'flt_status', 'status');
	$compStatus->setOptions(array(array("value" => "1", "description" => "Activo"), array("value" => "0", "description" => "Inactivo")));
	$payplanOptions = $orm->query('PayPlan')
						  ->attributes('id AS value', 'description')
						  ->find();
	$compPayplan = new MultiselectComponent('Tipo de Pago', 'flt_payplan', 'payPlan.id');
	$compPayplan->setOptional(false)->setOptions($payplanOptions)->setSize(2);

	$oLayout1 = new GridLayout(2, 3);
	$oLayout1->addComponent($compNroClient, 1, 1)
			 ->addComponent($compRazonSocial, 1, 2)
			 ->addComponent($compStatus, 1, 3)
			 ->addComponent(new TextComponent('Usuario', 'flt_user', 'user.username'), 2, 1)
			 ->addComponent($compPayplan, 2, 2)
			 ->addComponent(new ButtonComponent('Buscar', 'submit'), 2, 3);
	
	$oFilter = new Form();
	$oFilter->addComponent($oLayout1)
			->addComponent(new HiddenComponent(null, 'reseller_id', 'reseller.id'))
			->setAction("Wholesale.listClients")
            ->setTitle("Filtros")
		    ->setMethod("post")
			->setContext($context)
			->loadValues();
	
	//Columnas del Listado
	$numero = new Column('Nro', 'clientNumber', true, null, true, 'Wholesale.detailClient');
	$numero->setMode('inline-popup')
		   ->setRefresh("list")
		   ->setParams(array('id'=>'id'));
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('Identificador', 'id', false, null, true, null, null, true))
			->addColumn($numero)
			->addColumn(new Column('Razón Social', 'name'))
			->addColumn(new Column('Username', 'username', true))
			->addColumn(new Column('Usuario', 'user.username'))
			->addColumn(new Column('Creado', 'created', true))
			->addColumn(new Column('PayPlan', 'payPlan.description'))
			->addColumn(new Column('Estado', 'status', false, '{{ status == 1 ? \'Activo\' : \'Inactivo\' }}'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
							new ActionButton($context, 'Wholesale.modifyClient', 'id', null, 'inline-popup', 'row'),
							new ActionButton($context, 'Wholesale.listSites', array('cliente_id' => 'id'), null, 'inline-popup', 'row'),
							new ActionButton($context, 'Wholesale.addSite', array('cliente_id' => 'id'), null, 'inline-popup', 'row'),
							new ActionButton($context, 'Wholesale.deleteClient', 'id', null, 'alert inline', 'list')
						)))
			->addAction(new ActionButton($context, 'Wholesale.addClient', null, null, 'inline-popup', 'list'))
			->addAction(new ActionButton($context, 'Wholesale.exportClientsCsv', $oFilter->toURL(), null, 'inline', 'none'))
			->setFilter($oFilter);
	
	$webList->setListFunction(
		function (WholesaleManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
			//Busco Clientes del Reseller actual
			$query = $orm->query('Client')
						 ->filterBy('reseller.provider.id','=', $context->getProvider()->getId())
						->dontWorryAbout("user");
			//Establezco que campos voy a traer
			$query->attributes('id', 'name','clientNumber','status', 'username', 'user.username', 'created', 'modified', 'disabled', 'payPlan.description');
			$oWebList->applyFilter($query)
				     ->limitQuery($query);
			return $query->find();
		}
	
	);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 00119B05
  }

  /**
   * Muestra el detalle del Cliente.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function detailClient(&$context, $ajax)
  {
    // Bouml preserved body begin 0012DD85
	$oForm = new Form();
	
	$oForm->setMethod("post")
		  ->setTitle("Detalle de Cliente")
		  ->addComponent(new LabelComponent('Razon Social', null, 'name'))
		  ->addComponent(new LabelComponent('Nro Cliente', null, 'clientNumber'))
		  ->addComponent(new LabelComponent('Revendedor', null, 'reseller.provider.name'))
		  ->addComponent(new LabelComponent('Estado', null, 'status', null, "{{ status == 1 ? 'Activo' : 'Inactivo' }}"))
		  ->addComponent(new LabelComponent('Creado', null, 'created'))
		  ->addComponent(new LabelComponent('Modificado', null, 'modified'))
		  ->addComponent(new LabelComponent('Eliminado', null, 'disabled'))
		  ->addComponent(new LabelComponent('Nombre de Contacto', null, 'contactName'))
		  ->addComponent(new LabelComponent('Apellido de Contacto', null, 'contactLastName'))
		  ->addComponent(new LabelComponent('Email Contacto', null, 'mail'))
		  ->addComponent(new LabelComponent('Telefono 1', null, 'phone'))
		  ->addComponent(new LabelComponent('Telefono 2', 'alternativePhone'))
		  ->setContext($context);
	$oForm->setFormType(Form::FORM_BACK);
	$orm = $this->application->getORM();
	$xd = $orm->load('Client', $oForm->getValueOf("id"));
	$oForm->getValuesFromObject($xd);

	return $oForm->deploy($context);
    // Bouml preserved body end 0012DD85
  }

  /**
   * Guarda/Modifica un Client del sistema.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function saveClient(&$context, $ajax)
  {
    // Bouml preserved body begin 0011B805
	$orm = $this->application->getORM();
	$oForm1 = new ClientForm($orm, $context);	
	return $oForm1->deploy($context, $orm);
    // Bouml preserved body end 0011B805
  }

  /**
   * Recupera la lista de Sitios
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listSites(&$context, $ajax)
  {
    // Bouml preserved body begin 00119B85
	$orm = $this->application->getORM();
	
	$compPayplan = new MultiselectComponent('Plan de Pago', 'flt_payplan', 'payPlan.id');
	$compPayplan->setOptional(false)->setSize(2)
				->setOptions($orm->query('PayPlan')->attributes('id AS value', 'description')->find());
	
	$oLayout1 = new GridLayout(2, 4);
	$oLayout1->addComponent(new TextComponent('Cliente', 'flt_cliente', 'client.name'), 1, 1)
			 ->addComponent(new TextComponent('Sitio', 'flt_description', 'description'), 1, 2)
			 ->addComponent(new TextComponent('Locacion Tenfold', 'flt_location', 'location'), 1, 3)
			 ->addComponent(new TextComponent('Suscripción', 'flt_subscription', 'subscription'), 2, 1)
			 ->addComponent(new TextComponent('Grupo BS', 'flt_group', 'group'), 2, 2)
			 ->addComponent($compPayplan, 2, 3)
			 ->addComponent(new ButtonComponent('Buscar', 'submit'), 2, 4);
	
	$oFilter = new Form();
	$oFilter->addComponent($oLayout1)
			->addComponent(new HiddenComponent(null, 'cliente_id', 'client.id'))
			->addComponent(new HiddenComponent(null, 'site_id', 'id'))
			->setAction("Wholesale.listSites")
            ->setTitle("Filtros")
		    ->setMethod("post")
			->setContext($context)
			->loadValues();

	//Columna especial clickeable
	$nombreSitio = new Column('Sitio', 'description', false, null, true, 'Wholesale.detailSite');
	$nombreSitio->setMode('inline-popup')
				->setRefresh('list')
				->setParams(array('url' => 'detailSite', 'id' => 'id'));
	
	$nombreCliente = new Column('Cliente', 'client.name', false, null, true, 'Wholesale.listClients');
	$nombreCliente->setMode('inline-popup')
				->setRefresh('list')
				->setParams(array('url' => 'listClients', 'flt_numero' => 'client.clientNumber'));
	
	

	$webList = new WebList($this);
	$webList->addColumn(new Column('Identificador', 'id', false, null, true, null, null, true))
			->addColumn($nombreCliente)
			->addColumn($nombreSitio)
			->addColumn(new Column('BS Group', 'group'))
			->addColumn(new Column('BS ServiceProvider', 'serviceProvider.identifier'))
			->addColumn(new Column('Locacion Tenfold', 'location'))
			->addColumn(new Column('Subscription', 'subscription'))
			->addColumn(new Column('PayPlan','payPlan.description'))
			->addColumn(new Column("Estado", "status", false, '{{ status == 1 ? \'Activo\' : \'Inactivo\' }}'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
							new ActionButton($context, 'Wholesale.modifySite', array('id' => 'id', "cliente_id" => 'clientId'), null, 'inline-popup', 'row'),
							new ActionButton($context, 'Wholesale.listLines', array('sitio_id' => 'id'), null, 'inline-popup', 'none'),
							new ActionButton($context, 'Wholesale.addLine', array('site_id' => 'id'), null, 'inline-popup', 'row'),
							new ActionButton($context, 'Wholesale.deleteSite', 'id', null, 'alert inline', 'list')
						)))
			/*->addAction($addSite)*/
			->addAction(new ActionButton($context, 'Wholesale.exportSitesCsv',$oFilter->toURL(), null, 'inline', 'none'))
			->setFilter($oFilter);
	
	$webList->setListFunction(
		function (WholesaleManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
			//Busco Resellers
			$query = $orm->query('Site');
			$query->filterBy('client.reseller.provider.id','=', $context->getProvider()->getId());
					//->filterBy('reseller.provider.id','=', $context->getProvider()->getId());
			//Establezco que campos voy a traer
			$query->attributes('id', 'description', 'client.id AS clientId', 'client.clientNumber', 'client.name', 'location', 'subscription', 'serviceProvider.identifier', 'group', 'username', 'created', 'modified', 'disabled', 'status' ,'payPlan.description');	
			$oWebList->applyFilter($query)
				     ->limitQuery($query);
			$mainResult = $query->find();

			return $mainResult;
		}
	);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 00119B85
  }

  /**
   * Muestra el detalle del Cliente.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function detailSite(&$context, $ajax)
  {
    // Bouml preserved body begin 0012DE85
	$orm = $this->application->getORM();

	$oForm = new Form();
	$oForm->setMethod("post")
		  ->setTitle("Detalle de Sitio")
		  ->addComponent(new LabelComponent('ID', null, 'id'))
		  ->addComponent(new LabelComponent('Cliente', null, 'client.name'))
		  ->addComponent(new LabelComponent('Tipo de Pago', null, 'payPlan.description'))
		  ->addComponent(new LabelComponent('Description', null, 'description'))
		  ->addComponent(new LabelComponent('Estado', null, 'status', null, '{{ status == 1 ? \'Activo\' : \'Inactivo\' }}'))
		  ->addComponent(new LabelComponent('Creado', null, 'created'))
		  ->addComponent(new LabelComponent('Modificado', null, 'modified'))
		  ->addComponent(new LabelComponent('Borrado', null, 'disabled'))
		  ->addComponent(new LabelComponent('Location', null, 'location'))
		  ->addComponent(new LabelComponent('Subscripción', null, 'subscription'))
		  ->addComponent(new LabelComponent('Grupo', null, 'group'))
		  ->addComponent(new LabelComponent('Username', null, 'username'))
		  ->addComponent(new LabelComponent('Password', null, 'password'))
		  ->addComponent(new LabelComponent('Service Provider', null, 'serviceProvider.description'))
		  ->setContext($context);
	$oForm->setFormType(Form::FORM_BACK);
	$xd = $orm->load('Site', $oForm->getValueOf("id"));
	$oForm->getValuesFromObject($xd);
	return $oForm->deploy($context);
    // Bouml preserved body end 0012DE85
  }

  /**
   * Guarda/Modifica un Site de un cliente (Client) del sistema.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function saveSite(&$context, $ajax)
  {
    // Bouml preserved body begin 0011B885
	$orm = $this->application->getORM();
	$oForm1 = new SiteForm($orm, $context);	
	return $oForm1->deploy($context, $orm);
    // Bouml preserved body end 0011B885
  }

  /**
   * Recupera el listado de l�neas de un cliente.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listLines(&$context, $ajax)
  {
    // Bouml preserved body begin 00119D05
	$orm = $this->application->getORM();

	//Creo el filtro:
	$compStatus = new SelectComponent('Estado', 'flt_status', 'status');
	$compStatus->setOptions(array(array("value" => "1", "description" => "Activo"), array("value" => "0", "description" => "Inactivo")));
	$compLineType = new SelectComponent('Tipo de Linea', 'flt_lineType', 'lineType.id');
	$compLineType->setOptional(true)
				->setOptions( $orm->query('LineType')->attributes('id AS value', 'description')->find() );
	
	$oLayout1 = new GridLayout(2, 4);
	$oLayout1->addComponent(new TextComponent('Linea', 'flt_linea', 'id'), 1, 1)
			 ->addComponent(new TextComponent('Subscripción', 'flt_subscription', 'subscription'), 1, 2)
			 ->addComponent(new TextComponent('Sitio', 'flt_description', 'site.description'), 1, 3)
			 ->addComponent(new TextComponent('Interno', 'flt_interno', 'interno'), 1, 4)
			 ->addComponent($compStatus, 2, 1)
			 ->addComponent($compLineType, 2, 2)
			 ->addComponent(new ButtonComponent('Buscar', 'submit'), 2, 3, 2, 1);
	
	$oFilter = new Form();
	$oFilter->addComponent($oLayout1)
			->addComponent(new HiddenComponent(null, 'sitio_id', 'site.id'))
			->setAction("Wholesale.listLines")
            ->setTarget("div_list_items")
            ->setTitle("Filtros")
		    ->setMethod("post")
		    ->setId("id_form_filtros")
			->setContext($context)
			->loadValues();

	//Columnas del Listado
	$identificador = new Column('Linea', 'id', true, null, true, 'Wholesale.detailLine');
	$identificador->setMode('inline-popup')
				  ->setRefresh("list")
				  ->setParams('id');
	
	$nombreSitio = new Column('Sitio', 'site.description', false, null, true, 'Wholesale.listSites');
	$nombreSitio->setMode('inline-popup')
				->setRefresh('list')
				->setParams(array('url' => 'listSites', 'site_id' => 'site.id'));

	$nombreCliente = new Column('Cliente', 'site.client.name', false, null, true, 'Wholesale.listClients');
	$nombreCliente->setMode('inline-popup')
				->setRefresh('list')
				->setParams(array('url' => 'listClients', 'flt_numero' => 'site.client.clientNumber'));
	
	//Columnas del Listado
	$suscripcion_id = new Column('Subscripción', 'subscription', true, null, true, 'AutoProvisioning.listServiceOrderTasks');
	$suscripcion_id->setMode('inline-popup')
				  ->setRefresh("list")
				  ->setParams(array('url' => 'listServiceOrderTasks', 'subscriptionId' => 'subscription'));
	
	$webList = new WebList($this);
	$webList->addColumn($identificador)
			->addColumn($suscripcion_id)
			->addColumn($nombreCliente)
			//->addColumn(new Column('Sitio', 'site.description'))
			->addColumn($nombreSitio)
			->addColumn(new Column('Interno', 'interno'))
			->addColumn(new Column('Estado', 'status', false, '{{ status == 1 ? \'Activo\' : \'Inactivo\' }}'))
			->addColumn(new Column('Creado', 'created'))
			->addColumn(new Column('Modificado', 'modified'))
			->addColumn(new Column('Eliminado', 'disabled')) 
			->addColumn(new Column('Tipo de Linea', 'lineType.description'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
							new ActionButton($context, 'Wholesale.listCDRs', array('flt_lineNumber' => 'id'), null, 'inline-popup', 'row'),
							new ActionButton($context, 'Wholesale.modifyLine', array('id', "site_id" => 'site.id'), null, 'inline-popup', 'row'),
							new ActionButton($context, 'Wholesale.deleteLine', array('id', "site_id" => 'site.id'), null, 'alert inline', 'list')
						)))
			/*->addAction($addLine)*/
			->addAction(new ActionButton($context, 'Wholesale.exportLinesCsv', $oFilter->toURL(), null, 'inline', 'none'))
			->setFilter($oFilter);
	
	$webList->setListFunction(
		function (WholesaleManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
			//Busco Resellers
			$query = $orm->query('Line')
						 ->filterBy('site.client.reseller.provider.id', '=', $context->getProvider()->getId())
						 ->attributes('id', 'subscription','site.client.name', 'site.id', 'description', 'interno', 'status', 'created', 'modified', 'disabled', 'site.description', 'lineType.description');
			$oWebList->applyFilter($query)
				     ->limitQuery($query);
			return $query->find();
		}
	
	);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 00119D05
  }

  /**
   * Muestra el detalle del Cliente.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function detailLine(&$context, $ajax)
  {
    // Bouml preserved body begin 0012DE05
	$orm = $this->application->getORM();
	
	$oForm = new Form();
	$oForm->setMethod("post")
		  ->setTitle("Detalle de Linea")
		  ->setContext($context)
		  ->addComponent(new LabelComponent('Subscription ID', null, 'subscription'))
		  ->addComponent(new LabelComponent('Tipo de Linea', null, 'lineType.description'))
		  ->addComponent(new LabelComponent('Linea', null, 'id'))
		  ->addComponent(new LabelComponent('Extensión', null, 'interno'))
		  /*->addComponent(new LabelComponent('Descripción', null, 'description'))*/
		  /*->addComponent(new LabelComponent('Registrado', null, 'registered', null, "{{ registered == 1 ? 'Si' : 'No' }}"))
		  ->addComponent(new LabelComponent('User Agent', null, 'userAgent'))
		  ->addComponent(new LabelComponent('IP', null, 'ip'))
		  ->addComponent(new LabelComponent('Port', null, 'port'))*/
		  ->addComponent(new LabelComponent())
		  ->addComponent(new LabelComponent('Características'))
		  ->addComponent(new LabelComponent('Service Pack', null, 'servicePack.description'))
		  ->addComponent(new LabelComponent('VPN Voice', null, 'vpnVoiceEnabled', null, "{% if vpnVoiceEnabled == 1 %}<span style=\"color: green\">Tiene</span>{% else %}<span style=\"color: red\">No tiene</span>{% endif %}"))
		  ->addComponent(new LabelComponent('Integración Outlook', null, 'outlookIntegrationEnabled', null, "{% if outlookIntegrationEnabled == 1 %}<span style=\"color: green\">Tiene</span>{% else %}<span style=\"color: red\">No tiene</span>{% endif %}"))
		  ->addComponent(new LabelComponent('Servicio CFNR', null, 'cfnrEnabled', null, "{% if cfnrEnabled == 1 %}<span style=\"color: green\">Tiene</span>{% else %}<span style=\"color: red\">No tiene</span>{% endif %}"))
		  ->addComponent(new LabelComponent('Detalle llamadas web', null, 'webDetailEnabled', null, "{% if webDetailEnabled == 1 %}<span style=\"color: green\">Tiene</span>{% else %}<span style=\"color: red\">No tiene</span>{% endif %}"))
		  ->addComponent(new LabelComponent('Voice Mail', null, 'voiceMailEnabled', null, "{% if voiceMailEnabled == 1 %}<span style=\"color: green\">Tiene</span>{% else %}<span style=\"color: red\">No tiene</span>{% endif %}"))
		  ->addComponent(new LabelComponent('Licencia Call Center', null, 'callCenter', null, "{{ callCenter == 1 ? 'Tiene' : 'No tiene' }}"))
		  ->addComponent(new LabelComponent('Call Notify', null, 'callNotify', null, "{% if callNotify == 1 %}<span style=\"color: green\">Tiene</span>{% else %}<span style=\"color: red\">No tiene</span>{% endif %}"))
		  ->addComponent(new LabelComponent('Call Forwarding', null, 'callForwarding', null, "{% if callForwarding == 1 %}<span style=\"color: green\">Tiene</span>{% else %}<span style=\"color: red\">No tiene</span>{% endif %}"))
		  ->addComponent(new LabelComponent('Remote Office', null, 'remoteOffice', null, "{% if remoteOffice == 1 %}<span style=\"color: green\">Tiene</span>{% else %}<span style=\"color: red\">No tiene</span>{% endif %}"))
		  ->addComponent(new LabelComponent('Shared Call Appearance', null, 'sharedCallAppearance', null, "{% if sharedCallAppearance == 1 %}<span style=\"color: green\">Tiene</span>{% else %}<span style=\"color: red\">No tiene</span>{% endif %}"))
		  ->addComponent(new LabelComponent('Do Not Disturb', null, 'doNotDisturb', null, "{% if doNotDisturb == 1 %}<span style=\"color: green\">Tiene</span>{% else %}<span style=\"color: red\">No tiene</span>{% endif %}"))
		  ->addComponent(new LabelComponent())
		  ->addComponent(new LabelComponent('Telefonía'))
		  ->addComponent(new LabelComponent('Bloqueo LDN', null, 'bloqueoLDN', null, "{% if bloqueoLDN == 1 %}<span style=\"color: red\">Tiene</span>{% else %}<span style=\"color: green\">No tiene</span>{% endif %}"))
		  ->addComponent(new LabelComponent('Bloqueo LDI', null, 'bloqueoLDI', null, "{% if bloqueoLDI == 1 %}<span style=\"color: red\">Tiene</span>{% else %}<span style=\"color: green\">No tiene</span>{% endif %}"))
		  ->addComponent(new LabelComponent('Bloqueo CPP', null, 'bloqueoCPP', null, "{% if bloqueoCPP == 1 %}<span style=\"color: red\">Tiene</span>{% else %}<span style=\"color: green\">No tiene</span>{% endif %}"))
		  ->addComponent(new LabelComponent('Bloqueo Local', null, 'bloqueoLOCAL', null, "{% if bloqueoLOCAL == 1 %}<span style=\"color: red\">Tiene</span>{% else %}<span style=\"color: green\">No tiene</span>{% endif %}"))
		  ->addComponent(new LabelComponent('GOS', null, 'gos'))
		  ->addComponent(new LabelComponent())
		  ->addComponent(new LabelComponent('Provisioning de Teléfono'))
		  ->addComponent(new LabelComponent('MAC Address', null, 'mac'))
		  ->addComponent(new LabelComponent('Hardware State', null, 'hardwareState', null, "{{ hardwareState == 1 ? 'Activo' : 'Inactivo' }}"))
		  ->addComponent(new LabelComponent('Hardware Date', null, 'hardwareDate'))
		  ->addComponent(new LabelComponent('Hardware File', null, 'hardwareFile'))
		  ->addComponent(new LabelComponent('Hardware Model', null, 'hardwareModel'))
		  ->addComponent(new LabelComponent())
		  ->addComponent(new LabelComponent('Detalles de Estado'))
		  ->addComponent(new LabelComponent('Estado', null, 'status', null, "{{ status == 1 ? 'Activo' : 'Inactivo' }}"))
		  ->addComponent(new LabelComponent('Creado', null, 'created'))
		  ->addComponent(new LabelComponent('Modificado', null, 'modified'))
		  ->addComponent(new LabelComponent('Eliminado', null, 'disabled'));
	$oForm->setFormType(Form::FORM_BACK);
	$xd = $orm->load('Line', $oForm->getValueOf("id"));
	$oForm->getValuesFromObject($xd);
	return $oForm->deploy($context);
    // Bouml preserved body end 0012DE05
  }

  /**
   * Guarda/Modifica una l�nea dentro de un Site de un cliente.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function saveLine(&$context, $ajax)
  {
    // Bouml preserved body begin 0011B905
	$orm = $this->application->getORM();
	$oForm1 = new LineForm($orm, $context);	
	return $oForm1->deploy($context, $orm);
    // Bouml preserved body end 0011B905
  }

  /**
   * Recupera el listado de tipos de l�neas de tel�fono.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listLineTypes($context, $ajax)
  {
    // Bouml preserved body begin 00126B05
	$orm = $this->application->getORM();
	
	$oLayout1 = new GridLayout(1, 2);
	$oLayout1->addComponent(new TextComponent('Tipo de Linea', 'flt_linea', 'description'), 1, 1)
			 ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 2);
	
	$oFilter = new Form();
	$oFilter->addComponent($oLayout1)
			->setAction("Wholesale.listLineTypes")
            ->setTitle("Filtros")
		    ->setMethod("post");
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('Identificador', 'id'))
			->addColumn(new Column('Tipo de Linea', 'description'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
								new ActionButton($context, 'Wholesale.modifyLineType', 'id', null, 'inline-popup', 'row'),
								new ActionButton($context, 'Wholesale.deleteLineType', 'id', null, 'alert inline', 'list')
							)))
			->addAction(new ActionButton($context, 'Wholesale.addLineType', null, null, 'inline-popup', 'list'))
			->setFilter($oFilter);
	
	$webList->setListFunction(
		function (WholesaleManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
			$query = $orm->query('LineType');
			$query->attributes('id', 'description');
			$oWebList->applyFilter($query)
				     ->limitQuery($query);
			return $query->find();
		}
	);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 00126B05
  }

  /**
   * Guarda/Modifica un tipo de l�nea de tel�fono
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function saveLineType($context, $ajax)
  {
    // Bouml preserved body begin 00126B85
	$orm = $this->application->getORM();
	$oForm1 = new LineTypeForm($orm, $context);	
	return $oForm1->deploy($context, $orm);
    // Bouml preserved body end 00126B85
  }

  /**
   * Recupera el listado de l�neas de un cliente.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listCDRs(&$context, $ajax)
  {
    // Bouml preserved body begin 00119E05
	  
	$orm = $this->application->getORM();
	
	$compDirection = new MultiselectComponent('Dirección', 'flt_direction', 'direction');
	$compDirection->setOptional(false)->setSize(2)
				->setOptions(array(array("value" => "Originating", "description" => "Entrante"), array("value" => "Terminating", "description" => "Saliente")));

	$providerOptions = $orm->query('Reseller')
						  ->attributes('name AS value')
						  ->find();
	
	for ($i = 0; $i < count($providerOptions); $i++)
		$providerOptions[$i]["description"] = $providerOptions[$i]["value"];
	
	$compProvider = new MultiselectComponent('Revendedor', 'flt_provider', 'reseller.name');
	$compProvider->setOptional(false)
				->setOptions($providerOptions);
	
	$oLayout1 = new GridLayout(2, 4);
	$oLayout1->addComponent(new TextComponent('De', 'flt_de', 'numberA'), 1, 1)
			 ->addComponent(new TextComponent('A', 'flt_A', 'numberB'), 1, 2)
			 ->addComponent(new TextComponent('Linea', 'flt_lineNumber', 'lineNumber'), 1, 3)
			 ->addComponent($compProvider, 1, 4)
			 ->addComponent(new TextComponent('Iniciada', 'flt_connect', 'connect'), 2, 1)
			 ->addComponent(new TextComponent('Terminada', 'flt_disconnect', 'disconnect'), 2, 2)
			 ->addComponent($compDirection, 2, 3)
			 ->addComponent(new ButtonComponent('Buscar', 'submit'), 2, 4);
	
	$oFilter = new Form();
	$oFilter->addComponent($oLayout1)
			->setAction("Wholesale.listCDRs")
            ->setTitle("Filtros")
		    ->setMethod("post");
	
	$detCDR = new ActionButton($context, 'Wholesale.detailCDR', array('url' => 'detailCDR', 'id' => 'id'), null, 'inline-popup', 'list');
	$oFilter->setContext($context)
			->loadValues();
	$csvExpo = new ActionButton();
	$csvExpo->setCaption("CSV")
			->setAction('Wholesale.exportCDRsCsv')
			->setParams($oFilter->toURL())
			->setMode('inline')
			->setRefresh("none");
	
	
	/* Columna de acciones */
	$acciones = new Column();
	$acciones->setTitle("CDR")
			 ->addAction($detCDR);
	$listadoCDRs = new WebList($this);						
	$listadoCDRs->addColumn($acciones)
				->addColumn(new Column('Prefijo', 'prefix'))
				->addColumn(new Column('Linea', 'lineNumber', true))
				->addColumn(new Column('De', 'numberA', true))
				->addColumn(new Column('A', 'numberB', true))
				->addColumn(new Column('Iniciada', 'connect', true))
				->addColumn(new Column('Terminada', 'disconnect', true))
				->addColumn(new Column('Duración', 'duration'))
				->addColumn(new Column('Fraccionado', 'fractionationDesc'))
				->addColumn(new Column('Valor Fracción', 'currencyCode', 'price'))
				->addColumn(new Column('Costo', 'totalPrice', true))
				->addColumn(new Column('Revendedor', 'reseller.name', true))
				->addColumn(new Column('Dirección', 'direction', false, "{{ direction == 'Originating' ? 'Entrante' : 'Saliente' }}"))
				->addColumn(new Column('Cobrada', array('chargeIndicator', 'free'), false, "{{ chargeIndicator=='n'?'No': ( (free == 1)?'No':'Sí' ) }}"))
				->addAction($csvExpo)
				->setFilter($oFilter);
	
	$listadoCDRs->setListFunction(
		function (WholesaleManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
		
			$query = $orm->query('CDR')
						 ->filterBy('reseller.id', 'IN', $manager->getOwnedResellersIds())
						 ->attributes('id', 'prefix', 'lineNumber', 'numberA', 'numberB', 'connect', 'disconnect', 
									  'duration', 'fractionationDesc','currencyCode', 'totalPrice', 'reseller.name', 
									  'direction', 'chargeIndicator', 'free');
			//Si es un cliente sólo puede ver sus propios CDRs
			if ($manager->isClient($context->getUser()))
					$query->filterBy ('client.id', '=', $manager->getCurrentClient()->getId());
			
			$oWebList->applyFilter($query)
				     ->limitQuery($query);
			$mainResult = $query->find();
			
			return $mainResult;
	  });
	return $listadoCDRs->deploy($context, $this->application->getORM());
    // Bouml preserved body end 00119E05
  }

  /**
   * Muestra el detalle del Cliente.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function detailCDR(&$context, $ajax)
  {
    // Bouml preserved body begin 0012DF05

	$oForm = new Form();
	
	$oForm->setMethod("post")
		  ->setTitle("Detalle de CDR")
		  ->setContext($context)
		  ->addComponent(new LabelComponent('Prefijo:', null, 'prefix'))
		  ->addComponent(new LabelComponent('ID CDR:',null, 'id'))
		  ->addComponent(new LabelComponent('Numero de Línea:', null, 'lineNumber'))
	      ->addComponent(new LabelComponent('Creado:', null, 'created'))
	      ->addComponent(new LabelComponent('Origen:', null, 'numberA'))
		  ->addComponent(new LabelComponent('IP Origen:', null, 'ipA'))
		  ->addComponent(new LabelComponent('Destino:', null, 'numberB'))
		  ->addComponent(new LabelComponent('IP Destino:', null, 'ipB'))
		  ->addComponent(new LabelComponent('Start:', null, 'start'))
		  ->addComponent(new LabelComponent('Ringing:', null, 'ringing'))
		  ->addComponent(new LabelComponent('Connect:', null, 'connect'))
		  ->addComponent(new LabelComponent('Disconnect:', null, 'disconnect'))
		  ->addComponent(new LabelComponent('Duración:', null, 'duration'))
		  ->addComponent(new LabelComponent('Precio:', null, 'price'))
		  ->addComponent(new LabelComponent('Codigo de Moneda:', null, 'currencyCode'))
		  ->addComponent(new LabelComponent('Precio Total:', null, 'totalPrice'))
		  ->addComponent(new LabelComponent('Fraccionamiento:', null, 'fractionationDesc'))
		  ->addComponent(new LabelComponent('Quotation:', null, 'quotation'))
		  ->addComponent(new LabelComponent('Numero de Teléfono:', null, 'phoneNumber'))
		  ->addComponent(new LabelComponent('Dirección:', null, 'direction', null, "{{ direction == 'Originating' ? 'Entrante' : 'Saliente' }}"))
		  ->addComponent(new LabelComponent('Zona Horaria:', null, 'timeZone'))
		  ->addComponent(new LabelComponent('Causa de Finalización:', null, 'terminationCause'))
		  ->addComponent(new LabelComponent('Tipo de Red:', null, 'networkType'))
		  ->addComponent(new LabelComponent('Tipo de Llamada de Red:', null, 'networkCallType'))
		  ->addComponent(new LabelComponent('Número Traducido:', null, 'networkTranslatedNumber'))
		  ->addComponent(new LabelComponent('Categoría de Llamada:', null, 'callCategory'))
		  ->addComponent(new LabelComponent('releasingParty:', null, 'releasingParty'))
		  ->addComponent(new LabelComponent('Codec:', null, 'codec'))
		  ->addComponent(new LabelComponent('Dirección del dispositivo de acceso:', null, 'accessDeviceAddress'))
		  ->addComponent(new LabelComponent('Razón de redirección:', null, 'redirectingReason'))
		  ->addComponent(new LabelComponent('Indicador de Cargo:', null, 'chargeIndicator', null, "{{ chargeIndicator == 'n' ? 'No' : 'Si' }}"))
		  ->addComponent(new LabelComponent('otherPartyName:', null, 'otherPartyName'))
		  ->addComponent(new LabelComponent('relatedCallidReason:', null, 'relatedCallidReason'))
		  ->addComponent(new LabelComponent('Service Provider:', null, 'serviceProviderName'))
		  ->addComponent(new LabelComponent('Nombre de Grupo:', null, 'groupName'))
		  ->addComponent(new LabelComponent('Gratis:', null, 'free', null, "{{ (free == 1) ? 'Si' : 'No' }}"))
		  ->addComponent(new LabelComponent('asCallType:', null, 'asCallType'))
		  ->addComponent(new LabelComponent('Error:', null, 'errorId'))
		  ->addComponent(new LabelComponent('Estado de CDR:', null, 'cdrState'));
	$oForm->setFormType(Form::FORM_BACK);
	$orm = $this->application->getORM();
	$xd = $orm->load('CDR', $oForm->getValueOf("id"));
	$oForm->getValuesFromObject($xd);
	return $oForm->deploy();
	//return $oForm->deploy($context, $orm);
	
    // Bouml preserved body end 0012DF05
  }

  /**
   * Recupera el listado de bloques de numeraci�n.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listNumerationBlocks($context, $ajax)
  {
    // Bouml preserved body begin 00127605
	$orm = $this->application->getORM();
	//Formulario de búsqueda
	$resellerOptions=$this->getOwnedResellers($this->getCurrentReseller(), array('id AS value', 'name as description'), true);

	$compReseller = new SelectComponent('Revendedor','flt_revendedor', 'reseller.name');
	$compReseller->setOptions($resellerOptions);
	$oLayout1 = new GridLayout(1, 2);
	$oLayout1->addComponent($compReseller, 1, 1)
			 ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 2);
	
	$oFilter = new Form();
	$oFilter->addComponent($oLayout1)
			->setAction("Wholesale.listNumerationBlocks")
            ->setTitle("Filtros")
		    ->setMethod("post");
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('Identificador', 'id'))
			->addColumn(new Column('Desde', 'from'))
			->addColumn(new Column('Hasta', 'to'))
			->addColumn(new Column('Revendedor', 'reseller.name'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
										new ActionButton($context, 'Wholesale.modifyNumerationBlock', 'id', null, 'inline-popup', 'row'),
										new ActionButton($context, 'Wholesale.deleteNumerationBlock', 'id', null, 'alert inline', 'list')
						)))
			->addAction(new ActionButton($context, 'Wholesale.addNumerationBlock', null, null, 'inline-popup', 'list'))
			->setFilter($oFilter)
			->setListFunction(
				function (WholesaleManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
					//Busco Resellers
					$query = $orm->query('NumerationBlock')
								 ->attributes('id', 'from', 'to', 'reseller.name')
								 ->filterBy('reseller.id', 'IN', $manager->getOwnedResellersIds());
					
					$oWebList->applyFilter($query)
							 ->limitQuery($query);
					$mainResult = $query->find();

					return $mainResult;
				}
			);
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 00127605
  }

  /**
   * Guarda/Modifica un bloque de numeraci�n
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function saveNumerationBlock($context, $ajax)
  {
    // Bouml preserved body begin 00127685
	$orm = $this->application->getORM();
	$oForm1 = new NumerationBlockForm($orm, $context);	
	return $oForm1->deploy($context, $orm);
    // Bouml preserved body end 00127685
  }

  /**
   * Recupera el listado de l�neas de un cliente.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listResources(&$context, $ajax)
  {
    // Bouml preserved body begin 0012CE05
	$orm = $this->application->getORM();
	
	$oLayout1 = new GridLayout(1, 2);
	$oLayout1->addComponent(new TextComponent('Broadsoft ID', 'description', 'description'), 1, 1)
			 ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 2);
	
	$oFilter = new Form();
	$oFilter->addComponent($oLayout1)
			->setAction("Wholesale.listResources")
            ->setTitle("Filtros")
		    ->setMethod("post");
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('Identificador', 'id'))
			->addColumn(new Column('Broadsoft ID', 'description'))
			->addColumn(new Column('Campo Mapea', 'field'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
								new ActionButton($context, 'Wholesale.modifyResource', 'id', null, 'inline-popup', 'row'),
								new ActionButton($context, 'Wholesale.deleteResource', 'id', null, 'alert inline', 'list')
							)))
			->addAction(new ActionButton($context, 'Wholesale.addResource', null, null, 'inline-popup', 'list'))
			->setFilter($oFilter);
	
	$webList->setListFunction(
		function (WholesaleManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
			$query = $orm->query('Resource')
						 ->attributes('id', 'description', 'field');
			$oWebList->applyFilter($query)
				     ->limitQuery($query);
			return $query->find();
		}
	);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 0012CE05
  }

  /**
   * Guarda/Modifica un Site de un cliente (Client) del sistema.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function saveResource(&$context, $ajax)
  {
    // Bouml preserved body begin 0012CE85
	$orm = $this->application->getORM();
	$oForm1 = new ResourceForm($orm, $context);	
	return $oForm1->deploy($context, $orm);
    // Bouml preserved body end 0012CE85
  }

  /**
   * Recupera el listado de l�neas de un cliente.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listPayPlans(&$context, $ajax)
  {
    // Bouml preserved body begin 0012CF05
	$orm = $this->application->getORM();

	$oLayout1 = new GridLayout(1, 2);
	$oLayout1->addComponent(new TextComponent('Descripcion', 'description', 'description'), 1, 1)
			 ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 2);
	
	$oFilter = new Form();
	$oFilter->addComponent($oLayout1)
			->setAction("Wholesale.listPayPlans")
            ->setTitle("Filtros")
		    ->setMethod("post");
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('Identificador', 'id'))
			->addColumn(new Column('Descripción', 'description'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
								new ActionButton($context, 'Wholesale.modifyPayPlan', 'id', null, 'inline-popup', 'row'),
								new ActionButton($context, 'Wholesale.deletePayPlan', 'id', null, 'alert inline', 'list')
							)))
			->addAction(new ActionButton($context, 'Wholesale.addPayPlan', null, null, 'inline-popup', 'list'))
			->setFilter($oFilter);
	
	$webList->setListFunction(
		function (WholesaleManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
			$query = $orm->query('PayPlan');
			$query->attributes('id', 'description');
			$oWebList->applyFilter($query)
				     ->limitQuery($query);
			return $query->find();
		}
	);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 0012CF05
  }

  /**
   * Guarda/Modifica un Site de un cliente (Client) del sistema.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function savePayPlan(&$context, $ajax)
  {
    // Bouml preserved body begin 0012CF85
	$orm = $this->application->getORM();
	$oForm1 = new PayPlanForm($orm, $context);	
	return $oForm1->deploy($context, $orm);
    // Bouml preserved body end 0012CF85
  }

  /**
   * Recupera el listado de l�neas de un cliente.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listServicePacks(&$context, $ajax)
  {
    // Bouml preserved body begin 0012D005
	$orm = $this->application->getORM();

	$oLayout1 = new GridLayout(1, 2);
	$oLayout1->addComponent(new TextComponent('Broadsoft ID', 'description', 'description'), 1, 1)
			 ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 2);
	
	$oFilter = new Form();
	$oFilter->addComponent($oLayout1)
			->setAction("Wholesale.listServicePacks")
            ->setTitle("Filtros")
		    ->setMethod("post");
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('Identificador', 'id'))
			->addColumn(new Column('Broadsoft ID', 'description'))
			->addColumn(new Column('Atributo', 'attributeName'))
			->addColumn(new Column('Field Name', 'fieldName'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
									new ActionButton($context, 'Wholesale.modifyServicePack', 'id', null, 'inline-popup', 'row'),
									new ActionButton($context, 'Wholesale.deleteServicePack', 'id', null, 'alert inline', 'list')
								)))
			->addAction(new ActionButton($context, 'Wholesale.addServicePack', null, null, 'inline-popup', 'list'))
			->setFilter($oFilter);
	
	$webList->setListFunction(
		function (WholesaleManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
			$query = $orm->query('ServicePack') //$manager->getOwnedProvidersIds($context->getProvider(), true),NULL, 'AND'
						 /*->filterBy('providers.reseller.id', 'IN', $manager->getOwnedResellersIds())*/
						 ->attributes('id', 'description', 'attributeName', 'fieldName')
						 ;
			$oWebList->applyFilter($query)
				     ->limitQuery($query);

			return $query->find();
		}
	);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 0012D005
  }

  /**
   * Guarda/Modifica un Site de un cliente (Client) del sistema.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function saveServicePack(&$context, $ajax)
  {
    // Bouml preserved body begin 0012D085
	$orm = $this->application->getORM();
	$oForm1 = new ServicePackForm($orm, $context);	
	return $oForm1->deploy($context, $orm);
    // Bouml preserved body end 0012D085
  }

  /**
   * Recupera el listado de l�neas de un cliente.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listRecepcionistTypes(&$context, $ajax)
  {
    // Bouml preserved body begin 0012D105
	$orm = $this->application->getORM();
	
	$oLayout1 = new GridLayout(1, 2);
	$oLayout1->addComponent(new TextComponent('Broadsoft ID', 'description', 'description'), 1, 1)
			 ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 2);
	
	$oFilter = new Form();
	$oFilter->addComponent($oLayout1)
			->setAction("Wholesale.listRecepcionistTypes")
            ->setTitle("Filtros")
		    ->setMethod("post");
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('Identificador', 'id'))
			->addColumn(new Column('Broadsoft ID', 'description'))
			->addColumn(new Column('Atributo', 'attributeName'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
								new ActionButton($context, 'Wholesale.modifyRecepcionistType', 'id', null, 'inline-popup', 'row'),
								new ActionButton($context, 'Wholesale.deleteRecepcionistType', 'id', null, 'alert inline', 'list')
							)))
			->addAction(new ActionButton($context, 'Wholesale.addRecepcionistType', null, null, 'inline-popup', 'list'))
			->setFilter($oFilter);
	
	$webList->setListFunction(
		function (WholesaleManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
			$query = $orm->query('RecepcionistType');
			$query->attributes('id', 'description', 'attributeName');
			$oWebList->applyFilter($query)
				     ->limitQuery($query);
			return $query->find();
		}
	);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 0012D105
  }

  /**
   * Guarda/Modifica un Site de un cliente (Client) del sistema.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function saveRecepcionistType(&$context, $ajax)
  {
    // Bouml preserved body begin 0012D185
	$orm = $this->application->getORM();
	$oForm1 = new RecepcionistTypeForm($orm, $context);	
	return $oForm1->deploy($context, $orm);
    // Bouml preserved body end 0012D185
  }

  /**
   * Recupera el listado de l�neas de un cliente.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listServiceProviders(&$context, $ajax)
  {
    // Bouml preserved body begin 0012D205
	$orm = $this->application->getORM();

	$selReseller = new SelectComponent('Revendedor', 'reseller', 'reseller.id');
	$selReseller->setOptions($this->getOwnedResellers($this->getCurrentReseller(), array("id as value","name as description"), true));

	$oLayout1 = new GridLayout(1, 3);
	$oLayout1->addComponent(new TextComponent('Broadsoft ID', 'description', 'description'), 1, 1)
			->addComponent($selReseller, 1, 2)
			 ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 3);
	
	$oFilter = new Form();
	$oFilter->addComponent($oLayout1)
			->setAction("Wholesale.listServiceProviders")
            ->setTitle("Filtros")
		    ->setMethod("post");
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('Identificador', 'id'))
			->addColumn(new Column('Descripción', 'description'))
			->addColumn(new Column('Broadsoft ID', 'identifier'))
			->addColumn(new Column('Revendedor', 'reseller.name'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
							new ActionButton($context, 'Wholesale.modifyServiceProvider', 'id', null, 'inline-popup', 'row'),
							new ActionButton($context, 'Wholesale.deleteServiceProvider', 'id', null, 'alert inline', 'list')
						)))
			->addAction(new ActionButton($context, 'Wholesale.addServiceProvider', null, null, 'inline-popup', 'list'))
			->setFilter($oFilter);
	
	$webList->setListFunction(
		function (WholesaleManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
			$query = $orm->query('ServiceProvider');
			//Traigo sólo los Service Providers del reseller actual o aquellos SIN asignar
			$query->attributes('id', 'description', 'identifier', 'reseller.name')
				  ->filterBy('reseller.id', 'IN', $manager->getOwnedResellersIds(), 'OR')
				  ->dontWorryAbout('reseller');
			$oWebList->applyFilter($query)
				     ->limitQuery($query);
			return $query->find();
		}
	);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 0012D205
  }

  /**
   * Guarda/Modifica un Site de un cliente (Client) del sistema.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function saveServiceProvider(&$context, $ajax)
  {
    // Bouml preserved body begin 0012D285
	$orm = $this->application->getORM();
	$oForm1 = new ServiceProviderForm($orm, $context);	
	return $oForm1->deploy($context, $orm);
    // Bouml preserved body end 0012D285
  }

  /**
   * Devuelve el listado de prefijos del revendedor.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listPrefixes(&$context, $ajax)
  {
    // Bouml preserved body begin 0013F885
	$orm = $this->application->getORM();
	
	$col = function($title, $attribute) {
			$column = new Column();
			return $column->setTitle($title)
				   ->setMaps($attribute);
	};
	
	$webList = new WebList($this);
	$webList->addColumn($col());
	
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 0013F885
  }

  /**
   * Guarda/Modifica un Prefijo de un revendedor.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function savePrefix(&$context, $ajax)
  {
    // Bouml preserved body begin 0013F905
	return new Renderable('sorry.xhtml');
    // Bouml preserved body end 0013F905
  }

  /**
   * Recupera el listado de grupos de prefijos de un revendedor.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listPrefixGroups(&$context, $ajax)
  {
    // Bouml preserved body begin 0013F985
	return new Renderable('sorry.xhtml');
    // Bouml preserved body end 0013F985
  }

  /**
   * Guarda/Modifica un Grupo de Prefijos de un revendedor (Reseller) del sistema.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function savePrefixGroup(&$context, $ajax)
  {
    // Bouml preserved body begin 0013FA05
	return new Renderable('sorry.xhtml');
    // Bouml preserved body end 0013FA05
  }

  /**
   * Recupera el listado de l�neas de un cliente.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listPricesLists(&$context, $ajax)
  {
    // Bouml preserved body begin 0013F685
	$orm = $this->application->getORM();
	
	$webList = new WebList($this);
	$webList->addColumn(new Column('Fecha', 'uploaded', true))
			->addColumn(new Column('Descripción', 'description'))
			->addColumn(new Column('Archivo', 'file'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
										new ActionButton($context, 'Wholesale.modPricesList', 'id'),
										new ActionButton($context, 'Wholesale.delPricesList', 'id')
						)))
			->setListFunction(
					function (WholesaleManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
						//Busco Service Providers
						$query = $orm->query('PricesList');
						$query->attributes('id', 'description', 'file', 'uploaded')
							  ->filterBy('reseller.id', '=', $context->getProvider()->getId());

						$oWebList->applyFilter($query)
								 ->limitQuery($query);

						return $query->find();
					}
				)
			->addAction(new ActionButton($context, 'Wholesale.addPricesList'));
	
	$layout = new GridLayout(1, 3);
	$layout->addComponent(new TextComponent('Descripción', 'description', 'description'), 1, 1)
		   ->addComponent(new TextComponent('Archivo', 'file', 'file'), 1, 2)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'), 1, 3);
	
	$form = new Form();
	$form->setMethod('post')
		 ->setTitle('Listas de Precios')
		 ->setAction('Wholesale.listPricesLists')
		 ->addComponent($layout)
		;
	$webList->setFilter($form);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 0013F685
  }

  /**
   * Importa desde un archivo CSV los nuevos precios.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function addPricesList(&$context, $ajax)
  {
    // Bouml preserved body begin 0013BE05
	$form = new Form();
	
	$txtDesc = new TextComponent('Descripción', 'desc');
	$txtDesc->setSize(50);
	$txtDelim = new TextComponent('Delimitador', 'delim', null,',');
	$txtDelim->setSize(3);
	$txtGroup = new TextComponent('Agrupador', 'group', null, '"');
	$txtGroup->setSize(3);
	
	$chkIncludeHeader = new CheckboxComponent('¿Incluye encabezados?', 'hasHeader', null, 1);
	$chkIncludeHeader->setChecked(true);
	$lblInfo = new LabelComponent('', null, null,
			'<strong>Formato:</strong> el formato del archivo que se espera es el siguiente:'.
						'<pre>Grupo In,Grupo Out,Valor,Descripción</pre>'.
						'Por ejemplo:<pre>
"Grupo In", "Grupo Out", "Valor", "Descripcion"
"Rosario","Capital Federal", "0.453", "Rosario-Cap."
"Rosario","Córdoba", "0.35", "Rosario-Córdoba"
"Rosario","25 de Mayo", "0.557", "Rosario-Pcia. Bs. As."</pre>La fila de títulos puede incluirse o no, asegúrese de destildar la opción de encabezados en caso de NO incluirlos.');
	
	$layout = new GridLayout(5, 2);
	$layout->addComponent($txtDesc, 1, 1)
			->addComponent(new FileComponent('Seleccione el archivo', 'csvFile'), 2, 1)
			->addComponent(new ButtonComponent('Importar', 'submit'), 3, 1)
			->addComponent($txtDelim, 1, 2)
			->addComponent($txtGroup, 2, 2)
			->addComponent($chkIncludeHeader, 3, 2)
			->addComponent($lblInfo, 4, 1, 2, 1, 'left');
		   
	$form->setTitle('Importar las tarifas')
		 ->setEnctype('multipart/form-data')
		 ->addComponent($layout)
		 ->setAction('Wholesale.addPricesList')
		 ->setContext($context)
		 ->loadValues();

	//Verifico si indicó un archivo, sino muestro el form vacío.
	$fileData = $form->getValueOf('csvFile');
	if (!is_null($fileData)) {
		$path = "./uploads/".$context->getProvider()->getName();
		if (!file_exists($path)) {
			mkdir ($path);
		}
		$filePath = $file->placeIn($fileData, $path);
		$f = fopen($filePath, 'r+');

		$delim = $form->getValueOf('delim');
		if ($delim===null) $delim=',';
		$group = $form->getValueOf('group');
		if ($group===null) $grop='"';
		
		//Si tiene header descarto la primer línea
		if ($form->getValueOf('hasHeader')==1)
				fgetcsv($f, 0, $delim, $group);
		
		while ($line= fgetcsv($f, 0, $delim, $group)) {
			var_dump($line);
		}
		
		fclose($f);
		return new Renderable("lib/success.xhtml");
	} else {
		return $form->deploy();
	}
    // Bouml preserved body end 0013BE05
  }

  /**
   * Importa desde un archivo CSV los nuevos precios.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function savePricesList(&$context, $ajax)
  {
    // Bouml preserved body begin 00143085
	$orm = $this->application->getORM();
	$oForm1 = new PricesListForm($orm, $context);	
	return $oForm1->deploy($context, $orm);
    // Bouml preserved body end 00143085
  }

  /**
   * Recupera el listado de l�neas de un cliente.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listPrices(&$context, $ajax)
  {
    // Bouml preserved body begin 0013F585
	$orm = $this->application->getORM();

	$webList = new WebList($this);
	$webList->addColumn(new Column('Lista', 'pricesList.description'))
			->addColumn(new Column('Grupo In', 'groupIn.description'))
			->addColumn(new Column('Grupo Out', 'groupOut.description'))
			->addColumn(new Column('Descripción', 'description'))
			->addColumn(new Column('Moneda', 'currency.id'))
			->addColumn(new Column('Precio', 'value'))
			->addColumn(new Column('Fraccionamiento', 'fractionationType.description'))
			->addColumn(new Column('Acciones', null, false, null, false, null, array(
									new ActionButton($context, 'Wholesale.modifyPrice', 'id', null, 'inline-popup', 'row'),
									new ActionButton($context, 'Wholesale.deletePrice', 'id', null, 'alert inline', 'list')
							)))
			->setListFunction(
					function (WholesaleManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('Price')
										 ->filterBy('reseller.id', '=', $context->getProvider()->getId())
										 ->attributes('id', 'value', 'description', 'groupIn.description', 'groupOut.description',
													  'currency.id', 'fractionationType.description', 'pricesList.description');
							$oWebList->applyFilter($query);
							$oWebList->limitQuery($query);
							return $query->find();
					  })
			->addAction(new ActionButton($context, 'Wholesale.addPrice'))
			->addAction(new ActionButton($context, 'Wholesale.exportPricesCsv'));
							  
    //Creo el formulario de filtro
	$selCurrency = new SelectComponent('Moneda', 'curr', 'currency.id');
	$selCurrency->setOptions($orm->query('Currency')
							 ->attributes('id as value', 'description')
							 ->find());
	$layout = new GridLayout(1, 5);
	$layout->addComponent(new TextComponent('Grupo In', 'gIn', 'groupIn.description'), 1, 1)
		   ->addComponent(new TextComponent('Grupo Out', 'gOut', 'groupOut.description'), 1, 2)
		   ->addComponent(new TextComponent('Descripción', 'desc', 'description'), 1, 3)
		   ->addComponent($selCurrency, 1, 4)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'),1 ,5);
	
    $form = new Form();
	$form->addComponent($layout)
		 ->setMethod('POST')
 		 ->setAction("Wholesale.listRates")
		 ->setTitle("Listado de Tarifas");
	$webList->setFilter($form);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 0013F585
  }

  /**
   * Guarda/Modifica un Site de un cliente (Client) del sistema.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function savePrices(&$context, $ajax)
  {
    // Bouml preserved body begin 0013F605
	$orm = $this->application->getORM();
	$oForm1 = new PriceForm($orm, $context);	
	return $oForm1->deploy($context, $orm);
    // Bouml preserved body end 0013F605
  }

  /**
   * Recupera el listado de l�neas de un cliente.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable La p�gina a mostrar encapsulada en un Renderable.
   */
  public function listRates(&$context, $ajax)
  {
    // Bouml preserved body begin 00138805
	$orm = $this->application->getORM();

	$webList = new WebList($this);
	$webList->addColumn(new Column('Grupo In', 'groupIn.description'))
			->addColumn(new Column('Grupo Out', 'groupOut.description'))
			->addColumn(new Column('Moneda', 'currency.id'))
			->addColumn(new Column('Precio', 'value'))
			->addColumn(new Column('Fraccionamiento', 'fractionationType.description'))
			->addColumn(new Column('Sitio', 'rates.site.description'))
			->setListFunction(
					function (WholesaleManager $manager, WebList $oWebList, ApplicationContext &$context, ORM &$orm, $from_row, $to_row) {
							$query = $orm->query('Price')
										 ->filterBy('reseller.provider.id', '=', $context->getProvider()->getId())
										 ->attributes('value', 'groupIn.description', 'groupOut.description',
													  'currency.id', 'fractionationType.description', 'rates.site.description');
							$oWebList->applyFilter($query);
							$oWebList->limitQuery($query);
							return $query->find();
					  })
			->addAction(new ActionButton($context, 'Wholesale.exportRatesCsv'));
							  
    //Creo el formulario de filtro
	$selCurrency = new SelectComponent('Moneda', 'curr', 'currency.id');
	$selCurrency->setOptions($orm->query('Currency')
							 ->attributes('id as value', 'description')
							 ->find());
	$layout = new GridLayout(1, 5);
	$layout->addComponent(new TextComponent('Grupo In', 'gIn', 'groupIn.description'), 1, 1)
		   ->addComponent(new TextComponent('Grupo Out', 'gOut', 'groupOut.description'), 1, 2)
		   ->addComponent(new TextComponent('Sitio', 'site', 'rates.site.description'), 1, 3)
		   ->addComponent($selCurrency, 1, 4)
		   ->addComponent(new ButtonComponent('Buscar', 'submit'),1 ,5);
	
    $form = new Form();
	$form->addComponent($layout)
		 ->setMethod('POST')
 		 ->setAction("Wholesale.listRates")
		 ->setTitle("Listado de Tarifas");
	$webList->setFilter($form);
	return $webList->deploy($context, $orm);
    // Bouml preserved body end 00138805
  }

  /**
   * Guarda/Modifica un Site de un cliente (Client) del sistema.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n
   * @param boolean $ajax indica si el llamado es para p�gina completa o para ser devuelto en background
   * 
   * @return Renderable la p�gina a visualizar.
   */
  public function saveRate(&$context, $ajax)
  {
    // Bouml preserved body begin 0013F785
	return new Renderable('sorry.xhtml');
    // Bouml preserved body end 0013F785
  }

  /**
   * Indica si el usuario es un Reseller
   * 
   * @param User $user el usuario a verificar.
   * 
   * @return bool Devuelve TRUE si el usuario dado pertenece a un Reseller o FALSE sino.
   */
  public function isReseller(&$user)
  {
    // Bouml preserved body begin 0011B985
	$orm = $this->application->getORM();
	$query = $orm->query('Reseller')
//				 ->filterBy('provider.id', '=', $this->application->getContext()->getProvider()->getId())
				 ->filterBy('provider.users.id', '=', $user->getId());
	$reseller = $query->findOne();
	return (is_a($reseller, 'Reseller') && !$this->isClient($user));
    // Bouml preserved body end 0011B985
  }

  /**
   * Indica si el usuario es un Client
   * 
   * @param User $user el usuario a verificar.
   * 
   * @return bool Devuelve TRUE si el usuario dado pertenece a un Client o FALSE sino.
   */
  public function isClient(&$user)
  {
    // Bouml preserved body begin 0011BA05
	$orm = $this->application->getORM();
	$query = $orm->query('Client')
		->filterBy('reseller.provider.id', '=', $this->application->getContext()->getProvider()->getId())
		->filterBy('user.id', '=', $user->getId());
	$client = $query->findOne();
	return is_a($client, 'Client');
    // Bouml preserved body end 0011BA05
  }

  /**
   * Indica si el usuario es un Client
   * 
   * @param Reseller $reseller del cual se quiere verificar si tiene otros resellers dependientes de �l.
   * 
   * @return bool Devuelve TRUE si el reseller dado tiene otros dependiente de �l o FALSE sino.
   */
  public function hasOwnedResellers(&$reseller)
  {
    // Bouml preserved body begin 0011BA85
	$orm = $this->application->getORM();
	$query = $orm->query('Reseller')
			     ->filterBy('provider.owner.id', '=', $reseller->getProvider()->getId());
	$child = $query->findOne();
	return is_a($child, 'Reseller');
    // Bouml preserved body end 0011BA85
  }

  /**
   * Recupera una lista de los Resellers dependientes del reseller dado.
   * 
   * @param Reseller $reseller del cual se quiere conocer los resellers dependientes de �l.
   * @param array $columns si en vez de obtener los objetos provider se quiere obtener una lista de columnas, se pasan como un arreglo de string. Soporta alias :)
   * @param boolean $includeOwner indica si se desea incluir al propio reseller del par�metro en el resultado.
   * @return array Devuelve una lista con las instancias de los resellers dependientes.
   */
  public function getOwnedResellers(&$reseller, $columns = null, $includeOwner = true)
  {
    // Bouml preserved body begin 0011BB05
	$orm = $this->application->getORM();
	if (!is_a($reseller, 'Reseller')) {
		return null;
	}
	$query = $orm->query('Reseller')
			     ->filterBy('provider.owner.id', '=', $reseller->getProvider()->getId());
	$childs = $query->find();
	
	if ($childs != false) {
		foreach($childs as $child) {
			if (is_a($child, 'Reseller'))
				$subChilds = $this->getOwnedResellers($child, null, false);
			else 
				$subChilds = null;
			if (!is_null($subChilds))
				array_merge ($childs, $subChilds);
		}
		if (!is_null($columns)) {
			$idChilds=array();
			foreach($childs as $child)
				$idChilds[]=$child->getId();
			$query = $orm->query('Reseller')
			     ->filterBy('id', 'IN', $idChilds)
				 ->orderBy('id')
				 ->attributes ($columns);
			if ($includeOwner)
				$query->filterBy('id', '=', $reseller->getId(), NULL, 'OR');
			$childs = $query->find();
		}
		return $childs;
	} else {
		if ($includeOwner) {
			if (is_null($columns)) {
				return array($reseller);
			} else {
				return $orm->query('Reseller')
				    ->filterBy('id', '=', $reseller->getId())
					->attributes($columns)
					->find();
			}
		}
		return null;
	}
    // Bouml preserved body end 0011BB05
  }

  /**
   * Devuelve el revendedor al que pertenece la sesi�n actual.
   * Debe entenderse que el REVENDEDOR es el due�o del sitio, pero que no implica que el usuario logueado sea un revendedor.
   * 
   * @return Reseller El reseller vinculado a la sesi�n en curso o FALSE si no hay ninguno (caso que NUNCA deber�a darse).
   */
  public function getCurrentReseller()
  {
    // Bouml preserved body begin 00136D05
	$orm = $this->application->getORM();
	$query = $orm->query('Reseller')
				 ->filterBy('provider.id', '=', $this->application->getContext()->getProvider()->getId());
	return $query->findOne();
    // Bouml preserved body end 00136D05
  }

  /**
   * Devuelve el cliente que inici� la sesi�n.
   * 
   * @return Client El cliente que inici� la sesi�n o FALSE si la sesi�n pertenece a un revendedor (Reseller).
   */
  public function getCurrentClient()
  {
    // Bouml preserved body begin 00136D85
	$orm = $this->application->getORM();
	if ($this->application->getContext()->getUser()) {
		$query = $orm->query('Client')
					 ->filterBy('user.id', '=', $this->application->getContext()->getUser()->getId());
		return $query->find();
	} else {
		return null;
	}
    // Bouml preserved body end 00136D85
  }

  /**
   * Recupera una lista de los ids de los resellers vinculados.
   * @param boolean $includeOwner indica si se incluye o no el id del reseller actual.
   * 
   * @return array La lista de los resellers vinculados.
   */
  public function getOwnedResellersIds($includeOwner = true)
  {
    // Bouml preserved body begin 00144E05
	function __inside($from, &$to) {
		foreach ($from as $key => $value) {
			if (is_array($value)) __inside($value, $to);
			else $to[]=$value;
		}
	}
	if (is_a($this->getCurrentReseller(), 'Reseller')) {
		$cols = array('id');
		$owners = $this->getOwnedResellers($this->getCurrentReseller(), $cols, $includeOwner);
	}
	$list=array();
	if (is_array($owners) && (count($owners) > 0)) {
		__inside($owners, $list);
	}
	return $list;
    // Bouml preserved body end 00144E05
  }

  /**
   * Notifica al facade que se ha logeado un usuario NUEVO mediante "Login Unificado".
   * 
   * @param ApplicationContext $context el contexto de la aplicación
   * @param boolean $ajax indica si el llamado es para página completa o para ser devuelto en background
   * @param User $user el usuario nuevo que se logueó
   * @param mixed $extra por el momento se pasa la respuesta del llamado a CLL_Authenticate.
   * 
   * @return boolean un booleando que es TRUE si se desea conservar el usuario o FALSE si el mismo es irrelevante o no debe tener permisos para el Facade.
   */
  public function newLoginUnificado(&$context, &$user, $extra = null)
  {
    // Bouml preserved body begin 00161F05
	return false;
	//EXTRACTADO de function_lu.php
		  
	//Verifico el CGP en base al nombre de usuario brindado por el cliente:
	$whit_mask = str_pad(substr($user->getUsername(), 0, strlen($user->getUsername())-1), 6, '0', STR_PAD_LEFT);
	// Extrae todos los digitos
	for($i=0; $i < strlen($whit_mask); $i++)
          $barcode[] = $whit_mask[$i];
	// Se queda con la parte entera del resultado
	list($calc, ) = explode('.',( $barcode[0]*1 + $barcode[1]*3 + $barcode[2]*5 + $barcode[3]*7 + $barcode[4]*9 + $barcode[5]*3 ) / 2);
	// Extrae el ultimo digito
	$verificationDigit = substr($calc,-1,1);
	
	if (substr($user->getUsername(), -1,1) == $verificationDigit) {
		$orm = $this->application->getORM();
		$reseller = $this->getCurrentReseller();
		if ($reseller) {
			$query = $orm->query('Client')
 						 ->filterBy('reseller', '=', $reseller->getId())
						 ->filterBy('clientNumber', '=', (int)substr($user->getUsername(), 0, strlen($user->getUsername())-1));
			$client = $query->findOne();
			/* @var $client Client*/
			if ($client) {
				$client->setUser($user);
				$queryProfile = $orm->query('Profile')
									->filterBy('provider', '=', $context->getProvider()->getId())
									->filterBy('name', '=', 'Cliente IUNIWholesale');
				$profile = $queryProfile->findOne();
				if ($profile) {
					$user->addProfile($profile);
					$client->save();
					return true;
				} else {
					//Si no encuentro el perfil
					throw new Exception('No fue posible configurar los permisos para IUNIWholesale');
				}
			} else {
				//Si no hay ningún cliente que coincida dentro del reseller, retorno false
				return false;
			}
		} else {
			//Si no estoy entrando con un Reseller válido entonces no estamos hablando de WholeSale :)
			return false;
		}
	} else {
		//El usuario no corresponde con un CGP, no tiene permisos para este módulo
		return false;
	}

    // Bouml preserved body end 00161F05
  }

  /**
   * Configura informaci�n general para el uso en los templates.
   * 
   * @param ApplicationContext $context el contexto de la aplicaci�n.
   * 
   * @return void 
   */
  public function registerInfo(&$context)
  {
    // Bouml preserved body begin 00162105
	$reseller = $this->getCurrentReseller();
	$context->set('Reseller', $reseller);
	$orm = $this->application->getORM();
	$query = $orm->query('Client')
				  ->filterBy('reseller.id', '=', $reseller->getId())
				  ->filterBy('user.id', '=', $context->getUser()->getId());
	$client=$query->findOne();
	if ($client) {
		$context->set('Client', $client);
	}
    // Bouml preserved body end 00162105
  }

}
?>