<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/wholesale/Client.php';
require_once 'iplan/models/wholesale/PayPlan.php';
require_once 'iplan/models/wholesale/ServiceProvider.php';
require_once 'iplan/models/wholesale/Line.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Esta clase representa un sitio o, en otras palabras, un grupo de l�neas asociadas. En algunas empresas se llaman grupos de afinidad y todas las l�neas que pertenecen al grupo generalmente hablan gratis entre s� o con descuento.
 * 
 * @method Site setDescription()
 * @method string getDescription()
 * @method Site setLocation()
 * @method string getLocation()
 * @method Site setSubscription()
 * @method string getSubscription()
 * @method Site setGroup()
 * @method string getGroup()
 * @method Site setUsername()
 * @method string getUsername()
 * @method Site setPassword()
 * @method string getPassword()
 * @method Site setStatus()
 * @method boolean getStatus()
 * @method Site setCreated()
 * @method DateTime getCreated()
 * @method Site setModified()
 * @method DateTime getModified()
 * @method Site setDisabled()
 * @method DateTime getDisabled()
 * @method Site setServiceProvider()
 * @method ServiceProvider getServiceProvider()
 * @method Site setPayPlan()
 * @method PayPlan getPayPlan()
 * @method Site setClient()
 * @method Client getClient()
 * @method ORMCollection getLines()
 * @method Site addLine()
 * @method Site delLine()
 * 
 */
class Site extends ORMObject {
  /**
   * @var Client el cliente que es due�o del sitio.
   */
  protected $client;

  /**
   * @var PayPlan el tipo de esquema de pago del sitio
   */
  protected $payPlan;

  /**
   * @var string la descripci�n del sitio
   */
  protected $description;

  /**
   * @var boolean indica si el sitio est� o no habilitado
   */
  protected $status;

  /**
   * @var DateTime la fecha en que se cre� el registro
   */
  protected $created;

  /**
   * @var DateTime la fecha de �ltima modificaci�n
   */
  protected $modified;

  /**
   * @var DateTime la fecha en que el status fue puesto en FALSE
   */
  protected $disabled;

  /**
   * @var int el identificador que se corresponde con el sitio en el sistema 10fold
   */
  protected $location;

  /**
   * @var int es el c�digo de subscripci�n del sitio en la plataforma 10fold
   */
  protected $subscription;

  /**
   * @var string el nombre del grupo de BroadSoft
   */
  protected $group;

  /**
   * @var string el nombre de usuario del grupo de BroadSoft
   */
  protected $username;

  /**
   * @var string la clave del usuario del grupo de BroadSoft
   */
  protected $password;

  /**
   * @var ServiceProvider el tipo de sitio queda determinado por el service provider
   */
  protected $serviceProvider;

  /**
   * @var ORMCollection la lista de l�neas del sitio
   */
  protected $lines;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00116305
	return parent::define($orm)
                ->setClass('Site')
				->setTable('SITIO')
				->addField('id', 'SITIO_ID', ORMDefinition::INTEGER, 8, 0, false)
				->setKey('id')
				->addInstance('client', 'CLIENTE_ID', 'Client')
				->addInstance('payPlan', 'T_PAGO_ID', 'PayPlan')
				->addField('description', 'DESCRIPCION', ORMDefinition::STRING, 255, null, true)
				->addField('status', 'ESTADO', ORMDefinition::INTEGER, 2, 0, false)
				->addField('created', 'FE_ALTA', ORMDefinition::DATE, null, null, true)
				->addField('modified', 'FE_MODIFICACION', ORMDefinition::DATE, null, null, true)
				->addField('disabled', 'FE_BAJA', ORMDefinition::DATE, null, null, true)
				->addField('location', 'LOCACION', ORMDefinition::INTEGER, 9, null, true)
				->addField('subscription', 'SUBSCRIPTION', ORMDefinition::INTEGER, 9, null, true)
				->addField('group', 'BS_GROUP', ORMDefinition::STRING, 255, null, true)
				->addField('username', 'BS_USUARIO', ORMDefinition::STRING, 255, null, true)
				->addField('password', 'BS_PASSWORD', ORMDefinition::STRING, 255, null, true)
				->addInstance('serviceProvider', 'SISTEMA_ID', 'ServiceProvider')
				->addRelation1xN('lines', 'SITIO_ID', 'Line')
				;
    // Bouml preserved body end 00116305
  }

  /**
   * Verifica si el objeto fue modificado y lo guarda.
   * Este m�todo permite abstraer a las clases descendientes de la necesidad de determinar si el objeto fue alterado o no y oculta la complejidad subyacente a las clases descendientes.
   * @param ORM $orm opcionalmente se debe indicar la instancia del ORM que mantiene el objeto. Esto s�lo es posible si el objeto es nuevo o DETACHED. En el caso que ya estuviera bajo monitoreo de un ORM arrojar� una excepci�n.
   * 
   * Se pens� en que se podr�a hacer el cambio de un ORM a otro, pero el ID deber�a limpiarse, con lo cual s�lo un INSERT se podr�a hacer sobre el destino y los objetos relacionados estar�an a�n con otro ORM lo cual es complicado (manejo de objetos distribu�dos) por lo cual se deja a consideraci�n de futuras versiones, posiblemente en otra vida =)
   */
  public function save(&$orm = null)
  {
    // Bouml preserved body begin 0012D905
	$orm = ($orm === null) ? $this->orm : $orm;
	$this->orm = $orm;
	
	$params["p_user_id"] = 1;
	$params["p_cliente_id"] = $this->getClient()->getId();
	$params["p_descripcion"] = $this->getDescription();
	$params["p_t_pago_id"] = $this->getPayPlan()->getId();
	$params["p_locacion"] = $this->getLocation();
	$params["p_subscription"] = $this->getSubscription();
	$params["p_bs_group"] = $this->getGroup();
	$params["p_bs_usuario"] = $this->getUsername();
	$params["p_bs_password"] = $this->getPassword();
	$params["p_sistema_id"] = $this->getServiceProvider()->getId();

	//(is_a($this->getServicePack(), 'ServicePack')) ? $this->getServicePack()->getId() : null;

	$db = $orm->getDatabase()->getConnection();

	$db->executeFunction("FU_SITIO_RPL", $params);
	return true;
	/*
	
	//Instancia de Database
	$dbase = $orm->getDatabase()->getConnection();
	
	require_once 'iplan/models/provisioning/ProvisioningIUNI.php';
	require_once 'iplan/models/provisioning/ProvisioningProximo.php';
	require_once 'iplan/models/provisioning/ProvisioningPlataformas.php';
	
	$bien = false;
	
	//Busca Service Provider
	$oServiceProvider = $this->getServiceProvider();
	if (!is_a($oServiceProvider, "ServiceProvider")) 
		throw new Exception ("El sitio debe tener un Service Provider asignado");
	
	$oCliente = $this->getClient();
	if (!is_a($oCliente, "Client"))
		throw new Exception ("El sitio debe tener un Cliente asociado");
	
	if (!$this->getId()) {
		//Sitio nuevo Validaciones
		//No repetir locacion si el estado es activo, si es inactivo, la pisamos y listo.
		if ($this->getLocation()) {
			$oSiteValidate = $orm->query("Site")->filterBy("location", "=", $this->getLocation())->findOne();
			if ((is_a($oSiteValidate, "Site")) && ($oSiteValidate->getStatus() == "1")) {
				//Activa
				throw new Exception("Ya existe el sitio con ID " . $this->getLocation() . " asignado al cliente " . $oSiteValidate->getClient()->getName());
			}
		}
	}
	
	if (($this->getId() == null) || ($this->isAttributeModified("status") && $this->getStatus() == "1") ) {
		//Si es nuevo doy la alta en Broadsoft
		$serviceProvider = $oServiceProvider->getIdentifier();
		
		//Instancia de LOG
		$log = LogMessages::GetInstance($dbase, 1);
		$log->getMensajes();

		//Instancia de Broadsoft
		$bsws = BroadsoftXMLWS::getInstance(BroadsoftXMLWS::WSDL_WS, BroadsoftXMLWS::USER_WS, BroadsoftXMLWS::PASSWORD_WS, $log);

		
		switch ($oServiceProvider->getProduct()->getId()) {
			case "1":
				//Proximo
				//Instancia de Provisioning
				$provisioningProximo = new ProvisioningProximo($bsws, $log, $dbase, 1);
				
				$clienteProximo = new ClienteProximo($oCliente->getClientNumber(), $oCliente->getName());
				$clienteProximo->setAddress($this->getDescription());
				$clienteProximo->setContactEmail($oCliente->getMail());
				$clienteProximo->setContactLastName($oCliente->getContactLastName());
				$clienteProximo->setContactName($oCliente->getContactName());
				$clienteProximo->setContactNumber($oCliente->getPhone());
				$clienteProximo->setContactNumber2($oCliente->getAlternativePhone());
				$clienteProximo->setGroupName($this->getGroup());
				$clienteProximo->setLocacionID($this->getLocation());
				$clienteProximo->setServiceProvider($serviceProvider);
				
				$busquedaGrupo = $provisioningProximo->SearchGroup($clienteProximo->getGroupName(), $serviceProvider);
				if (is_array($busquedaGrupo) && (count($busquedaGrupo) > 0)) {
					throw new Exception("Ya existe en Broadsoft un grupo con el ID " . $clienteProximo->getGroupName());
				}
				//Doy el alta
				$resAlta = $provisioningProximo->AddClienteProximo($clienteProximo);

				if (is_array($resAlta) && isset($resAlta) && ($resAlta["estado"] === "ok"))  {
					$bien = true;
				} else {
					$desc = ProvisioningPlataformas::erroresAString($resAlta["Resultados"]);
					throw new Exception($desc);
				}
				
				//throw new Exception("Finish Proximo....");
				break;
			case "2":
				//Central Virtual
				//Instancia de Provisioning
				$provisioningIUNI = new ProvisioningIUNI($bsws, $log, $dbase, 1);

				//Cargo los datos de la central
				$central = new CentralIUNI($oCliente->getClientNumber(), $oCliente->getName());
				$central->setAddress($this->getDescription());
				$central->setContactEmail($oCliente->getMail());
				$central->setContactLastName($oCliente->getContactLastName());
				$central->setContactName($oCliente->getContactName());
				$central->setContactNumber($oCliente->getPhone());
				$central->setContactNumber2($oCliente->getAlternativePhone());
				$central->setGroupNameDB($this->getGroup());
				$central->setLocacionID($this->getLocation());
				$central->setPasswdWebBS($this->getPassword());
				$central->setServiceProvider($serviceProvider);
				$central->setUserWebBS($this->getUsername());

				$busquedaGrupo = $provisioningIUNI->SearchGroup($central->getGroupNameDB(), $serviceProvider);
				if (is_array($busquedaGrupo) && (count($busquedaGrupo) > 0)) {
					throw new Exception("Ya existe en Broadsoft un grupo con el ID " . $central->getGroupNameDB());
				}
				//Doy el alta
				$resAlta = $provisioningIUNI->AddCentralIUNI($central);

				if (is_array($resAlta) && isset($resAlta) && ($resAlta["estado"] === "ok"))  {
					$bien = true;
				} else {
					$desc = ProvisioningPlataformas::erroresAString($resAlta["Resultados"]);
					throw new Exception($desc);
				}
				break;
			default:
				//No hay definiciones para otro producto
				throw new Exception("No se especifico un Broadsoft Service Provider correcto");
		}
		
		
	} else {
		$bien = true;
	}	

	if ($bien) {
		$params["p_user_id"] = 1;
		$params["p_cliente_id"] = $this->getClient()->getId();
		$params["p_descripcion"] = $this->getDescription();
		$params["p_t_pago_id"] = $this->getPayPlan()->getId();
		$params["p_locacion"] = $this->getLocation();
		$params["p_subscription"] = $this->getSubscription();
		$params["p_bs_group"] = $this->getGroup();
		$params["p_bs_usuario"] = $this->getUsername();
		$params["p_bs_password"] = $this->getPassword();
		$params["p_sistema_id"] = $this->getServiceProvider()->getId();

		$result = null;
		$lala = $dbase->executeFunction("PKG_WEB_SITIO.FU_SITIO_RPL", $params, $result, Connection::T_CURSOR);
		$asd = $dbase->fetch($lala);
		$dbase->free($lala);
		//var_dump($asd);
		//return true;
		if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
			$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
			throw new Exception($desc);
		} 
		return true;
	} else {
		throw new Exception("Error desconocido al alta");
	}*/
    // Bouml preserved body end 0012D905
  }

  /**
   * Borra f�sicamente un objeto de la base. Al borrarse el objeto adem�s se ponen a null los campos de las entidades relacionadas que lo referenciaban y se eliminan los registros de las tablas relaci�n M:N
   * 
   * @return boolean un booleando TRUE si la operaci�n fue concretada con �xito o FALSE sino.
   */
  public function delete()
  {
    // Bouml preserved body begin 0012D985
	 $orm = ($orm === null) ? $this->orm : $orm;
	$this->orm = $orm;
	
	$params["p_user_id"] = 1;
	$params["p_sitio_id"] = (int)$this->getId();
	//(is_a($this->getServicePack(), 'ServicePack')) ? $this->getServicePack()->getId() : null;
	
	$db = $orm->getDatabase()->getConnection();
	
	$db->executeFunction("FU_SITIO_DEL", $params);
	return true;
	/*
	$orm = $this->orm;
	
	//Instancia de Database
	$dbase = $orm->getDatabase()->getConnection();
	
	require_once 'iplan/models/provisioning/ProvisioningIUNI.php';
	require_once 'iplan/models/provisioning/ProvisioningProximo.php';
	require_once 'iplan/models/provisioning/ProvisioningPlataformas.php';
	
	//Busca Service Provider
	$oServiceProvider = $this->getServiceProvider();
	if (!is_a($oServiceProvider, "ServiceProvider")) 
		throw new Exception("El sitio debe tener un Service Provider asignado");
	
	$oCliente = $this->getClient();
	if (!is_a($oCliente, "Client"))
		throw new Exception("El sitio debe tener un Cliente asociado");
	
	$serviceProvider = $oServiceProvider->getIdentifier();
	
	//Instancia de Database
	$dbase = $orm->getDatabase()->getConnection();

	//Instancia de LOG
	$log = LogMessages::GetInstance($dbase, 1);
	$log->getMensajes();

	//Instancia de Broadsoft
	$bsws = BroadsoftXMLWS::getInstance(BroadsoftXMLWS::WSDL_WS, BroadsoftXMLWS::USER_WS, BroadsoftXMLWS::PASSWORD_WS, $log);

	
	switch ($oServiceProvider->getProduct()->getId()) {
		case "1":
			//Proximo
			//Instancia de Provisioning
			$provisioningProximo = new ProvisioningProximo($bsws, $log, $dbase, 1);
			$busquedaGrupo = $provisioningProximo->SearchGroup($this->getGroup(), $serviceProvider);
			if (is_array($busquedaGrupo) && (count($busquedaGrupo) > 0)) {
				$clienteProximo = new ClienteProximo($oCliente->getClientNumber(), $oCliente->getName());
				$clienteProximo->setServiceProvider($serviceProvider);
				$clienteProximo->setGroupName($this->getGroup());

				//$resDel = $provisioningIUNI->DeleteCentralIUNINameDB($central);
				$resDel = $provisioningProximo->DeleteClienteProximo($clienteProximo);
				if (is_array($resDel) && isset($resDel) && ($resDel["estado"] === "ok"))  {
					$bien = true;
				} else {
					$desc = ProvisioningPlataformas::erroresAString($resDel["Resultados"]);
					throw new Exception($desc);
				}
			}
			//throw new Exception("Comportamiento para Proximo no definido");
			break;
		case "2":
			//Central Virtual
			//Instancia de Provisioning
			$provisioningIUNI = new ProvisioningIUNI($bsws, $log, $dbase, 1);
			$busquedaGrupo = $provisioningIUNI->SearchGroup($this->getGroup(), $serviceProvider);
			if (is_array($busquedaGrupo) && (count($busquedaGrupo) > 0)) {
				$central = new CentralIUNI($oCliente->getClientNumber(), $oCliente->getName());
				$central->setServiceProvider($serviceProvider);
				$central->setGroupNameDB($this->getGroup());

				$resDel = $provisioningIUNI->DeleteCentralIUNINameDB($central);
				if (is_array($resDel) && isset($resDel) && ($resDel["estado"] === "ok"))  {
					$bien = true;
				} else {
					$desc = ProvisioningPlataformas::erroresAString($resDel["Resultados"]);
					throw new Exception($desc);
				}
			}
			break;
		default:
			//No hay definiciones para otro producto
			break;
	}
	
	//Lo Elimino
	$params["p_user_id"] = 1;
	$params["p_sitio_id"] = (int)$this->getId();
	
	$result = null;
	$lala = $dbase->executeFunction("PKG_WEB_SITIO.FU_SITIO_DEL", $params, $result, Connection::T_CURSOR);
	$asd = $dbase->fetch($lala);
	$dbase->free($lala);
	
	if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
		$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
		throw new Exception($desc);
	}
	return true;*/
    // Bouml preserved body end 0012D985
  }

}
?>
