<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/wholesale/Reseller.php';
require_once 'iplan/models/wholesale/ServicePack.php';
require_once 'iplan/models/wholesale/Resource.php';
require_once 'iplan/models/wholesale/Product.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Un "service provider" es el nombre que se le da en BroadSoft a los tipos de central preconfigurados por IPlan para la venta.
 * 
 * @method ServiceProvider setDescription()
 * @method string getDescription()
 * @method ServiceProvider setIdentifier()
 * @method string getIdentifier()
 * @method Reseller getReseller()
 * @method ServiceProvider setReseller()
 * 
 * 
 */
class ServiceProvider extends ORMObject {
  /**
   * @var string la descripci�n del service provider, por lo general un "producto" de Marketing
   */
  protected $description;

  /**
   * @var string el identificador del "Service Provider" en BroadSoft
   */
  protected $identifier;

  /**
   * @var Reseller el reseller que usan este service provider. Puede ser nulo.
   */
  protected $reseller;

  /**
   * @var ORMCollection una lista de los Service Pack que tiene habilitado el Provider
   */
  protected $servicePacks;

  /**
   * @var ORMCollection lista los Resellers que tienen acceso a configurar ciertos recursos
   */
  protected $resources;

  /**
   * @var Product El producto para el cual fue creado el service provider.
   */
  protected $product;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00116105
	// 
	return parent::define($orm)
                ->setClass('ServiceProvider')
				->setTable('SERVICE_PROVIDER')
				->addField('id', 'SERVICEPROVIDER_ID', ORMDefinition::INTEGER, 8, 0, false)
				->setKey('id')
				->addField('description', 'DESCRIPCION', ORMDefinition::STRING, 255, null, true)
				->addField('identifier', 'IDENTIFICADOR', ORMDefinition::STRING, 255, null, true)
				->addInstance('reseller', 'LICENCIATARIO_ID', 'Reseller')
				->addInstance('product', 'PRODUCTO_ID', 'Product')
				->addRelationNxM('servicePacks', 'TIPOLICENCIA_SERVICE_PROVIDER', 'SERVICEPROVIDER_ID', 'ServicePack', 'T_LICENCIA_ID')
				->addRelationNxM('resources', 'RECURSOS_SERVICEPROVIDER', 'SERVICEPROVIDER_ID', 'Resource')
				;
    // Bouml preserved body end 00116105
  }

}
?>