<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/wholesale/ServiceProvider.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Jorge Alexis Viqueira
* 
*/
class ServicePack extends ORMObject {
  /**
   * @var string una descripci�n del paquete de servicios
   */
  protected $description;

  /**
   * @var ORMCollection una lista de los Providers que tienen autorizaci�n para usar el Service Pack
   */
  protected $providers;

  /**
   * @var string Un nombre de variable utilizado por los servicios de provisioning.
   * 
   */
  protected $attributeName;

  /**
   * @var string Si este campo tiene un valor corresponde a un atributo de la clase
   */
  protected $fieldName;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 0011EE85
	return parent::define($orm)
					->setClass('ServicePack')
					->setTable('TIPOLICENCIA')
					->addField('id', 'T_LICENCIA_ID', ORMDefinition::INTEGER, 8, 0, false)
					->setKey('id')
					->addField('description', 'DESCRIPCION', ORMDefinition::STRING, 255, false, true)
					->addField('attributeName', 'ATRIBUTO', ORMDefinition::STRING, 50, false, true)
					->addField('fieldName', 'FIELDNAME', ORMDefinition::STRING, 50, false, true)
					->addRelationNxM('providers', 'TIPOLICENCIA_SERVICE_PROVIDER', 'T_LICENCIA_ID', 'ServiceProvider', 'SERVICEPROVIDER_ID', ORM_LOAD_STYLE::LAZY_LOAD)
					;
    // Bouml preserved body end 0011EE85
  }

}
?>