<?php
require_once 'iplan/models/wholesale/ServiceProvider.php';
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Un Resource es una caracter�stica configurable de la plataforma o producto que se le vende al cliente.
 * 
 * @method Resource setDescription()
 * @method string getDescription()
 * @method Resource setField()
 * @method string getField()
 * @method ORMCollection getResellers()
 * @method Resource addReseller()
 * @method Resource delReseller()
 * 
 */
class Resource extends ORMObject {
  /**
   * @var string la descripci�n del resource
   */
  protected $description;

  /**
   * @var string se trata de una forma de una forma de saber qu� campo marcar en la tabla de lineas para habilitar/deshabilitar el feature.
   */
  protected $field;

  /**
   * @var ORMCollection indica los recursos que est�n relacionados a un ServiceProvider
   */
  protected $serviceProviders;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00116085
	return parent::define($orm)
                ->setClass('Resource')
				->setTable('RECURSOS')
				->addField('id', 'RECURSO_ID', ORMDefinition::INTEGER, 8, 0, false)
				->setKey('id')
				->addField('description', 'DESCRIPCION', ORMDefinition::STRING, 255, null, true)
				->addField('field', 'CAMPO', ORMDefinition::STRING, 255, null, true)
				->addRelationNxM('serviceProviders', 'RECURSOS_SERVICEPROVIDER', 'RECURSO_ID', 'ServiceProvider', 'SERVICEPROVIDER_ID')
				;
    // Bouml preserved body end 00116085
  }

}
?>