<?php
require_once 'iplan/models/wholesale/NumerationBlock.php';
require_once 'iplan/models/wholesale/Client.php';
require_once 'iplan/security/Provider.php';
require_once 'iplan/models/wholesale/ServiceProvider.php';
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/wholesale/PricesList.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Un Reseller (revendedor) es alguien que puede crear clientes y administrarlos. Un Reseller tambin puede crear y administrar otros Resellers dependiendo de l.
 * 
 * @method Reseller setPrefix()
 * @method string getPrefix()
 * @method Reseller setTenfoldId()
 * @method string getTenfoldId()
 * @method Reseller setAccountAndOrder()
 * @method boolean getAccountAndOrder()
 * @method Reseller setStatus()
 * @method boolean getStatus()
 * @method Reseller setCreated()
 * @method DateTime getCreated()
 * @method Reseller setModified()
 * @method DateTime getModified()
 * @method Reseller setDisabled()
 * @method DateTime getDisabled()
 * @method ORMCollection getBlocks()
 * @method Reseller addBlock()
 * @method Reseller delBlock()
 * @method ORMCollection getResources()
 * @method Reseller addResource()
 * @method Reseller delResource()
 * @method ORMCollection getClients()
 * @method Reseller addClient()
 * @method Reseller delClient()
 * @method ORMCollection getServiceProviders()
 * @method Reseller addServiceProvider()
 * @method Reseller delServiceProvider()
 * @method Reseller setProvider()
 * @method Provider getProvider()
 * @method Reseller addPricesList()
 * @method ORMCollection getPricesLists()
 * @method Rseller setPricesLists()
 * 
 */
class Reseller extends ORMObject {
  /**
   * @var string TODO
   */
  protected $prefix;

  /**
   * @var string el identificador del Reseller en 10fold
   */
  protected $tenfoldId;

  /**
   * @var ORMCollection son los bloques asignados al Reseller para su administracin
   */
  protected $blocks;

  /**
   * @var ORMCollection la lista de clientes del Reseller
   */
  protected $clients;

  /**
   * @var Provider el usuario provider que le corresponde al Reseller
   */
  protected $provider;

  /**
   * @var ORMCollection un Reseller puede tener una o ms particiones de BroadSoft para l. Esto se agrega para ser compatible con la estructura de tablas existentes.
   */
  protected $serviceProviders;

  /**
   * @var boolean indica si el Reseller trabaja por cuenta y orden de la empresa. Probablemente la traduccin hubiese sido "out on behalf and by order" pero no daba poner ese nombre.
   */
  protected $accountAndOrder;

  /**
   * @var string el nombre del revendedor. Este campo qued ac por razones histricas.
   */
  protected $name;

  /**
   * @var boolean indica si el Reseller est habilitado o no.
   */
  protected $status;

  /**
   * @var DateTime la fecha en que se cre el registro
   */
  protected $created;

  /**
   * @var DateTime la fecha de ltima modificacin
   */
  protected $modified;

  /**
   * @var DateTime la fecha en que el status fue puesto en FALSE
   */
  protected $disabled;

  /**
   * @var ORMCollection la coleccin de las listas de precios del revendedor
   */
  protected $pricesLists;

  /**
   * Retorna un objeto de definicin predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definicin
   * @return ORMDefinition la definicin default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00116005
		return parent::define($orm)
                ->setClass('Reseller')
				->setTable('LICENCIATARIO')
				->addField('id', 'LICENCIATARIO_ID', ORMDefinition::INTEGER, 8, 0, false)
				->setKey('id')
				->addField('name', 'RAZON_SOCIAL', ORMDefinition::STRING, 255)//Mucho, no?
				->addField('prefix', 'PREFIX', ORMDefinition::STRING, 10, null, true)
				->addField('tenfoldId', 'TENFOLD_ID', ORMDefinition::STRING, 255, null, true)
				->addRelation1xN('blocks', 'LICENCIATARIO_ID', 'NumerationBlock')
				->addField('accountAndOrder', 'FL_CUENTA_ORDEN', ORMDefinition::INTEGER, 2, 0, false)
				->addField('status', 'ESTADO', ORMDefinition::INTEGER, 2, 0, false)
				->addField('created', 'FE_ALTA', ORMDefinition::DATE, null, null, false, 'NOW()')
				->addField('modified', 'FE_MODIFICACION', ORMDefinition::DATE, null, null, true)
				->addField('disabled', 'FE_BAJA', ORMDefinition::DATE, null, null, true)
				->addInstance('provider', 'PROVIDER_ID', 'Provider')
				->addRelation1xN('clients', 'LICENCIATARIO_ID', 'Client')
				->addRelation1xN('serviceProviders', 'LICENCIATARIO_ID', 'ServiceProvider')
				->addRelation1xN('pricesLists', 'LICENCIATARIO_ID', 'PricesList')
				;
    // Bouml preserved body end 00116005
  }

}
?>