<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Representa los tipos de recepcionista. Lo mismo que una clase podra haber sido un tipo enumerado pero se eligi esta representacin.
 * 
 * @method RecepcionistType setDescription()
 * @method string getDescription()
 */
class RecepcionistType extends ORMObject {
  /**
   * @var string la descripcin del tipo de recepcionista. Puede ser...
   */
  protected $description;

  /**
   * @var string atributo que referencia un atributo de la clase de autoaprovisionamiento. Uso interno.
   */
  protected $attributeName;

  /**
   * Retorna un objeto de definicin predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definicin
   * @return ORMDefinition la definicin default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00116485
	return parent::define($orm)
					->setClass('RecepcionistType')
					->setTable('TIPORECEPCIONISTA')
					->addField('id', 'T_RECEPCIONISTA_ID', ORMDefinition::INTEGER, 8, 0, false)
					->setKey('id')
					->addField('description', 'DESCRIPCION', ORMDefinition::STRING, 255, true, true)
					->addField('attributeName', 'ATRIBUTO', ORMDefinition::STRING, 50, true, true)
					;
    // Bouml preserved body end 00116485
  }

}
?>