<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/wholesale/Price.php';
require_once 'iplan/models/wholesale/Site.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Es una tarifa. Se diferencia del precio (Price) en que la tarifa es lo que se le cobra a un sitio en particular. Es decir podr�a haber varios precios para un grupo de prefijo de entrada y uno de salida y esta entidad es la que relaciona el sitio con el precio puntual a cobrar en ese caso para un sitio.
 */
class Rate extends ORMObject {
  /**
   * @var boolean indica si el sitio est� o no habilitado
   */
  protected $status;

  /**
   * @var DateTime la fecha en que se cre� el registro
   */
  protected $created;

  /**
   * @var DateTime la fecha de �ltima modificaci�n
   */
  protected $modified;

  /**
   * @var DateTime la fecha en que el status fue puesto en FALSE
   */
  protected $disabled;

  /**
   * @var price el precio definido por el reseller al que aplica la tarifa
   */
  protected $price;

  /**
   * @var Site el sitio para el que rige esta tarifa.
   */
  protected $site;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00120C85
	return parent::define($orm)
			->setTable('TARIFAS')
			->addField('id', 'TARIFA_ID', ORMDefinition::INTEGER, 8)
			->setKey('id')
			->addField('status', 'ESTADO', ORMDefinition::INTEGER, 2, 0, false)
			->addField('created', 'FE_ALTA', ORMDefinition::DATE, null, null, false, 'NOW()')
			->addField('modified', 'FE_MODIFICACION', ORMDefinition::DATE, null, null, true)
			->addField('disabled', 'FE_BAJA', ORMDefinition::DATE, null, null, true)
			->addInstance('price', 'PRECIO_ID', 'Price')
			->addInstance('site', 'SITIO_ID', 'Site');
    // Bouml preserved body end 00120C85
  }

}
?>