<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Jorge Alexis Viqueira
* 
*/
class Product extends ORMObject {
  /**
   * @var string La descripci�n del producto iPlan
   */
  protected $description;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00150C85
	return parent::define($orm)
				->setClass('Product')
				->setTable('PRODUCTO')
				->addField('id', 'PRODUCTO_ID', ORMDefinition::INTEGER, 8)
				->setKey('id')
				->addField('description', 'DESCRIPCION', ORMDefinition::STRING, 50);
    // Bouml preserved body end 00150C85
  }

}
?>