<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/wholesale/Price.php';
require_once 'iplan/models/wholesale/Reseller.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Una lista de precios del sistema
 * 
 * @method DateTime getUploaded()
 * @method PricesList setUploaded()
 * @method PricesList setDescription()
 * @mehtod string getDescription()
 * @method PricesList setFile()
 * @method string getFile()
 * @method PricesList setReseller()
 * @method Reseller getReseller()
 * @method PricesList addPrice()
 * @method PricesList setPrices()
 * @method ORMCollection getPrices()
 */
class PricesList extends ORMObject {
  /**
   * @var DateTime la fecha de subida
   */
  protected $uploaded;

  /**
   * @var string una breve descripci�n textual
   */
  protected $description;

  /**
   * @var string el nombre del archivo que se subi�
   */
  protected $file;

  /**
   * @var ORMCollection la colecci�n de precios que se nuclean bajo esta lista.
   */
  protected $prices;

  /**
   * @var Reseller el revendedor que subi� la lista.
   */
  protected $reseller;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00141385
	return parent::define($orm)
					->setTable('LISTAPRECIO')
					->addField('id', 'LISTAPRECIO_ID', ORMDefinition::INTEGER, 8, 0, false)
					->setKey('id')
					->addField('uploaded', 'LISTAPRECIO_SUBIDA', ORMDefinition::DATETIME)
					->addField('description', 'LISTAPRECIO_DESCRIPCION', ORMDefinition::STRING, 30)
					->addField('file', 'LISTAPRECIO_ARCHIVO', ORMDefinition::STRING, 255)
					->addInstance('reseller', 'LICENCIATARIO_ID', 'Reseller')
					->addRelation1xN('prices', 'LISTAPRECIO_ID', 'Price');
    // Bouml preserved body end 00141385
  }

}
?>