<?php
require_once 'iplan/models/wholesale/Currency.php';
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/wholesale/Reseller.php';
require_once 'iplan/models/wholesale/PrefixGroupOut.php';
require_once 'iplan/models/wholesale/PrefixGroupIn.php';
require_once 'iplan/models/wholesale/FractionationType.php';
require_once 'iplan/models/wholesale/Rate.php';
require_once 'iplan/models/wholesale/PricesList.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Representa un precio del sistema.
 * 
 * @method Price setDescription()
 * @method string getDescription()
 * @method Price setValue()
 * @method float getValue()
 * @method Price setStatus()
 * @method boolean getStatus()
 * @method Price setCreated()
 * @method DateTime getCreated()
 * @method Price setModified()
 * @method DateTime getModified()
 * @method Price setDisabled()
 * @method DateTime getDisabled()
 * @method Price setPricesList()
 * @method PricesList getPricesList()
 */
class Price extends ORMObject {
  /**
   * @var string una descripci�n de la moneda
   */
  protected $description;

  /**
   * @var float el monto del precio
   */
  protected $value;

  /**
   * @var boolean indica si el sitio est� o no habilitado
   */
  protected $status;

  /**
   * @var DateTime la fecha en que se cre� el registro
   */
  protected $created;

  /**
   * @var DateTime la fecha de �ltima modificaci�n
   */
  protected $modified;

  /**
   * @var DateTime la fecha en que el status fue puesto en FALSE
   */
  protected $disabled;

  /**
   * @var Currency el tipo de moneda
   */
  protected $currency;

  /**
   * @var Reseller el revendedor al que pertenece el precio
   */
  protected $reseller;

  /**
   * @var PrefixGroupOut el grupo de prefijo al que pertenece el n�mero destino
   */
  protected $groupOut;

  /**
   * @var PrefixGroupIn el grupo al que pertenece la caracter�stica que reliza la llamada
   */
  protected $groupIn;

  /**
   * @var FractionationType el tipo de fraccionamiento al que aplica el precio
   */
  protected $fractionationType;

  /**
   * @var ORMCollection las tarifas a las cuales se aplica el precio actual
   */
  protected $rates;

  /**
   * @var PriceList la lista de precios a la que pertenece.
   */
  protected $pricesList;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 0011EF05
	return parent::define($orm)
				->setTable('PRECIO')
				->addField('id', 'PRECIO_ID', ORMDefinition::INTEGER, 8)
				->setKey('id')
				->addField('value', 'VALOR', ORMDefinition::DECIMAL, 12, 4)
				->addField('description', 'DESCRIPCION', ORMDefinition::STRING, 255)
				->addField('status', 'ESTADO', ORMDefinition::INTEGER, 2, 0, false)
				->addField('created', 'FE_ALTA', ORMDefinition::DATE, null, null, false, 'NOW()')
				->addField('modified', 'FE_MODIFICACION', ORMDefinition::DATE, null, null, true)
				->addField('disabled', 'FE_BAJA', ORMDefinition::DATE, null, null, true)
				->addInstance('fractionationType', 'T_FRACCIONAMIENTO_ID', 'FractionationType')
				->addInstance('groupIn', 'G_PREFIJO_IN', 'PrefixGroupIn')
				->addInstance('groupOut', 'G_PREFIJO_ID', 'PrefixGroupOut')
				->addInstance('reseller', 'LICENCIATARIO_ID', 'Reseller')
				->addInstance('currency', 'MONEDA_ID', 'Currency')
				->addRelation1xN('rates', 'PRECIO_ID', 'Rate')
				->addInstance('pricesList', 'LISTAPRECIO_ID', 'PricesList');
    // Bouml preserved body end 0011EF05
  }

}
?>