<?php
require_once 'iplan/models/wholesale/Prefix.php';
require_once 'iplan/models/wholesale/PrefixGroupIn.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * La especializaci�n del prefijo saliente.
 * 
 * @method PrefixGroupIn getPrefixGroup()
 * @method PrefixIn setPrefixGroup()
 */
class PrefixIn extends Prefix {
  /**
   * @var PrefixGroupIn el grupo de prefijos de entrada al que pertenece el prefijo
   */
  protected $prefixGroup;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 0011F205
	return parent::define($orm)
				   ->setTable('PREFIJOS_IN')
				   ->addField('id', 'PREFIJO', ORMDefinition::STRING, 255)
				   ->setKey('id')
				   ->addField('description', 'DESCRIPCION', ORMDefinition::STRING, 255)
				   ->addField('status', 'ESTADO', ORMDefinition::INTEGER, 2, 0, false)
				   ->addField('created', 'FE_ALTA', ORMDefinition::DATE, null, null, false, 'NOW()')
				   ->addField('modified', 'FE_MODIFICACION', ORMDefinition::DATE, null, null, true)
				   ->addField('disabled', 'FE_BAJA', ORMDefinition::DATE, null, null, true)
				   ->addInstance('reseller', 'LICENCIATARIO_ID', 'Reseller')
				   ->addInstance('mode', 'MODALIDAD_ID', 'Mode')
				   ->addInstance('prefixType', 'T_PREFIJO_ID', 'PrefixType')
				   ->addInstance('prefixGroup', 'G_PREFIJO_IN_ID', 'PrefixGroupIn');
    // Bouml preserved body end 0011F205
  }

}
?>