<?php
require_once 'iplan/models/wholesale/PrefixGroup.php';
require_once 'iplan/models/wholesale/PrefixOut.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Una especializaci�n del Grupo de Prefijos para consignar s�lo los grupos de salida.
 * 
 * @method ORMCollection getPrefixes()
 * @method PrefixGroupOut setPrefixes()
 * @method PrefixGroupOut addPrefix()
 * @method PrefixGroupOut delPrefix()
 */
class PrefixGroupOut extends PrefixGroup {
  /**
   * @var ORMCollection la lista de prefijos de salida del grupo
   */
  protected $prefixes;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 0011F185
	return parent::define($orm)
				->setTable('GRUPOPREFIJO')
				->addField('id', 'G_PREFIJO_ID', ORMDefinition::INTEGER, 8)
				->setKey('id')
				->addField('description', 'DESCRIPCION', ORMDefinition::STRING, 255)
				->addField('status', 'ESTADO', ORMDefinition::INTEGER, 2, 0, false)
				->addField('created', 'FE_ALTA', ORMDefinition::DATE, null, null, false, 'NOW()')
				->addField('modified', 'FE_MODIFICACION', ORMDefinition::DATE, null, null, true)
				->addField('disabled', 'FE_BAJA', ORMDefinition::DATE, null, null, true)
				->addInstance('reseller', 'LICENCIATARIO_ID', 'Reseller')
				->addRelation1xN('prefixes', 'G_PREFIJO_IN_ID', 'PrefixOut');
    // Bouml preserved body end 0011F185
  }

}
?>