<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/wholesale/Reseller.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Un grupo de prefijo es una entidad que agrupa varios prefijos. En el sistema no compartan datos en comn por lo cual por ms que ac haya herencia no guardan relacin algun los grupos de IN y OUT.
 * 
 * @method string getDescription()
 * @methos PrefixGroup setDescription()
 * @method PrefixGroup setStatus()
 * @method boolean getStatus()
 * @method PrefixGroup setCreated()
 * @method DateTime getCreated()
 * @method PrefixGroup setModified()
 * @method DateTime getModified()
 * @method PrefixGroup setDisabled()
 * @method DateTime getDisabled()
 * @method Reseller getReseller()
 * @method PrefixGroup setReseller()
 * 
 */
abstract class PrefixGroup extends ORMObject {
  /**
   * @var string una descripcin del grupo de prefijos
   */
  protected $description;

  /**
   * @var DateTime la fecha en que se cre el registro
   */
  protected $created;

  /**
   * @var boolean indica si el sitio est o no habilitado
   */
  protected $status;

  /**
   * @var DateTime la fecha de ltima modificacin
   */
  protected $modified;

  /**
   * @var DateTime la fecha en que el status fue puesto en FALSE
   */
  protected $disabled;

  private $reseller;

  /**
   * Retorna un objeto de definicin predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definicin
   * @return ORMDefinition la definicin default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 0011F105
	return parent::define($orm);
    // Bouml preserved body end 0011F105
  }

}
?>