<?php
require_once 'iplan/models/wholesale/Mode.php';
require_once 'iplan/models/wholesale/PrefixType.php';
require_once 'iplan/models/wholesale/Reseller.php';
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Un prefijo representa una caracter�stica telef�nica de zona. Son los primeros d�gitos del n�mero.
 * Al igual que en el caso de Grupo de Prefijos, el modelo de datos entre prefijos de entrada y salida es redundante y totalmente disociado.
 * 
 * @method string getDescription()
 * @methos PrefixGroup setDescription()
 * @method PrefixGroup setStatus()
 * @method boolean getStatus()
 * @method PrefixGroup setCreated()
 * @method DateTime getCreated()
 * @method PrefixGroup setModified()
 * @method DateTime getModified()
 * @method PrefixGroup setDisabled()
 * @method DateTime getDisabled()
 * @method Reseller getReseller()
 * @method PrefixGroup setReseller()
 * 
 */
abstract class Prefix extends ORMObject {
  /**
   * @var string una descripci�n del prefijo. Generalmente el nombre de la localidad.
   */
  protected $description;

  /**
   * @var DateTime la fecha en que se cre� el registro
   */
  protected $created;

  /**
   * @var boolean indica si el sitio est� o no habilitado
   */
  protected $status;

  /**
   * @var DateTime la fecha de �ltima modificaci�n
   */
  protected $modified;

  /**
   * @var DateTime la fecha en que el status fue puesto en FALSE
   */
  protected $disabled;

  /**
   * @var Mode la modalidad del prefijo
   */
  protected $mode;

  /**
   * @var PrefixType el tipo de prefijo, generalmente LDI o LDN
   */
  protected $prefixType;

  /**
   * @var Reseller el revendedor al que pertenece el prefijo.
   */
  protected $reseller;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 0011F005
	return parent::define($orm);
    // Bouml preserved body end 0011F005
  }

}
?>