<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Se trata del plan de pago que tiene el un sitio.
 * 
 * @method PayPlan setDescription()
 * @method string getDescription()
 */
class PayPlan extends ORMObject {
  /**
   * @var string la descripcin del plan de pago
   */
  protected $description;

  /**
   * Retorna un objeto de definicin predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definicin
   * @return ORMDefinition la definicin default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00116285
	return parent::define($orm)
                ->setClass('PayPlan')
				->setTable('TIPOPAGO')
				->addField('id', 'T_PAGO_ID', ORMDefinition::INTEGER, 8, 0, false)
				->setKey('id')
				->addField('description', 'DESCRIPCION', ORMDefinition::STRING, 255, null, true)
				;
    // Bouml preserved body end 00116285
  }

}
?>