<?php
require_once 'iplan/models/wholesale/Reseller.php';
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Representa un rango de n�meros de l�neas que se asigna a un Reseller para su distribuci�n entre sus clientes y revendedores.
 * 
 * @method int getFrom()
 * @method NumerationBlock setFrom()
 * @method int getTo()
 * @method NumerationBlock setTo()
 * @method NumerationBlock setReseller()
 * @method Reseller getReseller()
 */
class NumerationBlock extends ORMObject {
  /**
   * @var int el primer n�mero del rango
   */
  protected $from;

  /**
   * @var int el n�mero donde termina el rango
   */
  protected $to;

  /**
   * @var Reseller es el propietario del bloque. Puede ser nulo y en cuyo caso se trata de un bloque disponible.
   */
  protected $reseller;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00116185
		return parent::define($orm)
                ->setClass('NumerationBlock')
				->setTable('BLOQUES')
				->addField('id', 'BLOQUE_ID', ORMDefinition::INTEGER, 8, 0, false)
				->setKey('id')
				->addField('from', 'FROM_NUMBER', ORMDefinition::STRING, 20, null, true)
				->addField('to', 'TO_NUMBER', ORMDefinition::STRING, 20, null, true)
				->addInstance('reseller', 'LICENCIATARIO_ID', 'Reseller');
    // Bouml preserved body end 00116185
  }

}
?>