<?php
require_once 'iplan/orm/ORM.php';
require_once 'iplan/orm/ORMObject.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Describe el tipo de llamada:
 * MPP = Cobro Revertido
 * SBT = Fijo
 * CPP = Celular
 */
class Mode extends ORMObject {
  /**
   * @var string La descripci�n del tipo de modalidad
   */
  protected $description;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 0011F305
	return parent::define($orm)
					->setTable('MODALIDAD')
					->addField('id', 'MODALIDAD_ID', ORMDefinition::INTEGER, 8, 0, false)
					->setKey('id')
					->addField('description', 'DESCRIPCION', ORMDefinition::STRING, 255, true, true);
    // Bouml preserved body end 0011F305
  }

}
?>