<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Describe un tipo de l�nea. En particular por el momento es Abonado o Prepago.
 * 
 * @method LineType setDescription()
 * @method string getDescription()
 */
class LineType extends ORMObject {
  /**
   * @var string la descripci�n del tipo de l�nea
   */
  protected $description;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00116405           
	return parent::define($orm)
					->setClass('LineType')
					->setTable('TIPOLINEA')
					->addField('id', 'T_LINEA_ID', ORMDefinition::INTEGER, 8, 0, false)
					->setKey('id')
					->addField('description', 'DESCRIPCION', ORMDefinition::STRING, 255, null, true)
					;
    // Bouml preserved body end 00116405
  }

}
?>