<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/wholesale/LineType.php';
require_once 'iplan/models/wholesale/RecepcionistType.php';
require_once 'iplan/models/wholesale/Site.php';
require_once 'iplan/models/wholesale/ServicePack.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Representa una l�nea de telefon�a.
 * En esta clase de guarda informaci�n acerca de las caracter�sticas que manualmente habilit� el Reseller, el n�mero de l�nea, su password SIP e informaci�n ligada a 10Fold.
 * 
 * @method Line setNumber()
 * @method Int getNumber()
 * @method Line setDescription()
 * @method Int getDescription()
 * @method Line setRegistered()
 * @method Int getRegistered()
 * @method Line setResellerId()
 * @method Int getResellerId()
 * @method Line setInterno()
 * @method string getInterno()
 * @method Line setPasswordSip()
 * @method string getPasswordSip()
 * @method Line setVpnVoiceEnabled()
 * @method boolean getVpnVoiceEnabled()
 * @method Line setOutlookIntegrationEnabled()
 * @method boolean getOutlookIntegrationEnabled()
 * @method Line setCnrfEnabled()
 * @method boolean getCnrfEnabled()
 * @method Line setWebDetailEnabled()
 * @method boolean getWebDetailEnabled()
 * @method Line setVoiceMailEnabled()
 * @method boolean getVoiceMailEnabled()
 * @method Line setCallCenter()
 * @method boolean getCallCenter()
 * @method Line setSubscription()
 * @method string getSubscription()
 * @method Line setSsi()
 * @method string getSsi()
 * @method Line setSite()
 * @method Site getSite()
 * @method Line setLineType()
 * @method LineType getLineType()
 * @method Line setRecepcionistType()
 * @method RecepcionistType getRecepcionistType()
 * @method Line setStatus()
 * @method boolean getStatus()
 * @method Line setCreated()
 * @method DateTime getCreated()
 * @method Line setModified()
 * @method DateTime getModified()
 * @method Line setDisabled()
 * @method DateTime getDisabled()
 * 
 * 
 * 
 */
class Line extends ORMObject {
  /**
   * @var string el n�mero de PSTN asignado a la l�nea
   */
  protected $number;

  /**
   * @var string una descripci�n de la l�nea
   */
  protected $description;

  /**
   * @var boolean indica si el sitio est� o no habilitado
   */
  protected $status;

  /**
   * @var DateTime la fecha de �ltima modificaci�n
   */
  protected $modified;

  /**
   * @var DateTime la fecha en que el status fue puesto en FALSE
   */
  protected $disabled;

  /**
   * @var DateTime la fecha en que se cre� el registro
   */
  protected $created;

  /**
   * @var boolean indica si la l�nea se encuentra "registrada"??
   */
  protected $registered;

  /**
   * @var string el n�mero de la l�nea. Dado que ya diammeter funciona de una forma X fue necesario mapear dos veces al campo LINEA, uno en el ID y otro ac�.
   */
  protected $line;

  /**
   * @var LineType indica el tipo de l�nea. Mapea a la columna T_LINEA_ID
   */
  protected $lineType;

  /**
   * @var string n�meros que determinan el interno, se usa string por compatibilidad con la tabla. Campo NRO_INTERNO
   */
  protected $interno;

  /**
   * @var string la clave de la l�nea para iniciar sesi�n mediante SIP
   */
  protected $passwordSip;

  /**
   * @var boolean un flag que indica si la l�nea tiene o no habilitado el "resource" de VPN_VOICE
   */
  protected $vpnVoiceEnabled;

  /**
   * @var boolean un flag que indica si la l�nea tiene o no habilitado el "resource" de Integraci�n con Outlook
   */
  protected $outlookIntegrationEnabled;

  /**
   * @var boolean un flag que indica si la l�nea tiene o no habilitado el "resource" de Call Not Reach Forward
   */
  protected $cfnrEnabled;

  /**
   * @var boolean un flag que indica si la l�nea tiene o no habilitado el "resource" de Call Not Reach Forward
   */
  protected $webDetailEnabled;

  /**
   * @var string un campo m�s de esos raros de la base de datos. Todo VARCHAR2(512) para que no falte. Que PTs.
   */
  protected $userAgent;

  /**
   * @var boolean indica si la l�nea cuenta con servicio de mensajer�a de voz.
   */
  protected $voiceMailEnabled;

  /**
   * @var boolean indica si la l�nea es utilizada como l�nea de callcenter
   */
  protected $callCenter;

  /**
   * @var int es el c�digo de subscripci�n del sitio en la plataforma 10fold
   */
  protected $subscription;

  /**
   * @var int identificador de la ruta en SoftSwitch
   */
  protected $ssi;

  /**
   * @var string la IP del dispositivo?
   */
  protected $ip;

  /**
   * @var string la direcci�n MAC del dispositivo?
   */
  protected $mac;

  /**
   * @var int el puerto que emplea el dispositivo?
   */
  protected $port;

  /**
   * @var int estado del hardware segun el autoprovisioning
   */
  protected $hardwareState;

  /**
   * @var DateTime alguna fecha relacionada al aprovisionamiento del dispositivo ?
   */
  protected $hardwareDate;

  /**
   * @var string el path o nombre de alg�n template para el autoprosioning del tel�fono?
   */
  protected $hardwareFile;

  /**
   * @var int alg�n c�digo de modelo del aparato telef�nico usado por autoprovisioning?
   */
  protected $hardwareModel;

  /**
   * @var RecepcionistType el tipo de servicio de recepcionista que tiene la l�nea. Puede ser nulo.
   */
  protected $recepcionist;

  /**
   * @var Site el sitio al que corresponde la l�nea
   */
  protected $site;

  /**
   * @var ServicePack el paquete de servicios contratado para la l�nea
   */
  protected $servicePack;

  /**
   * @var boolean un flag que indica si se aplica o no un bloqueo de llamadas de larga distancia internacional
   */
  protected $bloqueoLDI;

  /**
   * @var boolean un flag que indica si se aplica o no un bloqueo de llamadas de larga distancia nacional
   */
  protected $bloqueoLDN;

  /**
   * @var boolean un flag que indica si se aplica o no un bloqueo de llamadas a teléfonos móviles
   */
  protected $bloqueoCPP;

  /**
   * @var boolean un flag que indica si se aplica o no un bloqueo de llamadas
   */
  protected $bloqueoLOCAL;

  protected $gos;

  /**
   * @var boolean un flag que indica si la línea tiene habilitada la opción de notificación de llamadas
   */
  protected $callNotify;

  /**
   * @var boolean un flag que indica si la línea tiene habilitada la opción de reenvio de llamadas
   */
  protected $callForwarding;

  /**
   * @var boolean un flag que indica si la línea tiene habilitada la opción de reenvio de llamadas bajo la forma de oficina remota (ni idea cual es la diferencia con call forwarding)
   */
  protected $remoteOffice;

  /**
   * @var boolean un flag que indica si la línea tiene habilitada la posibilidad de emplear la misma línea desde varios dispositivos
   */
  protected $sharedCallAppearance;

  /**
   * @var boolean un flag que indica si la línea tiene habilitada la posibilidad de ponerse en Don't Disturb
   */
  protected $doNotDisturb;

  /**
   * Borra f�sicamente un objeto de la base. Al borrarse el objeto adem�s se ponen a null los campos de las entidades relacionadas que lo referenciaban y se eliminan los registros de las tablas relaci�n M:N
   * 
   * @return boolean un booleando TRUE si la operaci�n fue concretada con �xito o FALSE sino.
   */
  public function delete()
  {
    // Bouml preserved body begin 0012D805
	  
	$orm = ($orm === null) ? $this->orm : $orm;
	$this->orm = $orm;
	
	$params["p_user_id"] = 1;
	$params["p_linea"] = $this->getId();//$this->getLine();
	
	$db = $orm->getDatabase()->getConnection();
	
	$db->executeFunction("FU_LINEAS_DEL", $params);
	
	return true;

	/*require_once 'iplan/models/provisioning/ProvisioningIUNI.php';
	require_once 'iplan/models/provisioning/ProvisioningProximo.php';
	require_once 'iplan/models/provisioning/ProvisioningPlataformas.php';

	$oSite = $this->getSite();
	if (!is_a($oSite, "Site")) 
		throw new Exception("La línea debe tener un sitio asignado");
	
	//Busca Service Provider
	$oServiceProvider = $oSite->getServiceProvider();
	if (!is_a($oServiceProvider, "ServiceProvider")) 
		throw new Exception("El sitio debe tener un Service Provider asignado");
	
	$oCliente = $oSite->getClient();
	if (!is_a($oCliente, "Client"))
		throw new Exception("El sitio debe tener un Cliente asociado");
	
	$serviceProvider = $oServiceProvider->getIdentifier();
	
	//Instancia de Database
	$dbase = $orm->getDatabase()->getConnection();

	//Instancia de LOG
	$log = LogMessages::GetInstance($dbase, 1);
	$log->getMensajes();

	//Instancia de Broadsoft
	$bsws = BroadsoftXMLWS::getInstance(BroadsoftXMLWS::WSDL_WS, BroadsoftXMLWS::USER_WS, BroadsoftXMLWS::PASSWORD_WS, $log);

	$servicePacksOptions = $orm->query("ServicePack")
								->attributes('description AS bs_value', 'attributeName as attr')
								->filterBy("providers.id", "=", $oServiceProvider->getId())
								->find();
	$aPacks = array();
	if (is_array($servicePacksOptions) && (count($servicePacksOptions) > 0)) {
		for ($i = 0; $i < count($servicePacksOptions); $i++) {
			$aPacks[$servicePacksOptions[$i]["attr"]] = $servicePacksOptions[$i]["bs_value"];
		}
	}

	switch ($oServiceProvider->getProduct()->getId()) {
		case "1":
			//Proximo
			//Instancia de Provisioning
			$provisioningProximo = new ProvisioningProximo($bsws, $log, $dbase, 1);
			$usuarios = $provisioningProximo->SearchUsers($oSite->getGroup(), $serviceProvider);
			
			$interno = new InternoProximo($aPacks);
			$interno->setNroPSTN($this->getLine());
			$interno->setGrupoBS($oSite->getGroup());
			
			if (is_array($usuarios) && isset($usuarios["userTable"]) && (count($usuarios["userTable"]) > 0) && isset($usuarios["userTable"][$interno->getNroPSTN() . "@" . ProvisioningProximo::DOMAIN])) {
				//Existe el usuario para eliminar
				
				$resDel = $provisioningProximo->DeleteInternoProximo($interno, $serviceProvider);
				if (is_array($resDel) && isset($resDel["estado"]) && ($resDel["estado"] === "ok"))  {
					$bien = true;
				} else {
					$desc = ProvisioningPlataformas::erroresAString($resDel["Resultados"]);
					throw new Exception($desc);
				}
			} else {
				//No encuentro el usuario para borrar... supongo que no lo borro...
			}
			//throw new Exception("Comportamiento para Proximo no definido");
			break;
		case "2":
			//Central Virtual
			//Instancia de Provisioning
			$provisioningIUNI = new ProvisioningIUNI($bsws, $log, $dbase, 1);
			switch ($this->getLineType()->getId()) {
				case 1:
				case 5:
					//Interno y Call Center
					$usuarios = $provisioningIUNI->SearchUsers($oSite->getGroup(), $serviceProvider);

					$aRecepcionistas = array();
					$interno = new InternoIUNI($aPacks, $aRecepcionistas);
					$interno->setNroPSTN($this->getLine());
					$interno->setGrupoBS($oSite->getGroup());

					if (is_array($usuarios) && isset($usuarios["userTable"]) && (count($usuarios["userTable"]) > 0) && isset($usuarios["userTable"][$interno->getNroPSTN()])) {
						//Existe el usuario para eliminar

						$resDel = $provisioningIUNI->DeleteInternoIUNI($interno, $serviceProvider);
						if (is_array($resDel) && isset($resDel["estado"]) && ($resDel["estado"] === "ok"))  {
							$bien = true;
						} else {
							$desc = ProvisioningPlataformas::erroresAString($resDel["Resultados"]);
							throw new Exception($desc);
						}
					} else {
						//No encuentro el usuario para borrar... supongo que no lo borro...
					}
					break;
				case 2:
					//Hunt Group
					$huntGroup = new HuntGroupIUNI($this->getLine());
					$huntGroup->setGrupoBS($oSite->getGroup());
					$huntGroup->setNroPSTN($this->getLine());
					
					//Buscar HG para eliminar.
					$resBaja = $provisioningIUNI->DeleteHuntGroup($serviceProvider, $huntGroup->getGrupoBS(), $huntGroup->getNroPSTN());
					if (is_array($resBaja) && isset($resBaja) && ($resBaja["estado"] === "ok"))  {
						//Bien eliminado
						$bien = true;
					} else {
						//Mal Elimnado
						$desc = ProvisioningPlataformas::erroresAString(array_merge($resAlta["Resultados"], $resBaja["Resultados"]));
						throw new Exception($desc);
					}
					break;
				case 3:
					//AutoAttendant
					$autoAttendant = new AutoAttendantIUNI($this->getLine());
					$autoAttendant->setGrupoBS($oSite->getGroup());
					$autoAttendant->setNroPSTN($this->getLine());
					
					//Buscar HG para eliminar.
					$resBaja = $provisioningIUNI->DeleteAutoAttendant($serviceProvider, $autoAttendant->getGrupoBS(), $autoAttendant->getNroPSTN());
					if (is_array($resBaja) && isset($resBaja["estado"]) && ($resBaja["estado"] === "ok"))  {
						//Bien eliminado
						$bien = true;
					} else {
						//Mal Elimnado
						$desc = ProvisioningPlataformas::erroresAString(array_merge($resAlta["Resultados"], $resBaja["Resultados"]));
						throw new Exception($desc);
					}
					break;
				case 4:
					//Voice Portal
					$central = new CentralIUNI($oSite->getClient()->getClientNumber(), $oSite->getClient()->getName());
					$central->setVoicePortal($this->getLine(), $this->getInterno(), $this->getPasswordSip());
					$central->setServiceProvider($serviceProvider);
					$central->setGroupNameDB($oSite->getGroup());

					$resBaja = $provisioningIUNI->unsetVoicePortal($central);
					if (is_array($resBaja) && isset($resBaja["estado"]) && ($resBaja["estado"] === "ok"))  {
						//Bien eliminado
						$bien = true;
					} else {
						//Mal Elimnado
						$desc = ProvisioningPlataformas::erroresAString(array_merge($resAlta["Resultados"], $resBaja["Resultados"]));
						throw new Exception($desc);
					}
					
					break;
				default:
					throw new Exception("Tipo de Linea desconocido.");
					break;
			}
			break;
		default:
			//No hay definiciones para otro producto
			break;
	}
	
	
	//Lo Elimino
	$dbase = $orm->getDatabase()->getConnection();
	$result = null;
	$lala = $dbase->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_DEL", $params, $result, Connection::T_CURSOR);
	$asd = $dbase->fetch($lala);
	$dbase->free($lala);
	if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
		$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
		throw new Exception($desc);
	}
	return true;*/
	//FU_LINEAS_DEL(p_user_id IN NUMBER, p_linea IN VARCHAR2
    // Bouml preserved body end 0012D805
  }

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00116385
	return parent::define($orm)
                ->setClass('Line')
				->setTable('LINEAS')
				->addField('id', 'LINEA', ORMDefinition::STRING, 255, 0, false)
				->setKey('id')
				->addField('line', 'LINEA', ORMDefinition::STRING, 255, 0, false)
				->addField('description', 'DESCRIPCION', ORMDefinition::STRING, 255, null, true)
				->addField('status', 'ESTADO', ORMDefinition::INTEGER, 2, 0, false)
				->addField('created', 'FE_ALTA', ORMDefinition::DATE, null, null, false)
				->addField('modified', 'FE_MODIFICACION', ORMDefinition::DATE, null, null, true)
				->addField('disabled', 'FE_BAJA', ORMDefinition::DATE, null, null, true)
				->addField('registered', 'REGISTRADO', ORMDefinition::INTEGER, 2, 0, true)
				->addField('userAgent', 'USER_AGENT', ORMDefinition::STRING, 512, null, true)
				->addField('ip', 'IP', ORMDefinition::STRING, 50, null, true)
				->addField('port', 'PUERTO', ORMDefinition::STRING, 10, null, true)
				->addInstance('lineType', 'T_LINEA_ID', 'LineType', false)
				->addField('interno', 'NRO_INTERNO', ORMDefinition::STRING, 255, null, true)
				->addField('passwordSip', 'PASSWORD_SIP', ORMDefinition::STRING, 255, null, true)
				->addField('vpnVoiceEnabled', 'VPN_VOICE', ORMDefinition::INTEGER, 1, 0, true)
				->addField('outlookIntegrationEnabled', 'INTEGRACION_OUTLOOK', ORMDefinition::INTEGER, 1, 0, true)
				->addField('cfnrEnabled', 'SERVICIO_CFRM', ORMDefinition::INTEGER, 1, 0, true)
				->addField('webDetailEnabled', 'DETALLE_WEB', ORMDefinition::INTEGER, 1, 0, true)
				->addField('voiceMailEnabled', 'VOICE_MAIL', ORMDefinition::INTEGER, 1, 0, true)
				->addField('callCenter', 'LICENCIA_CALLCENTER', ORMDefinition::INTEGER, 1, 0, true)
				->addField('subscription', 'SUBSCRIPTION', ORMDefinition::INTEGER, null, null, false)
				->addField('ssi', 'ENRUTAMIENTO_SSI', ORMDefinition::INTEGER, 10, 0, true)
				->addField('mac', 'MAC_ADDRESS', ORMDefinition::STRING, 50, 0, true)
				->addField('hardwareState', 'ESTADO_HW', ORMDefinition::INTEGER, 2, 0, true)
				->addField('hardwareDate', 'FE_HW', ORMDefinition::DATE, null, null, true)
				->addField('hardwareFile', 'FILE_HW', ORMDefinition::STRING, 255, null, true)
				->addField('hardwareModel', 'MOD_HW_ID', ORMDefinition::INTEGER, 3, 0, true)
				->addField('bloqueoLDI', 'BLOQUEOLDI', ORMDefinition::INTEGER, 1, 0, true)
				->addField('bloqueoLDN', 'BLOQUEOLDN', ORMDefinition::INTEGER, 1, 0, true)
				->addField('bloqueoCPP', 'BLOQUEOCPP', ORMDefinition::INTEGER, 1, 0, true)
				->addField('bloqueoLOCAL', 'BLOQUEOLOCAL', ORMDefinition::INTEGER, 1, 0, true)
				->addField('gos', 'GOS', ORMDefinition::INTEGER, 1, 0, true)
				->addField('callNotify', 'CALLNOTIFY', ORMDefinition::INTEGER, 1, 0, true)
				->addField('callForwarding', 'CALLFORWARDING', ORMDefinition::INTEGER, 1, 0, true)
				->addField('remoteOffice', 'REMOTEOFFICE', ORMDefinition::INTEGER, 1, 0, true)
				->addField('sharedCallAppearance', 'SHAREDCALLAPPEARANCE', ORMDefinition::INTEGER, 1, 0, true)
				->addField('doNotDisturb', 'DONOTDISTURB', ORMDefinition::INTEGER, 1, 0, true)
				->addInstance('recepcionist', 'T_RECEPCIONISTA_ID', 'RecepcionistType', true, null, ORM_LOAD_STYLE::LAZY_LOAD)
				->addInstance('site', 'SITIO_ID', 'Site', false, null, ORM_LOAD_STYLE::LAZY_LOAD)
				->addInstance('servicePack', 'T_LICENCIA_ID', 'ServicePack', true, null, ORM_LOAD_STYLE::LAZY_LOAD)
				;
    // Bouml preserved body end 00116385
  }

  /**
   * Verifica si el objeto fue modificado y lo guarda.
   * Este m�todo permite abstraer a las clases descendientes de la necesidad de determinar si el objeto fue alterado o no y oculta la complejidad subyacente a las clases descendientes.
   * @param ORM $orm opcionalmente se debe indicar la instancia del ORM que mantiene el objeto. Esto s�lo es posible si el objeto es nuevo o DETACHED. En el caso que ya estuviera bajo monitoreo de un ORM arrojar� una excepci�n.
   * 
   * Se pens� en que se podr�a hacer el cambio de un ORM a otro, pero el ID deber�a limpiarse, con lo cual s�lo un INSERT se podr�a hacer sobre el destino y los objetos relacionados estar�an a�n con otro ORM lo cual es complicado (manejo de objetos distribu�dos) por lo cual se deja a consideraci�n de futuras versiones, posiblemente en otra vida =)
   */
  public function save(&$orm = null)
  {
    // Bouml preserved body begin 0012D785
	$orm = ($orm === null) ? $this->orm : $orm;
	$this->orm = $orm;
	
	
	$params["p_user_id"] = 1;
	$params["p_subscription"] = $this->getSubscription();
	$params["p_linea"] = $this->getLine();//$this->getLine();
	$params["p_descripcion"] = $this->getDescription();
	$params["p_sitio_id"] = $this->getSite()->getId();
	$params["p_t_licencia_id"] = (is_a($this->getServicePack(), 'ServicePack')) ? $this->getServicePack()->getId() : null;
	$params["p_user_agent"] = $this->getUserAgent();
	$params["p_ip"] = $this->getIp();
	$params["p_puerto"] = $this->getPort();
	$params["p_t_linea_id"] = $this->getLineType()->getId();
	$params["p_nro_interno"] = $this->getInterno();
	$params["p_password_sip"] = $this->getPasswordSip();
	$params["p_vpn_voice"] = $this->getVpnVoiceEnabled();
	$params["p_integracion_outlook"] = $this->getOutlookIntegrationEnabled();
	$params["p_t_recepcionista_id"] = (is_a($this->getRecepcionist(), 'RecepcionistType')) ? $this->getRecepcionist()->getId() : null;
	$params["p_servicio_cfrm"] = $this->getCfnrEnabled();
	$params["p_licencia_callcenter"] = $this->getCallCenter();
	$params["p_enrutamiento_ssi"] = $this->getSsi();
	$params["p_detalle_web"] = $this->getWebDetailEnabled();
	$params["p_voice_mail"] = $this->getVoiceMailEnabled();
	$params["p_bloqueoldi"] = $this->getBloqueoLDI();
	$params["p_bloqueoldn"] = $this->getBloqueoLDN();
	$params["p_bloqueocpp"] = $this->getBloqueoCPP();
	$params["p_bloqueolocal"] = $this->getBloqueoLOCAL();
	$params["p_gos"] = $this->getGos();
	$params["p_callnotify"] = $this->getCallNotify();
	$params["p_callforwarding"] = $this->getCallForwarding();
	$params["p_remoteoffice"] = $this->getRemoteOffice();
	$params["p_sharedcallappearance"] = $this->getSharedCallAppearance();
	$params["p_donotdisturb"] = $this->getDoNotDisturb();

	$db = $orm->getDatabase()->getConnection();
	
	if ($this->id === null) {
		$db->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_INS", $params);
	} else {
		$db->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_UPD", $params);	
	}
	
	//Hacer Clear de cache xd
	
	/* 
	 * Comentado cambios de Impacto en Plataforma.
	 * 
	//Instancia de Database
	$dbase = $orm->getDatabase()->getConnection();
	
	require_once 'iplan/models/provisioning/ProvisioningIUNI.php';
	require_once 'iplan/models/provisioning/ProvisioningProximo.php';
	require_once 'iplan/models/provisioning/ProvisioningPlataformas.php';
	
	//Get Service Provider
	$oSite = $this->getSite();
	if (!(is_a($oSite, "Site")))
		throw new Exception("La linea debe tener un sitio asignado");
	
	$oServiceProvider = $oSite->getServiceProvider();
	if (!is_a($oServiceProvider, "ServiceProvider"))
		throw new Exception("El sitio debe tener un Service Provider asignado");
	
	//Validaciones:
	if (!$this->getId()) {
		//Linea nueva Validaciones
		//No dar de alta lineas con el mismo ID:
		if ($this->getLine()) {
			$oLineValidate = $orm->query("Line")->filterBy("line", "=", $this->getLine())->findOne();
			if ((is_a($oLineValidate, "Line")) && ($oLineValidate->getStatus() == "1")) {
				//Activa
				throw new Exception("Ya existe la linea " . $this->getLine() . " activa con la subscripción " . $oLineValidate->getSubscription());
			}
		}
		//No repetir subscripcion si el estado es activo, si es inactivo, la pisamos y listo.
		if ($this->getSubscription()) {
			$oLineValidate = $orm->query("Line")->filterBy("subscription", "=", $this->getSubscription())->findOne();
			if ((is_a($oLineValidate, "Line")) && ($oLineValidate->getStatus() == "1")) {
				//Activa
				throw new Exception("Ya existe la subscripción " . $this->getSubscription() . " asignada a la línea " . $oLineValidate->getLine());
			}
		}
	}
	
	$atributosTotales = $orm->query("Resource")
							->attributes("id", "description", "field")
							->find();
	
	$atributosPermiso = $orm->query('Site')
							 ->attributes(	'serviceProvider.resources.id AS id', 
											'serviceProvider.resources.description AS description', 
											'serviceProvider.resources.field AS field')
							 ->filterBy('id', '=', $oSite->getId())
							 ->find();
	
	$noTienePermisos = array();
	if (is_array($atributosTotales) && (count($atributosTotales) > 0) ) {
		foreach ($atributosTotales as $akey => $avalue) {
			if (is_array($atributosPermiso) && (count($atributosPermiso) > 0) ) {
				$per = false;
				foreach ($atributosPermiso as $apkey => $apvalue)
					if (isset($apvalue["id"]) && ($apvalue["id"] ===  $avalue["id"]))
						$per = true;
				if (!$per)
					$noTienePermisos[] = $avalue["field"];
			} else {
				$noTienePermisos[] = $avalue["field"];
			}
		}
	}
	
	$def = $orm->getDefinition('Line');
	for ($i = 0; $i < count($noTienePermisos); $i++) {
		$definido = $def->getFieldDefinition($noTienePermisos[$i]);
		if (isset($definido["type"])) {
			switch ($definido["type"]) {
				case ORM_TYPES::ORM_ENTITY:
					$clase = $definido["class"];
					$getField = "get" . ucfirst($noTienePermisos[$i]);
					if (is_a($this->$getField(), $clase))
						throw new Exception("Intentando setear atributo no configurable para el service provider: " . $noTienePermisos[$i]);
					break;
				default:
					$getField = "get" . ucfirst($noTienePermisos[$i]);
					if ($this->$getField())
						throw new Exception("Intentando setear atributo no configurable para el service provider: " . $noTienePermisos[$i]);
					break;
			}
		}
	}
	
	if ($oServiceProvider->getProduct()->getId() == "1") {
		//Proximo
		if (strlen($this->getInterno()) != 4) 
			throw new Exception("En sitios de Próximo 2.0 los Números de Interno deben tener 3 dígitos.");
	} else {
		if (strlen($this->getInterno()) != 3) 
			throw new Exception("En sitios de Central Virtual los Números de Interno deben tener 4 dígitos.");
	}
	
	if (is_a($this->getLineType(), "LineType")) {
		switch ($this->getLineType()->getId()) {
			case 1:
				//Es un interno
				if (strlen($this->getPasswordSip()) == 0) {
					throw new Exception("Debe asignar un password a las líneas de tipo interno");
				}
				//Debe Tener Service Pack asociado.
				if (!is_a($this->getServicePack(), "ServicePack"))
					throw new Exception("La linea debe tener un Service Pack asociado");

				//No debe tener la licencia de Call Center.
				if ($this->getCallCenter())
					throw new Exception("Un interno no puede tener licencia de Call Center");
				
				break;
			case 5:
				//Es un Call Center.
				if (!$this->getCallCenter())
					throw new Exception("Debe asignar Call Center en Si.");
			case 4: 
				//Buscar que no haya mas voices portals en el grupo
				$oLineValidate = $orm->query("Line")->filterBy("lineType.id", "=", "4")->filterBy("site.id", "=", $oSite->getId())->findOne();
				if ((is_a($oLineValidate, "Line")) && ($oLineValidate->getStatus() == "1")) {
					//Activa
					throw new Exception("Ya tiene un voice portal configurado para el grupo: \"" . $oSite->getGroup() . "\" de línea " . $oLineValidate->getLine() . " suscripción " . $oLineValidate->getSubscription());
				}

			case 2:
			case 3:
				if ($oServiceProvider->getProduct()->getId() == "1") {//Proximo
					throw new Exception("En sitios de Próximo 2.0 solo se pueden dar de alta líneas de tipo \"Interno\".");
				}
				//HuntGroup, AutoAttendant, Voice Portal
				if (is_a($this->getServicePack(), "ServicePack")) 
					throw new Exception($this->getLineType()->getDescription() .  ": No debe tener Service Pack asociado");
				if ($this->getCfnrEnabled())
					throw new Exception($this->getLineType()->getDescription() .  ": No debe tener CFNR");
				if ($this->getOutlookIntegrationEnabled())
					throw new Exception($this->getLineType()->getDescription() .  ": No debe tener Outlook Integration");
				if ($this->getVpnVoiceEnabled())
					throw new Exception($this->getLineType()->getDescription() .  ": No debe tener VPN Voice");
				if ($this->getWebDetailEnabled())
					throw new Exception($this->getLineType()->getDescription() .  ": No debe tener Detalle Web Habilitado");
				if ($this->getVoiceMailEnabled())
					throw new Exception($this->getLineType()->getDescription() .  ": No debe tener Voice Messaging User Habilitado");
				if ((is_a($this->getRecepcionist(), "RecepcionistType")))
					throw new Exception($this->getLineType()->getDescription() .  ": No debe tener Recepcionista Habilitada");
				break;
			default:
				throw new Exception("Tipo de línea inválido");
				break;
		}
		
	} else {
		throw new Exception("La linea debe tener un tipo asociado");
	}
	
	
	$bien = false;
	
	$serviceProvider = $oServiceProvider->getIdentifier();
	//Instancia de LOG
	$log = LogMessages::GetInstance($dbase, 1);
	$log->getMensajes();

	//Instancia de Broadsoft
	$bsws = BroadsoftXMLWS::getInstance(BroadsoftXMLWS::WSDL_WS, BroadsoftXMLWS::USER_WS, BroadsoftXMLWS::PASSWORD_WS, $log);

	//Broadsoft
	switch ($oServiceProvider->getProduct()->getId()) {
		
		case "1":
			//Proximo
			if (!$this->getId()) {
				//Nuevo
				//Instancia de Provisioning
				switch ($this->getLineType()->getId()) {
					case 1:
						//Interno
						$provisioningProximo = new ProvisioningProximo($bsws, $log, $dbase, 1);
						
						//Verifico la numeración:
						$verificaNumeracion = $provisioningProximo->verifyNumeracionServiceProvider($serviceProvider, array($this->getLine()));
						if (!(is_array($verificaNumeracion) && isset($verificaNumeracion["estado"]) && ($verificaNumeracion["estado"] === "ok")))  {
							$desc = ProvisioningPlataformas::erroresAString($verificaNumeracion["Resultados"]);
							throw new Exception($desc);
						}
				
						$servicePacksOptions = $orm->query("ServicePack")
												->attributes('description AS bs_value', 'attributeName as attr')
												->filterBy("providers.id", "=", $oServiceProvider->getId())
												->find();
						$aPacks = array();
						if (is_array($servicePacksOptions) && (count($servicePacksOptions) > 0)) {
							for ($i = 0; $i < count($servicePacksOptions); $i++) {
								$aPacks[$servicePacksOptions[$i]["attr"]] = $servicePacksOptions[$i]["bs_value"];
							}
						}

						$interno = new InternoProximo($aPacks);
						$interno->setDetalleWeb($this->getWebDetailEnabled());
						$interno->setDireccion($oSite->getDescription());
						$interno->setGrupoBS($oSite->getGroup());
						$interno->setLocacionID($oSite->getLocation());
						$interno->setNroInterno($this->getInterno());
						$interno->setNroPSTN($this->getLine());
						$interno->setPassword($this->getPasswordSip());
						$interno->setServiceProvider($serviceProvider);
						$interno->setSubscriptionID($this->getSubscription());
						$interno->setVoiceMail($this->getVoiceMailEnabled());
						
						if (is_a($this->getServicePack(), 'ServicePack')) {
							$func = "set" . $this->getServicePack()->getAttributeName();
							$interno->$func(true);
						}
						
						$usuarios = $provisioningProximo->SearchUsers($oSite->getGroup(), $serviceProvider);

						if (is_array($usuarios) && isset($usuarios["userTable"]) && (count($usuarios["userTable"]) > 0) && isset($usuarios["userTable"][$interno->getNroPSTN() . "@" . ProvisioningProximo::DOMAIN])) {
							//Usuario encontrado
							throw new Exception("Usuario " . $interno->getNroPSTN() . "@" . ProvisioningProximo::DOMAIN . " ya existe en el grupo");
						}
						
						$resAlta = $provisioningProximo->AddInternoProximo($interno, $serviceProvider);

						if (is_array($resAlta) && isset($resAlta) && ($resAlta["estado"] === "ok"))  {
							$bien = true;
						} else {
							$resBaja = $provisioningProximo->DeleteInternoProximo($interno, $serviceProvider);
							if (is_array($resBaja) && isset($resBaja) && ($resBaja["estado"] === "ok"))  {
								//Bien eliminado
								$desc = ProvisioningPlataformas::erroresAString("Alta: " . $resAlta["Resultados"]);
							} else {
								//Mal Elimnado
								$desc = "Alta: " . ProvisioningPlataformas::erroresAString($resAlta["Resultados"]) . " | Baja: " . ProvisioningPlataformas::erroresAString($resBaja["Resultados"]);
							}
							throw new Exception($desc);
						}
						break;
					default:
						throw new Exception("Tipo de línea inválido");
						break;
				}
				
			}
			break;
		case "2":
			//Central Virtual
			if (!$this->getId()) {
				//Nuevo
				//Instancia de Provisioning
				$provisioningIUNI = new ProvisioningIUNI($bsws, $log, $dbase, 1);
				
				//Verifico la numeración:
				$verificaNumeracion = $provisioningIUNI->verifyNumeracionServiceProvider($serviceProvider, array($this->getLine()));
				if (!(is_array($verificaNumeracion) && isset($verificaNumeracion["estado"]) && ($verificaNumeracion["estado"] === "ok")))  {
					$desc = ProvisioningPlataformas::erroresAString($verificaNumeracion["Resultados"]);
					throw new Exception($desc);
				}
				
				switch ($this->getLineType()->getId()) {
					case 1:
					case 5:
						//Interno
						$servicePacksOptions = $orm->query("ServicePack")
										->attributes('description AS bs_value', 'attributeName as attr')
										->filterBy("providers.id", "=", $oServiceProvider->getId())
										->find();
						$aPacks = array();
						if (is_array($servicePacksOptions) && (count($servicePacksOptions) > 0)) {
							for ($i = 0; $i < count($servicePacksOptions); $i++) {
								$aPacks[$servicePacksOptions[$i]["attr"]] = $servicePacksOptions[$i]["bs_value"];
							}
						}
						$recepcionistTypeOptions = $orm->query('RecepcionistType')
										->attributes('description AS bs_value', 'attributeName as attr')
										->find();
						$aRecepcionistas = array();
						if (is_array($recepcionistTypeOptions) && (count($recepcionistTypeOptions) > 0)) {
							for ($i = 0; $i < count($recepcionistTypeOptions); $i++) {
								$aRecepcionistas[$recepcionistTypeOptions[$i]["attr"]] = $recepcionistTypeOptions[$i]["bs_value"];
							}
						}

						$interno = new InternoIUNI($aPacks, $aRecepcionistas);
						$interno->setGrupoBS($oSite->getGroup());
						$interno->setDetalleWeb($this->getWebDetailEnabled());
						$interno->setDireccion($oSite->getDescription());
						$interno->setIntegracionOutlook($this->getOutlookIntegrationEnabled());
						$interno->setLicenciaCallCenter($this->getCallCenter());
						$interno->setLocacionID($oSite->getLocation());
						$interno->setNroInterno($this->getInterno());
						$interno->setNroPSTN($this->getLine());
						$interno->setPassword($this->getPasswordSip());
						$interno->setServicioCFNR($this->getCfnrEnabled());
						$interno->setSubscriptionID($this->getSubscription());
						$interno->setVoiceMail($this->getVoiceMailEnabled());
						$interno->setVpnVoice($this->getVpnVoiceEnabled());

						if (is_a($this->getRecepcionist(), 'RecepcionistType')) {
							$func = "set" . $this->getRecepcionist()->getAttributeName();
							$interno->$func(true);
						}

						if (is_a($this->getServicePack(), 'ServicePack')) {
							$func = "set" . $this->getServicePack()->getAttributeName();
							$interno->$func(true);
						}
						
						$usuarios = $provisioningIUNI->SearchUsers($oSite->getGroup(), $serviceProvider);

						if (is_array($usuarios) && isset($usuarios["userTable"]) && (count($usuarios["userTable"]) > 0) && isset($usuarios["userTable"][$interno->getNroPSTN()])) {
							//Usuario encontrado
							throw new Exception("Usuario " . $interno->getNroPSTN() . " ya existe en el grupo");
						}

						$resAlta = $provisioningIUNI->AddInternoIUNI($interno, $serviceProvider);

						if (is_array($resAlta) && isset($resAlta) && ($resAlta["estado"] === "ok"))  {
							$bien = true;
						} else {
							$resBaja = $provisioningIUNI->DeleteInternoIUNI($interno, $serviceProvider);
							if (is_array($resBaja) && isset($resBaja) && ($resBaja["estado"] === "ok"))  {
								//Bien eliminado
								$desc = ProvisioningPlataformas::erroresAString($resAlta["Resultados"]);
							} else {
								//Mal Elimnado
								$desc = ProvisioningPlataformas::erroresAString(array_merge($resAlta["Resultados"], $resBaja["Resultados"]));
							}
							throw new Exception($desc);
						}
						break;
					case 2:
						//Hunt Group
						
						$huntGroup = new HuntGroupIUNI($this->getLine(),$this->getInterno());
						$huntGroup->setGrupoBS($oSite->getGroup());
						$huntGroup->setLocacionID($oSite->getLocation());
						$huntGroup->setPassword($this->getPasswordSip());
						$huntGroup->setSubscriptionID($this->getSubscription());
						
						$busquedaHunts = $provisioningIUNI->SearchGroupHuntGroups($oSite->getGroup(), $serviceProvider);
						if (is_array($busquedaHunts) && (array_search($this->getLine(), array_keys($busquedaHunts["huntGroupTable"]), false) !== false)) {
							throw new Exception("Ya existe el HuntGroup: " . $this->getLine());
						}
						
						$resAlta = $provisioningIUNI->AddHuntGroupIUNI($huntGroup, $serviceProvider);
						if (is_array($resAlta) && isset($resAlta["estado"]) && ($resAlta["estado"] === "ok"))  {
							$bien = true;
						} else {
							$resBaja = $provisioningIUNI->DeleteHuntGroup($serviceProvider, $huntGroup->getGrupoBS(), $huntGroup->getNroPSTN());
							if (is_array($resBaja) && isset($resBaja["estado"]) && ($resBaja["estado"] === "ok"))  {
								//Bien eliminado
								$desc = ProvisioningPlataformas::erroresAString($resAlta["Resultados"]);
							} else {
								//Mal Elimnado
								$desc = ProvisioningPlataformas::erroresAString(array_merge($resAlta["Resultados"], $resBaja["Resultados"]));
							}
							throw new Exception($desc);
						}
						break;
					case 3:
						//AutoAttendant
						$autoAttendant = new AutoAttendantIUNI($this->getLine(), $this->getInterno());
						$autoAttendant->setGrupoBS($oSite->getGroup());
						$autoAttendant->setLocacionID($oSite->getLocation());
						$autoAttendant->setPassword($this->getPasswordSip());
						$autoAttendant->setSubscriptionID($this->getSubscription());
						
						$busquedaAutoAttendants = $provisioningIUNI->SearchGroupAutoAttendants($oSite->getGroup(), $serviceProvider);
						if (is_array($busquedaAutoAttendants) && (array_search($this->getLine(), array_keys($busquedaAutoAttendants["autoAttendantTable"]), false) !== false)) {
							throw new Exception("Ya existe el Auto Attendant: " . $this->getLine());
						}
						
						$resAlta = $provisioningIUNI->AddAutoAttendantIUNI($autoAttendant, $serviceProvider);
						if (is_array($resAlta) && isset($resAlta["estado"]) && ($resAlta["estado"] === "ok"))  {
							$bien = true;
						} else {
							$resBaja = $provisioningIUNI->DeleteAutoAttendant($serviceProvider, $autoAttendant->getGrupoBS(), $autoAttendant->getNroPSTN());
							if (is_array($resBaja) && isset($resBaja["estado"]) && ($resBaja["estado"] === "ok"))  {
								//Bien eliminado
								$desc = ProvisioningPlataformas::erroresAString($resAlta["Resultados"]);
							} else {
								//Mal Elimnado
								$desc = ProvisioningPlataformas::erroresAString(array_merge($resAlta["Resultados"], $resBaja["Resultados"]));
							}
							throw new Exception($desc);
						}
						break;
					case 4:
						//Voice Portal
						$central = new CentralIUNI($oSite->getClient()->getClientNumber(), $oSite->getClient()->getName());
						$central->setVoicePortal($this->getLine(), $this->getInterno(), $this->getPasswordSip());
						$central->setServiceProvider($serviceProvider);
						$central->setGroupNameDB($oSite->getGroup());
						
						$aVoicePortal = $provisioningIUNI->getGroupVoicePortal($oSite->getGroup(), $serviceProvider);
						//var_dump($aVoicePortal);
						if (is_array($aVoicePortal) && (isset($aVoicePortal["isActive"])) && ($aVoicePortal["isActive"] == "true")) {
							throw new Exception("Ya existe un Voice Portal configurado y activo: " . $aVoicePortal["serviceUserId"]);
						}
						
						$resAlta = $provisioningIUNI->setVoicePortal($central);
						if (is_array($resAlta) && isset($resAlta["estado"]) && ($resAlta["estado"] === "ok"))  {
							$bien = true;
						} else {
							$resBaja = $provisioningIUNI->unsetVoicePortal($central);
							if (is_array($resBaja) && isset($resBaja["estado"]) && ($resBaja["estado"] === "ok"))  {
								//Bien eliminado
								$desc = ProvisioningPlataformas::erroresAString($resAlta["Resultados"]);
							} else {
								//Mal Elimnado
								$desc = ProvisioningPlataformas::erroresAString(array_merge($resAlta["Resultados"], $resBaja["Resultados"]));
							}
							throw new Exception($desc);
						}
						break;
					default:
						throw new Exception("Tipo de Linea desconocido.");
						break;
				}
			} else {
				//Modificacion
				throw new Exception("Modificacion, revisar");
			}
			
			break;
		default:
			//
			throw new Exception("No se especifico un Broadsoft Service Provider correcto");
			break;
	}
	
	
	//Core
	$params = array("p_user_id" => 1,
					"p_subscription_id" => (int)$this->getSubscription(), 
					"p_linea" => $this->getLine(),
					"p_descripcion" => $this->getDescription(),
					"p_sitio_id" => (int)$oSite->getId(),
					"p_t_licencia_id" => (is_a($this->getServicePack(), 'ServicePack')) ? $this->getServicePack()->getId() : null,
					"p_user_agent" =>  $this->getUserAgent(),
					"p_ip" => $this->getIp(),
					"p_port" => $this->getPort(),
					"p_tipo_linea" => (int) $this->getLineType()->getId(),
					"p_interno" => $this->getInterno(),
					"p_password" => $this->getPasswordSip(),
					"p_vpn_voice" => $this->getVpnVoiceEnabled(),
					"p_integracion_outlook" => $this->getOutlookIntegrationEnabled(),
					"p_tipo_recepcionista" => (is_a($this->getRecepcionist(), 'RecepcionistType')) ? $this->getRecepcionist()->getId() : null,
					"p_servicio_cfnr" => $this->getCfnrEnabled(),
					"p_licencia_callcenter" => $this->getCallCenter(),
					"p_enrutamiento_ssi" => null,
					"p_detalle_web" => $this->getWebDetailEnabled(),
					"p_voicemail" => $this->getVoiceMailEnabled()
				);
	
	$result = null;
	if (!$this->getId()) {
		$lala = $dbase->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_INS", $params, $result, Connection::T_CURSOR);
	} else {
		$lala = $dbase->executeFunction("PKG_WEB_LINEAS.FU_LINEAS_UPD", $params, $result, Connection::T_CURSOR);
	}
	$asd = $dbase->fetch($lala);
	$dbase->free($lala);
	if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
		$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
		throw new Exception($desc);
	}
	return true;
	
	*/
	
    // Bouml preserved body end 0012D785
  }

}
?>