<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Jorge Alexis Viqueira
* 
*/
class Currency extends ORMObject {
  /**
   * @var DateTime la fecha en que se cre� el registro
   */
  protected $created;

  /**
   * @var boolean indica si el sitio est� o no habilitado
   */
  protected $status;

  /**
   * @var DateTime la fecha de �ltima modificaci�n
   */
  protected $modified;

  /**
   * @var DateTime la fecha en que el status fue puesto en FALSE
   */
  protected $disabled;

  /**
   * @var string una descripci�n de la moneda.
   */
  protected $description;

  /**
   * @var float la cotizaci�n de la moneda convertida a Pesos
   */
  protected $quotation;

  /**
   * @var DateTime fecha de cotizaci�n
   */
  protected $quotationDate;

  /**
   * @var int un c�digo num�rico de la moneda. Posiblemente para usar alguna cotizaci�n autom�tica.
   */
  protected $code;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 0011D485
	return parent::define($orm)
			->setTable('MONEDA')
			->addField('id', 'MONEDA_ID', ORMDefinition::STRING, 3)
			->setKey('id')
			->addField('status', 'ESTADO', ORMDefinition::INTEGER, 2, 0, false)
			->addField('created', 'FE_ALTA', ORMDefinition::DATE, null, null, false, 'NOW()')
			->addField('modified', 'FE_MODIFICACION', ORMDefinition::DATE, null, null, true)
			->addField('disabled', 'FE_BAJA', ORMDefinition::DATE, null, null, true)
			->addField('quotation','COTIZACION_ACTUAL', ORMDefinition::DECIMAL, 12, 6)
			->addField('quotationDate', 'FE_COTIZACION', ORMDefinition::DATE)
			->addField('description', 'DESCRIPCION', ORMDefinition::STRING, 255, true, true)
			->addField('code', 'MONEDA_NUM', ORMDefinition::INTEGER, 3);
    // Bouml preserved body end 0011D485
  }

}
?>