<?php
require_once 'iplan/models/wholesale/Reseller.php';
require_once 'iplan/security/User.php';
require_once 'iplan/models/wholesale/Site.php';
require_once 'iplan/models/wholesale/PayPlan.php';
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Jorge Alexis Viqueira
* 
*/
/**
 * Representa a un consumidor de servicios de un Reseller. Obviamente un cliente que puede tener varios sitios y servicios asociados.
 * 
 * @method Client setClientNumber()
 * @method Int getClientNumber()
 * @method Client setName()
 * @method string getName()
 * @method Client setUsername()
 * @method string getUsername()
 * @method Client setMail()
 * @method string getMail()
 * @method Client setPhone()
 * @method string getPhone()
 * @method Client setAlternativePhone()
 * @method string getAlternativePhone()
 * @method Client setStatus()
 * @method boolean getStatus()
 * @method Client setCreated()
 * @method DateTime getCreated()
 * @method Client setModified()
 * @method DateTime getModified()
 * @method Client setDisabled()
 * @method DateTime getDisabled()
 * @method Client setReseller()
 * @method Client  setPayPlan()
 * @method PayPlan getPayPlan()
 * @method Client setUser()
 * @method User getUser()
 * @method ORMCollection getSites()
 * @method Client addSite()
 * @method Client delSite()
 * @method Client setReseller()
 * @method Reseller getReseller()
 * @method Client setPasswordWeb()
 * @method string getPasswordWeb()
 * @method Client setContactName()
 * @method string getContactName()
 * @method Client setContactLastName()
 * @method string getContactLastName()
 * @method Client setClientType()
 * @method int getClientType()
 */
class Client extends ORMObject {
  /**
   * @const int Constante que indica que el cliente es web, es decir, su vinculación con la empresa fue a través del portal web
   */
  const WEB_CLIENT = 1;

  /**
   * @const int Constante que indica que el cliente tuvo vinculación directa con la empresa a través de un canal de venta tradicional NO WEB.
   */
  const DIRECT_CLIENT = 0;

  /**
   * @var int el identificador del cliente en 10fold
   */
  protected $clientNumber;

  /**
   * @var Reseller el administrador o responsable comercial del cliente
   */
  protected $reseller;

  /**
   * @var boolean indica si el cliente est� vigente o si fue dado de baja.
   */
  protected $status;

  /**
   * @var string el nombre de usuario de la central PBX de BroadSoft.
   */
  protected $username;

  /**
   * @var User el usuario en el framework
   */
  protected $user;

  /**
   * @var DateTime la fecha en que se cre� el registro
   */
  protected $created;

  /**
   * @var DateTime la fecha de �ltima modificaci�n
   */
  protected $modified;

  /**
   * @var DateTime la fecha en que el status fue puesto en FALSE
   */
  protected $disabled;

  /**
   * @var string el email del cliente
   */
  protected $mail;

  /**
   * @var string el tel�fono principal de contacto
   */
  protected $phone;

  /**
   * @var string el tel�fono alternativo para contacto
   */
  protected $alternativePhone;

  /**
   * @var string la raz�n social del cliente
   */
  protected $name;

  /**
   * @var ORMCollection la lista de sitios del cliente
   */
  protected $sites;

  /**
   * @var PayPlan indica el tipo de pago del cliente
   */
  protected $payPlan;

  /**
   * @var string el password de la central PBX de BroadSoft
   */
  protected $passwordWeb;

  /**
   * @var string el nombre del contacto
   */
  protected $contactName;

  /**
   * @var string el apellido del contacto
   */
  protected $contactLastName;

  /**
   * @var int un flag que indica el tipo de cliente en base a su modo de registro (via web o compra directa)
   */
  protected $clientType;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00116205
	return parent::define($orm)
                ->setClass('Client')
				->setTable('CLIENTE')
				->addField('id', 'CLIENTE_ID', ORMDefinition::INTEGER, 8, 0, false)
				->setKey('id')
				->addField('name', 'RAZON_SOCIAL', ORMDefinition::STRING, 255, 0, true)
				->addField('clientNumber', 'NRO_CLIENTE', ORMDefinition::INTEGER, 8, 0, true)
				->addInstance('reseller', 'LICENCIATARIO_ID', 'Reseller')
				->addField('status', 'ESTADO', ORMDefinition::INTEGER, 2, 0, false)
				->addField('username', 'USUARIO_WEB', ORMDefinition::STRING, 255, null, true)
				->addField('contactName', 'NOMBRE_CONTACTO', ORMDefinition::STRING, 255, null, true)
				->addField('contactLastName', 'APELLIDO_CONTACTO', ORMDefinition::STRING, 255, null, true)
				->addField('passwordWeb', 'PASSWORD_WEB', ORMDefinition::STRING, 255, null, true)
				->addInstance('user', 'USER_ID', 'User', true)
				->addField('created', 'FE_ALTA', ORMDefinition::DATE, null, null, false, 'NOW()')
				->addField('modified', 'FE_MODIFICACION', ORMDefinition::DATE, null, null, true)
				->addField('disabled', 'FE_BAJA', ORMDefinition::DATE, null, null, true)
				->addField('mail', 'MAIL_CONTACTO', ORMDefinition::STRING, 255, null, true)
				->addField('phone', 'TELEFONO1_CONTACTO', ORMDefinition::STRING, 255, null, true)
				->addField('alternativePhone', 'TELEFONO2_CONTACTO', ORMDefinition::STRING, 255, null, true)
				->addRelation1xN('sites', 'CLIENTE_ID', 'Site')
				->addInstance('payPlan', 'T_PAGO_ID', 'PayPlan')
				->addField('clientType', 'TIPO_CLIENTE', ORMDefinition::INTEGER)
				;
    // Bouml preserved body end 00116205
  }

  /**
   * Verifica si el objeto fue modificado y lo guarda.
   * Este m�todo permite abstraer a las clases descendientes de la necesidad de determinar si el objeto fue alterado o no y oculta la complejidad subyacente a las clases descendientes.
   * @param ORM $orm opcionalmente se debe indicar la instancia del ORM que mantiene el objeto. Esto s�lo es posible si el objeto es nuevo o DETACHED. En el caso que ya estuviera bajo monitoreo de un ORM arrojar� una excepci�n.
   * 
   * Se pens� en que se podr�a hacer el cambio de un ORM a otro, pero el ID deber�a limpiarse, con lo cual s�lo un INSERT se podr�a hacer sobre el destino y los objetos relacionados estar�an a�n con otro ORM lo cual es complicado (manejo de objetos distribu�dos) por lo cual se deja a consideraci�n de futuras versiones, posiblemente en otra vida =)
   */
  public function save(&$orm = null)
  {
    // Bouml preserved body begin 00171005
	$orm = ($orm === null) ? $this->orm : $orm;
	$this->orm = $orm;
	
	$params["p_user_id"] = 1;
	$params["p_razon_social"] = $this->getName();
	$params["p_licenciatario_id"] = $this->getReseller()->getId();
	$params["p_nro_cliente"] = $this->getClientNumber();
	$params["p_t_pago_id"] = $this->getPayPlan()->getId();
	$params["p_nombre_contacto"] = $this->getContactName();
	$params["p_apellido_contacto"] = $this->getContactLastName();
	$params["p_mail_contacto"] = $this->getMail();
	$params["p_telefono1_contacto"] = $this->getPhone();
	$params["p_telefono2_contacto"] = $this->getAlternativePhone();
	$params["p_usuario_web"] = $this->getUsername();
	$params["p_password_web"] = $this->getPasswordWeb();
	$params["p_tipo_cliente"] = $this->getClientType();
	
	$oUser = $this->getUser();
	
	$dbconn = $orm->getDatabase()->getConnection();
	
	$result = null;
	$lala = $dbconn->executeFunction("PKG_WEB_CLIENTE.FU_CLIENTE_INS", $params, $result, Connection::T_CURSOR);
	$asd = $dbconn->fetch($lala);
	$dbconn->free($lala);
	//var_dump($asd);
	//return true;
	if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
		$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
		throw new Exception($desc);
	} else {
		$this->setId($asd["LASTID"]);
		
		if (is_a($oUser, "User")) {
			$sql = "UPDATE CLIENTE SET USER_ID = :uxdid WHERE CLIENTE_ID = :cxdid";
			$ostmt = $dbconn->prepareStatement($sql);
			$uId = $oUser->getId();
			$bindeo = $dbconn->bind($ostmt, ":uxdid", $uId);
			$bindeo = $dbconn->bind($ostmt, ":cxdid", $asd["LASTID"]);
			$orst = $dbconn->execute($ostmt);
		}
	}
	return true;
    // Bouml preserved body end 00171005
  }

  /**
   * Borra f�sicamente un objeto de la base. Al borrarse el objeto adem�s se ponen a null los campos de las entidades relacionadas que lo referenciaban y se eliminan los registros de las tablas relaci�n M:N
   * 
   * @return boolean un booleando TRUE si la operaci�n fue concretada con �xito o FALSE sino.
   */
  public function delete()
  {
    // Bouml preserved body begin 00171085
	$orm = $this->orm;
	
	$params["p_user_id"] = 1;
	$params["p_cliente_id"] = $this->getId();
	
	$dbconn = $orm->getDatabase()->getConnection();
	
	$result = null;
	$lala = $dbconn->executeFunction("PKG_WEB_CLIENTE.FU_CLIENTE_DEL", $params, $result, Connection::T_CURSOR);
	$asd = $dbconn->fetch($lala);
	$dbconn->free($lala);
	if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
		$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
		throw new Exception($desc);
	}
	return true;
    // Bouml preserved body end 00171085
  }

}
?>
