<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/wholesale/Reseller.php';
require_once 'iplan/models/wholesale/Site.php';
require_once 'iplan/models/wholesale/Client.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Jorge Alexis Viqueira
* 
*/
class CDR extends ORMObject {
  /**
   * @var DateTime la fecha en que se cre� el registro
   */
  protected $created;

  /**
   * @var string
   */
  protected $prefix;

  /**
   * @var string el n�mero interno origen de la llamada
   */
  protected $numberA;

  /**
   * @var string la IP desde donde ingres� la solicitud
   */
  protected $ipA;

  /**
   * @var string el n�mero interno destino de la llamada
   */
  protected $numberB;

  /**
   * @var string la IP a donde se redireccion� el llamado?
   */
  protected $ipB;

  /**
   * @var DateTime timestamp de inicio del pedido de la llamada
   */
  protected $start;

  /**
   * @var DateTime momento en el que el tel�fono empez� a sonar en el destinatario
   */
  protected $ringing;

  /**
   * @var DateTime momento en que desde el destino atendieron.
   */
  protected $connect;

  /**
   * @var DateTime el instante en que se termin� de cursar el llamado.
   */
  protected $disconnect;

  /**
   * @var int @la duraci�n en segundos del llamado
   */
  protected $duration;

  /**
   * @var float el valor por unidad de fraccionamiento que se le aplica al CDR
   */
  protected $price;

  /**
   * @var string el c�digo de la moneda. Se corresponde con Currency::code
   */
  protected $currencyCode;

  /**
   * @var Reseller el licenciatario al que pertenece el site que gener� la llamada.
   */
  protected $reseller;

  /**
   * @var Site el sitio al que pertenece la llamada
   */
  protected $site;

  /**
   * @var Client el cliente que gener� la llamada
   */
  protected $client;

  /**
   * @var float el costo de la llamada. Corresponde (aprox) a price*duration/fractioningTime o algo as�
   */
  protected $totalPrice;

  /**
   * @var string la descripci�n del tipo de fraccionamiento. Se corresponde con FractionationType::description
   */
  protected $fractionationDesc;

  /**
   * @var float la cotizaci�n de la moneda en ese instante. Se corresponde con Currency::quotation de ese momento.
   */
  protected $quotation;

  /**
   * @var string el n�mero de tel�fono que se marc� en origen a su m�xima extensi�n +54011... Es el field "USER_NUMBER"
   */
  protected $phoneNumber;

  /**
   * @var string el n�mero que se marc� pero como se marc� (supongo). Mapea el campo LINEA
   */
  protected $lineNumber;

  /**
   * @var string indica si la llamada es entrante o saliente
   */
  protected $direction;

  /**
   * @var string una descripci�n de la zona GMT del origen de llamada.
   */
  protected $timeZone;

  /**
   * @var int un flag codificado con la causa del corte de la comunicaci�n
   */
  protected $terminationCause;

  /**
   * @var string una identificaci�n de BroadSoft del tipo de red sobre el que se curs� la llamada
   */
  protected $networkType;

  /**
   * @var string la codificaci�n de BroadSoft para el tipo de llamada
   */
  protected $networkCallType;

  /**
   * @var string otra vez el n�mero telef�nico? (este es interno?)
   */
  protected $networkTranslatedNumber;

  /**
   * @var string un tipo de codificaci�n de categor�a de llamada de BroadSoft
   */
  protected $callCategory;

  /**
   * @var string alg�n flag de BroadSoft. Generalmente "local" o "remote"
   */
  protected $releasingParty;

  /**
   * @var string una descripci�n del codec de audio empleado en la llamada
   */
  protected $codec;

  /**
   * @var string la IP de un dispositivo que intervino en la comunicaci�n.
   */
  protected $accessDeviceAddress;

  /**
   * @var string es un valor num�rico que por alguna raz�n se pone como string. Generalmente 1 o 0 :S
   */
  protected $redirectingReason;

  /**
   * @var string un caracter 'y' para indicar que la llamada tiene cargo y 'n' sino.
   */
  protected $chargeIndicator;

  /**
   * @var string otra cosa al pedo, todo NULL
   */
  protected $otherPartyName;

  /**
   * @var string otra descripci�n de BroadSoft que en maqueta es TODO NULL
   */
  protected $relatedCallidReason;

  /**
   * @var string el nombre de BroadSoft del Service Provider. Se corresponde con ServiceProvider::identifier
   */
  protected $serviceProviderName;

  /**
   * @var string un nombre de grupo de BroadSoft de la forma "70839-DAEWOO INTERNATIONAL COR". Ser�a el Site::group.
   */
  protected $groupName;

  /**
   * @var int un flag que en caso de ser 1 indica que la llamada es gratuita por alguna regla interna, es distinto del flag de CHARGE_INDIC que s�lo mira si la llamada es en el mismo grupo.
   */
  protected $free;

  /**
   * @var string indica como se tom� la llamada, por ejemplo para llamadas dentro del grupo se toma como "GROUP". Valores posibles: Internal, Network SRL??, Error, Network y Group
   */
  protected $asCallType;

  /**
   * @var int un c�digo de error de BroadSoft
   */
  protected $errorId;

  /**
   * @var string una constante que seg�n me cont� Pablo Zurzolo la inserta �l en base a dos m�todos de entrada y podr�an ocasionalmente darse en paralelo. Un m�todo tiene estados iniciados en ACR y el otro en CCR. Los estados finales indican que el CDR ya termin�, es decir, se consolid� y cualquier otro estado es en curso o que hubo un corte en la plataforma y ese CDR no se cobra al cliente.
   */
  protected $cdrState;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 0011D505
	return parent::define($orm)
				->setTable('CDRS')
				->addField('id', 'CDR_ID', ORM_TYPES::STRING, 500)//Clave VARCHAR(500)!!! OMG!!!
				->setKey('id')
				->addField('created', 'FE_ALTA', ORMDefinition::DATETIME, null, null, true)
				->addField('prefix', 'PREFIJO', ORMDefinition::STRING, 255)
				->addField('numberA', 'NUM_A', ORMDefinition::STRING, 255)
				->addField('ipA', 'IP_A', ORMDefinition::STRING, 50)//IP de 50 chars?? es para IPV12
				->addField('numberB', 'NUM_B', ORMDefinition::STRING, 255)
				->addField('ipB', 'IP_B', ORMDefinition::STRING, 50)//IP de 50 chars?? es para IPV12
				->addField('start', 'FE_START', ORMDefinition::DATETIME)
				->addField('ringing', 'FE_RINGING', ORMDefinition::DATETIME)
				->addField('connect', 'FE_CONNECT', ORMDefinition::DATETIME)
				->addField('disconnect', 'FE_DISCONNECT', ORMDefinition::DATETIME)
				->addField('start', 'FE_START', ORMDefinition::DATETIME)
				->addField('duration', 'DURACION', ORMDefinition::INTEGER,8)
				->addField('price', 'PRECIO', ORMDefinition::DECIMAL, 12, 4)//No es muchisimo??
				->addField('currencyCode', 'MONEDA_ID_PRECIO', ORMDefinition::STRING,3)
				->addInstance('reseller', 'LICENCIATARIO_ID', 'Reseller', true, null, ORM_LOAD_STYLE::LAZY_LOAD)
				->addInstance('site', 'SITIO_ID', 'Site', true, null, ORM_LOAD_STYLE::LAZY_LOAD)
				->addInstance('client', 'CLIENTE_ID', 'Client', true, null, ORM_LOAD_STYLE::LAZY_LOAD)
				->addField('totalPrice', 'PRECIO_TOTAL', ORMDefinition::DECIMAL,12,4)//No es muchisimo??
				->addField('fractionationDesc', 'T_FRACCIONAMIENTO_DESC', ORMDefinition::STRING,255)
				->addField('quotation', 'COTIZACION_ACTUAL_PRECIO', ORMDefinition::DECIMAL,12,4)
				->addField('phoneNumber', 'USER_NUMBER', ORMDefinition::STRING,255)//No es muchisimo??
				->addField('lineNumber', 'LINEA', ORMDefinition::STRING,255)//No es muchisimo??
				->addField('direction', 'DIRECTION', ORMDefinition::STRING,11)
				->addField('timeZone', 'USER_TIMEZONE', ORMDefinition::STRING,20)
				->addField('terminationCause', 'TERMINATION_CAUSE', ORMDefinition::INTEGER,3)
				->addField('networkType', 'NETWORK_TYPE', ORMDefinition::STRING,4)
				->addField('networkCallType', 'NETWORK_CALL_TYPE', ORMDefinition::STRING,4)
				->addField('networkTranslatedNumber', 'NETWORK_TRANSLATED_NUMBER', ORMDefinition::STRING,255)//Mucho también?
				->addField('callCategory', 'CALL_CATEGORY', ORMDefinition::STRING,8)
				->addField('releasingParty', 'RELEASING_PARTY', ORMDefinition::STRING,6)
				->addField('codec', 'CODEC', ORMDefinition::STRING,30)
				->addField('accessDeviceAddress', 'ACCESS_DEVICE_ADDRESS', ORMDefinition::STRING,80)
				->addField('redirectingReason', 'REDIRECTING_REASON', ORMDefinition::STRING,40)
				->addField('chargeIndicator', 'CHARGE_INDIC', ORMDefinition::STRING,1)
				->addField('otherPartyName', 'OTHER_PARTY_NAME', ORMDefinition::STRING,255)//Mucho?
				->addField('relatedCallidReason', 'RELATED_CALLID_REASON', ORMDefinition::STRING,40)
				->addField('serviceProviderName', 'SERVICE_PROVIDER', ORMDefinition::STRING,255)
				->addField('groupName', 'GROUP_', ORMDefinition::STRING,255)
				->addField('free', 'FL_GRATUITO', ORMDefinition::INTEGER,1)
				->addField('asCallType', 'AS_CALL_TYPE', ORMDefinition::STRING,255)//Mucho?
				->addField('errorId', 'ERROR_ID', ORMDefinition::INTEGER,8)
				->addField('cdrState', 'CDR_ESTADO', ORMDefinition::STRING,50);
    // Bouml preserved body end 0011D505
  }

}
?>