<?php

/**
 * Funcion para Modificar un Usuario de Fax en las plataformas correspondientes
 * 
 * @param stdClass $pedido
 * @return SoapFault|boolean
 */
function ModifyUser($pedido) {
	
	$proceso_id = $_SESSION["WS_PROCESO_ID"];
	
	$log = LogMessages::GetInstance();
	$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 26, "Operation: ModifyUser, IP: " . $_SERVER["REMOTE_ADDR"], null, $proceso_id);
	//$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CA, 0, "Parámetros: Linea [$linea] Mail [$mail] Tipo [$tipo]", null, $proceso_id);
	
	if ((!isset($pedido->fax_number)) || ($pedido->fax_number == "")) {
		return new SoapFault("Client", "No se pudo realizar la operación", "Client", "Debe suministrar un número de fax", "NormalFault");
	}
	
	$user_old_mail = $pedido->smtpAddress;
	$user_fax_number = $pedido->fax_number;
	$user_new_mail = isset($pedido->new_smtpAddress) ? $pedido->new_smtpAddress : "";
	$user_password = isset($pedido->new_password) ? $pedido->new_password : "";
	
	if ((!$user_password) && (!$user_new_mail))
		return new SoapFault("Client", "No se pudo realizar la operación", "Client", "Debe suministrar por lo menos un mail o password para actualizar", "NormalFault");
	
	$application = Application::getInstance();
	$context = $application->getContext();
	$orm = $application->getORM();
	$dbconn = $orm->getDatabase()->getConnection(); //Traigo la Conexion
		
	//Me traigo los datos de la base
	$params = array("p_user_id" => $_SESSION["WS_USER_EJECUTA_PACKAGES"], "p_linea" => "$user_fax_number");
	$result = null;
	$lala = $dbconn->executeFunction("PKG_WEB_LINEAS.FU_NRO_CLIENTE_LINEA_SEL", $params, $result, Connection::T_CURSOR);
	$asd = $dbconn->fetch($lala);
	$dbconn->free($lala);
	if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
		$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 5, "PKG_WEB_LINEAS.FU_NRO_CLIENTE_LINEA_SEL [$desc]", null, $proceso_id);
		$log->AddLog(LogMessages::LOG_INFORMATION, LogMessages::SYS_CAF, 24, "No existe registro de la línea [$user_fax_number]", null, $proceso_id);
		return new SoapFault("Server", "Hubo un error al procesar el pedido", "Server", "No existe registro de la línea", "NormalFault");
	} else {
		//$cliente_id = $asd["NRO_CLIENTE"];
		$razon_social = $asd["RAZON_SOCIAL"];
		$fax_entrante_saliente = $asd["FAX_ENTRANTE_SALIENTE"];
	}
	
	if (($fax_entrante_saliente) && (!$user_old_mail))
		return new SoapFault("Client", "No se pudo realizar la operación", "Client", "El serivico cuenta con fax salientes, debe suministrar un smtpAddress", "NormalFault");
	
	if ($user_new_mail) {
	
		//Modificar en Broadsoft
		$bsws = BroadsoftXMLWS::getInstance(BroadsoftXMLWS::WSDL_WS, BroadsoftXMLWS::USER_WS, BroadsoftXMLWS::PASSWORD_WS, $log);
		$serviceCentralIUNI = new ProvisioningIUNI($bsws, $log, $dbconn, 1, null, $proceso_id, null);
		$resModFax = $serviceCentralIUNI->ModifyMailMessagingInternoIUNI($user_fax_number, $user_new_mail);
		if (($resModFax == false) || ($resModFax["estado"] == "error"))  {
			//Logueo error
			$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6,  "Modificar el Interno en Broadsoft [$user_fax_number] Mail [$user_new_mail]", null, $proceso_id);
			$msgErr = ProvisioningPlataformas::erroresAString($resModFax["Resultados"]);
			$log->AddLog(LogMessages::LOG_ERROR, LogMessages::SYS_BS, 6, $msgErr, null, $proceso_id, null);
			return new SoapFault("Server", "Fallo ejecutar la modificacion de correo en Broadsoft", "Server", array("codigo"=>"Broadsoft", "descripcion" => $msgErr), "ExtendedFault");
		}
		
	}
	
	if ($fax_entrante_saliente) {
		//Modifico en XMedius solo si existe.
		$servicePlataformas = new ProvisioningPlataformas($dbconn, $log, 1, $proceso_id, null, null);
		$res_xm = $servicePlataformas->XMediusModUserPass($razon_social, $user_old_mail, $user_new_mail, $user_password);
		if ($res_xm["codigo"] != "0") {
			return new SoapFault("Server", "Fallo ejecutar la acción en xmedius", "Server", array("codigo"=>"XMedius", "descripcion" => $res_xm["descripcion"]), "ExtendedFault");
		}
	}
	
	return true;
}


?>