<?php

/**
 * Genera un ID de proceso para asociar los datos
 * 
 * @param OracleConnection $dbconn La conección a base de datos.
 * @param integer $userEjecutaPackages  el ID de usuario que manda a ejecutar paquetes
 * @param integer $LogMessasgesSystem alguna de las constantes de LogMessages::SYS_*
 * @return SoapFault|integer Devuelve el ID de proceso o un SoapFault en caso de fallo.
 */
function GenerarProceso($dbconn, $userEjecutaPackages, $LogMessasgesSystem) {

	$proceso_id = null;
	$params = array("p_user_id" => (int)$userEjecutaPackages, "p_estado" => 3);
	$result = null;
	$lala = $dbconn->executeFunction("PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS", $params, $result, Connection::T_CURSOR);
	$asd = $dbconn->fetch($lala);
	$dbconn->free($lala);
	if ( (!is_array($asd)) || (( isset($asd["SQLCODE_ERROR"])) && ($asd["SQLCODE_ERROR"] != "200")) ) {
		$desc = LogMessages::erroresArray($asd) . " P: " . LogMessages::erroresArray($params);
		$log->AddLog(LogMessages::LOG_INFORMATION, $LogMessasgesSystem, 5, "PKG_CAP_PROCESOTASKS.FU_PROCESOTASKS_INS [$desc]");
		return new SoapFault("Server", "Hubo un error al procesar el pedido", "Server", "El servicio no puede generar un registro de proceso para la operación");
	} else {
		$proceso_id = $asd["LASTID"];
	}

	return $proceso_id;
}

/**
 * Ejecuta la autenticación del usuario y lo guarda en $_SESSION['uws_user_id'].
 * 
 * @param Object $header stdClass->Username con el nombre de usuario y stdClass->Password con el password.
 * @return SoapFault|null devuelve un SoapFault o null en caso de que haya autenticado correctamente
 */
function AuthHeader($header) {
	
	$application = Application::getInstance();
	$context = $application->getContext();
	$orm = $application->getORM();
	
	$log = LogMessages::GetInstance();
	
	if ((!isset($header->Username)) || ($header->Username == "") || (!isset($header->Password))) {
		return new SoapFault("Client", "Fallo al autenticar el usuario", "Client", "Debe suministrar un usuario y una contraseña");
	}
	
	$context->set("username", $header->Username);
	$context->set("password", $header->Password);
	
	$login = $application->execute("Security.login");
	$context = $application->getContext();
	$errores = $context->get("errors");
	
	//Error de Sistema
	if (!is_a($login, "Renderable")) return new SoapFault("Server", "Hubo un error al procesar la autenticación", "Server", "No se recibió la respuesta esperada");
	
	$aErrors = array();
	if (is_array($errores) && isset($errores['messages'])) {
		if (is_array($errores['messages']))	{
			for ($i = 0; $i < count($errores['messages']); $i++) {
				if ($errores['messages'][$i]['descriptions']) $aErrors[] = $errores['messages'][$i]['descriptions'];
			}
		}
	}
	$desc_errores = implode("|", $aErrors);
	
	if ($desc_errores) {
		return new SoapFault("Client", "Fallo al autenticar el usuario", "Client", $desc_errores);
	}
	
	$aUser = $orm->query("User")->attributes("id")->filterBy("username", "=", $header->Username)->findOne();
	
	$_SESSION['uws_user_id'] = $aUser["id"];
	
}

/**
 * Verifica si el usuario tiene permiso para ejecutar la acción.
 * 
 * @param ORM $orm El ORM donde se verifica.
 * @param ApplicationContext $context El contexto sobre el cual se verifica
 * @param string $action La acción a verificar en formato: Facade.Alias
 * @return false en caso de no existir la acción o no tener permiso.
 * @throws Exception En caso de estar mal el formato de acción.
 */
function VerificarPermiso($orm, $context, $action) {
	
	if (strpos($action, ".")) { //Si no tiene Alias.Action está mal
		$parts = explode('.', $action);
		if (count($parts)==2) {
			$facadeAlias = $parts[0];
			$actionAlias = $parts[1];
		} else {
			throw new Exception('La accción debe expresarse como FacadeAlias.ActionAlias'); //No hay 2 partes
		}
	} else return false; // No hay punto
	
    $actionQuery = $orm->query('Action')
						->filterBy('alias', '=', $actionAlias)
						->filterBy('facade.alias', '=', $facadeAlias)
						->filterBy('profiles.provider.id', '=', $context->getProvider()->getId())
						->filterBy('profiles.domains.id', '=', $context->getDomain()->getId())
						->filterBy('profiles.users.id', '=', $context->getUser()->getId())
						->orderBy('id ASC');
    $actionObj = $actionQuery->findOne();
	
	if ($actionObj == false) return false; //Si no existe la acción o no tiene permiso

	return true;
	
}

?>