<?php

/**
 * 
 * @param type $pedido
 */
function ResultadoOperacion($pedido) {
	
	$application = Application::getInstance();
	$context = $application->getContext();
	$orm = $application->getORM();
	
	try {
		$tiene_permiso = VerificarPermiso($orm, $context, "AutoProvisioning.ResultadoOperacion");
		if (!$tiene_permiso)
			throw new SoapFault("Client", "No se pudo realizar la operación", "Client", "El usuario no tiene permiso para ejecutar la acción.");
	} catch (SoapFault $sf) {
		return $sf;
	} catch (Exception $e) {
		return new SoapFault("Client", "No se pudo realizar la operación", "Client", $e->getMessage());
	}
	
	if ((!isset($pedido->idTask) || ($pedido->idTask === ""))) {
		return new SoapFault("Client", "No se pudo realizar la operación", "Client", "Debe especificar un idTask", "NormalFault");
	}
	if ((!isset($pedido->codigo) || ($pedido->codigo === ""))) {
		return new SoapFault("Client", "No se pudo realizar la operación", "Client", "Debe especificar un codigo", "NormalFault");
	}
	
	if ($pedido->idTask == "1") {
		return new SoapFault("Client", "Tarea no registrada", "Client", array("codigo"=>"1", "descripcion" => "La tarea 1 no se encuentra en el sistema"), "ExtendedFault");
	}
	
	return true;
}

?>