<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/orm/ORMObject.php';



/**
* Author: Federico G. Bernoldi
* 
*/
class TelephoneModelForm extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 0016D905
	parent::__construct($orm, $context);
	
	$this->setClass("TelephoneModel")
			->setMethod("post")
			->setFormType(Form::FORM_OK_CANCEL)
			->setEnctype("multipart/form-data");
	
	$selEstado = new SelectComponent('Estado', 'flt_state', 'state');
	$selEstado->setOptions(	array(
								array('value' => TelephoneModel::TELEPHONE_ACTIVE, 'description' => "Activo"),
								array('value' => TelephoneModel::TELEPHONE_INACTIVE, 'description' => "Inactivo")
								)
							);
	
	$compTemplate = new TextComponent("Template específico dinámico", "template", "template");
	$compTemplate->setSize(10);
	
	$compGeneric = new TextComponent("Template general", "generic", "generic");
	$compGeneric->setSize(10);
	
	$compModelo = new TextComponent("Modelo", "model", "model");
	$compModelo->setSize(30);
	
	$file_template = new FileComponent("Archivo", "file_template");
	$file_generico = new FileComponent("Archivo", "file_generico");
	
	$oLayout1 = new GridLayout(8, 3);
	$oLayout1->addComponent($compModelo, 1, 1, 3, 1)
			 ->addComponent(new TextComponent("Cant. Lineas", "numberLines", "numberLines"), 2, 1, 2, 1)
			 ->addComponent($compTemplate, 3, 1)->addComponent($file_template, 3, 2)
			 ->addComponent(new ActionComponent("Descargar Dinámico", "action1", "id", "AutoProvisioning.downTelModelDynamic", array(), "popup", null, "xd", null, null), 3, 3)
			 ->addComponent(new TextComponent("Extensión del template", "extension", "extension"), 4, 1, 3, 1)
			 ->addComponent(new TextComponent("Enable value", "enableValue", "enableValue"), 5, 1, 3, 1)
			 ->addComponent(new TextComponent("Disable value", "disableValue", "disableValue"), 6, 1, 3, 1)
			 ->addComponent($compGeneric, 7, 1)->addComponent($file_generico, 7, 2)
			->addComponent(new ActionComponent("Descargar Genérico", "action2", "id", "AutoProvisioning.downTelModelGeneric", array(), "popup", null, "xd", null, null), 7, 3)
			 ->addComponent($selEstado, 8, 1, 3, 1)
			;
	
	$this->addComponent($oLayout1);
	
	$this->setAction($context->getCurrentAction()->getStringCommand());
	return $this;
    // Bouml preserved body end 0016D905
  }

  /**
   * Funci�n invocada para modificar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function modify($context, $orm)
  {
    // Bouml preserved body begin 0019A585
	$object = $orm->load($this->getClass(), $this->getValueOf('id'));
	$object->setTemplate(basename($object->getTemplate()));
	$object->setGeneric(basename($object->getGeneric()));
	$this->getValuesFromObject($object);
	return true;
    // Bouml preserved body end 0019A585
  }
  
  /**
   * Funci�n invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return ORMObject el objeto ya guardado si todo sali� bien y un FALSE sino.
   */
  public function save($context, $orm)
  {
    // Bouml preserved body begin 0019A485
	require_once 'iplan/models/provisioning/ProvisioningPlataformas.php';
	
	$id = $this->getValueOf('id');
	$valido = $this->validate();
	
	$file_template_value = $this->getValueOf("file_template");
	$file_generico_value = $this->getValueOf("file_generico");
	
	$buscar_template = ProvisioningPlataformas::TELEPHONE_TEMPLATE_PATH . $this->getValueOf('template');
	$buscar_generico = ProvisioningPlataformas::TELEPHONE_GENERICO_PATH . $this->getValueOf('generic');
	
	$oBuscarTemplate = $orm->query("TelephoneModel")->attributes("model")->filterBy("template", "=", $buscar_template);
	$oBuscarGenerico = $orm->query("TelephoneModel")->attributes("model")->filterBy("generic", "=", $buscar_generico);
	
	if (!$id) {
		//Si es nuevo
		$aFallo = array();
		if (!$file_template_value) {
			//Si o si debe meter un file
			$aFallo[] = "Falta el template dinámico";
		}
		if (!$file_generico_value) {
			//Si o si debe meter un file
			$aFallo[] = "Falta el template general";
		}
		if (count($aFallo) > 0) {
			$aErrores = array(	"title" => "Error de Template",
								"messages" => array(array("descriptions" => $aFallo)));
			$context->set("errors", $aErrores);
			return false;
		}
	} else {
		$oBuscarTemplate->filterBy("id", "!=", $id);
		$oBuscarGenerico->filterBy("id", "!=", $id);
	}
	
	//Verifico que no exista ya uno en base de datos con ese nombre
	$aBuscarTemplate = $oBuscarTemplate->findOne();
	$aBuscarGenerico = $oBuscarGenerico->findOne();
	
	
	if (is_array($aBuscarTemplate) && count($aBuscarTemplate)) {
		$aErrores = array(	"title" => "Template específico dinámico",
							"messages" => array(array("descriptions" => array("El nombre ya existe para el modelo: " . $aBuscarTemplate["model"]))));
		$context->set("errors", $aErrores);
		return false;
	}
	if (is_array($aBuscarGenerico) && count($aBuscarGenerico)) {
		$aErrores = array(	"title" => "Template específico dinámico",
							"messages" => array(array("descriptions" => array("El nombre ya existe para el modelo: " . $aBuscarGenerico["model"]))));
		$context->set("errors", $aErrores);
		return false;
	}
	
	if ($file_template_value) {
		//Si me postearon un archivo
		$temporal_leido = file_get_contents($file_template_value['tmp_name']);
	} else {
		//Sino utilizo el archivo existente
		$oTModel = $orm->load("TelephoneModel", $id);
		$temporal_leido = file_get_contents($oTModel->getTemplate());
	}
	
	if ($file_generico_value) {
		//Si me postearon un archivo
		$temporal_leido_general = file_get_contents($file_generico_value['tmp_name']);
	} else {
		//Sino utilizo el archivo existente
		$oTModel = $orm->load("TelephoneModel", $id);
		$temporal_leido_general = file_get_contents($oTModel->getGeneric());
	}
	
	//Si los pude leer a los archivos sigo, sino cancelo.
	if ($temporal_leido == false) {
		$aErrores = array(	"title" => "Error de Template Dinámico",
								"messages" => array(array("descriptions" => array("Ha ocurrido un error al intentar leer el archivo, por favor especifíque uno nuevo."))));
		$context->set("errors", $aErrores);
		return false;
	}
	if ($temporal_leido_general == false) {
		$aErrores = array(	"title" => "Error de Template General",
								"messages" => array(array("descriptions" => array("Ha ocurrido un error al intentar leer el archivo, por favor especifíque uno nuevo."))));
		$context->set("errors", $aErrores);
		return false;
	}
	
	//Cant Lineas posteadas
	$cantLineas = $this->getValueOf("numberLines");
	
	//Cosas a buscar en los files
	$params_template = array();
	for ($r = 1; $r <= (int)$cantLineas; $r++) {
		$params_template[] = "#!ENABLE_SIP_$r!#";
		$params_template[] = "#!USUARIO_SIP_$r!#";
		$params_template[] = "#!PASSWORD_SIP_$r!#";
		/*$params_template[] = "#!DIALPLAN_SIP_$r!#"; //Quitado porque el audiocodes no lleva */
	}
	
	//Verifico el template dinámico
	$faltan = array();
	foreach ($params_template as $needle) {
		if (substr_count($temporal_leido, $needle) == 0) {
			$faltan[] = $needle;
		}
	}
	if (count($faltan) > 0) {
		$aErrores = array(	"title" => "Error de Template Dinámico",
							"messages" => array(array("descriptions" => array("Faltan definir los valores para: " . implode(", ", $faltan)))));
		$context->set("errors", $aErrores);
		return false;
	}
	
	//Verifico el template general
	$sobran = array();
	foreach ($params_template as $needle) {
		if (substr_count($temporal_leido_general, $needle) > 0) {
			$sobran[] = $needle;
		}
	}
	if (count($sobran) > 0) {
		$aErrores = array(	"title" => "Error de Template General",
							"messages" => array(array("descriptions" => array("No pueden estar definidos los valores: " . implode(", ", $sobran)))));
		$context->set("errors", $aErrores);
		return false;
	}
	
	$this->setValueOf('template', $buscar_template);
	$this->setValueOf('generic', $buscar_generico);
	
	try {
	
		if (!$valido) return $valido;
		
		$file_template = $this->getComponent("file_template");
		$file_generico = $this->getComponent("file_generico");
		
		$archTemplate = ProvisioningPlataformas::TELEPHONE_TEMPLATE_PATH . basename($this->getValueOf("template"));
		$archGenerico = ProvisioningPlataformas::TELEPHONE_GENERICO_PATH . basename($this->getValueOf("generic"));
		$info_template = pathinfo($archTemplate);
		$info_generico = pathinfo($archGenerico);

		if ($id == null) {
			//Caso nuevo.
			$file_template->placeIn($file_template_value, $info_template["dirname"], $info_template["basename"]);
			$file_generico->placeIn($file_generico_value, $info_generico["dirname"], $info_generico["basename"]);

			$class = $this->getClass();
			$object = new $class();
			$this->setValuesToObject($object);
		} else {
			//Caso modificar
			$object = $orm->load($this->getClass(), $this->getValueOf('id'));
			$this->setValuesToObject($object);
			if ($file_template_value)
				$file_template->placeIn($file_template_value, $info_template["dirname"], $info_template["basename"]);
			if ($file_generico_value)
				$file_template->placeIn($file_generico_value, $info_generico["dirname"], $info_generico["basename"]);
		}
		$object->setTemplate(ProvisioningPlataformas::TELEPHONE_TEMPLATE_PATH . basename($this->getValueOf('template')));
		$object->setGeneric(ProvisioningPlataformas::TELEPHONE_GENERICO_PATH . basename($this->getValueOf('generic')));
		$orm->save($object);
	} catch (Exception $e) {
		$this->setValueOf('template', basename($this->getValueOf('template')));
		$this->setValueOf('generic', basename($this->getValueOf('generic')));
		throw $e;
	}
	return $object;
    // Bouml preserved body end 0019A485
  }

  /**
   * Funci�n invocada para borrar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function delete($context, $orm)
  {
    // Bouml preserved body begin 0019A505
	return parent::delete($context, $orm);
    // Bouml preserved body end 0019A505
  }

}
?>