<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/orm/ORMObject.php';



/**
* Author: Federico G. Bernoldi
* 
*/
class RouterModelForm extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 0019A305
	parent::__construct($orm, $context);
	
	$this->setClass("RouterEquipos")
			->setMethod("post")
			->setFormType(Form::FORM_OK_CANCEL)
			->setEnctype("multipart/form-data");
	
	$selEstado = new SelectComponent('Estado', 'flt_state', 'state');
	$selEstado->setOptions(	array(
								array('value' => TelephoneModel::TELEPHONE_ACTIVE, 'description' => "Activo"),
								array('value' => TelephoneModel::TELEPHONE_INACTIVE, 'description' => "Inactivo")
								)
							);
	
	$selTR069 = new SelectComponent('TR069', 'flt_tr069', 'tr069');
	$selTR069->setOptions(	array(
								array('value' => 0, 'description' => "No"),
								array('value' => 1, 'description' => "Si")
								)
							);
	$selTR069->setOptional(false);
	
	$file_template = new FileComponent("Archivo", "file_template");
	
	$compDescripcion = new TextComponent("Descripción", "descripcion", "descripcion");
	$compDescripcion->setSize(30);
	
	
	/*$compTemplate = new TextComponent("Path Template", "pathTemplate", "pathTemplate");
	$compTemplate->setSize(60);*/
	
	$compFilename = new TextComponent("Filename", "filename", "filename");
	$compFilename->setSize(50);
	
	$oLayout1 = new GridLayout(5, 1);
	$oLayout1->addComponent($compDescripcion, 1, 1)
			 ->addComponent($file_template, 2, 1)
			 ->addComponent($compFilename, 3, 1)
			 ->addComponent($selTR069, 4, 1)
			 ->addComponent($selEstado, 5, 1);
	
	$this->addComponent($oLayout1);
	
	//$this->setAction($context->getCurrentAction()->getStringCommand());
	return $this;
    // Bouml preserved body end 0019A305
  }

  /**
   * Funci�n invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return ORMObject el objeto ya guardado si todo sali� bien y un FALSE sino.
   */
  public function save($context, $orm)
  {
    // Bouml preserved body begin 0019A385
	require_once 'iplan/models/provisioning/ProvisioningPlataformas.php';
	
	$id = $this->getValueOf('id');
	$valido = $this->validate();
	
	$params_template = array(	'#!USUARIO!#', '#!PASSWORD!#', '#!IP!#', '#!TR069CONREQURL!#', '#!PORT!#', '#!MASK!#', '#!GATEWAY!#', '#!SSID1!#', '#!PASS1!#',
								'#!SSID2!#', '#!PASS2!#', '#!SSID3!#', '#!PASS3!#', '#!SSID4!#', '#!PASS4!#');
	
	$file_template_value = $this->getValueOf("file_template");
	
	$archivo_usar = $this->getValueOf("filename");
	
	if ((!$file_template_value) && (!$id) && ($archivo_usar)) {
		$aErrores = array(	"title" => "Error de Template",
							"messages" => array(array("descriptions" => array("Debe especificar un archivo."))));
		$context->set("errors", $aErrores);
		return false;
		
		
		$temporal_leido = file_get_contents($file_template_value['tmp_name']);
		if ($temporal_leido == false) {
			$aErrores = array(	"title" => "Error de Template",
								"messages" => array(array("descriptions" => array("Ha ocurrido un error al intentar leer el archivo, por favor especifíque uno nuevo."))));
			$context->set("errors", $aErrores);
			return false;
		}
		$faltan = array();
		foreach ($params_template as $needle) {
			if (substr_count($temporal_leido, $needle) == 0) {
				$faltan[] = $needle;
			}
		}
		if (count($faltan) > 0) {
			$aErrores = array(	"title" => "Error de Template",
								"messages" => array(array("descriptions" => array("Faltan definir los valores para: " . implode(", ", $faltan)))));
			$context->set("errors", $aErrores);
			return false;
		}

		
	}
	
	$file_template = $this->getComponent("file_template");

	$archTemplate = ProvisioningPlataformas::ROUTER_TEMPLATE_ORIGEN_PATH . $this->getValueOf("filename");
	$info_template = pathinfo($archTemplate);
	
	if ($id == null) {
		$class = $this->getClass();
		$object = new $class();
		
		if ($archivo_usar)
			$file_template->placeIn($file_template_value, $info_template["dirname"], $info_template["basename"]);
		$this->setValuesToObject($object);
		
	} else {
		//Caso modificar
		$object = $orm->retrieve($this->class, $this->getValueOf('id'));
		if (!is_object($object))
			$object = $orm->load($this->class, $this->getValueOf('id'));
		$this->setValuesToObject($object);
		if (($file_template_value) && ($archivo_usar))
			$file_template->placeIn($file_template_value, $info_template["dirname"], $info_template["basename"]);
	}
	if ($archivo_usar) {
		$object->setPathTemplate(ProvisioningPlataformas::ROUTER_TEMPLATE_ORIGEN_PATH);
	} else {
		$object->setPathTemplate("");
	}
	if ($valido === true) {
		$orm->save($object);
		return $object;
	} else {
		//Seteo error de contexto de validacion xd.-
		return $valido;
	}
    // Bouml preserved body end 0019A385
  }

  /**
   * Funci�n invocada para borrar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function delete($context, $orm)
  {
    // Bouml preserved body begin 0019A405
	return parent::delete($context, $orm);
    // Bouml preserved body end 0019A405
  }

}
?>