<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/orm/ORMObject.php';



/**
* Author: Federico G. Bernoldi
* 
*/
class ProvisioningTaskConfigurationForm extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 0018A505
	parent::__construct($context, $orm);
	
	$this->setMethod("post")->setFormType(Form::FORM_OK_CANCEL);
	$this->setClass("ProvisioningTaskConfiguration")
			->setTitle("Formulario de Configuración de Tarea");
	
	$aOpcionesPlataforma = $orm->query("ProvisioningPlataform")->attributes("id as value", "name as description")->find();
	$compPlataforma = new SelectComponent();
	$compPlataforma->setLabel("Plataforma")
			->setMaps('plataform')
			->setOptions($aOpcionesPlataforma)
			->setOptional(false);
	
	$aOpcionesClaseRaw = $orm->query("ProvisionableClass")->attributes("id as value", "classname", "provider.name as providerName")->find();
	$aOpcionesClase = array();
	if (is_array($aOpcionesClaseRaw) && (count($aOpcionesClaseRaw) > 0)) {
		for ($i = 0; $i < count($aOpcionesClaseRaw); $i++) {
			$value = $aOpcionesClaseRaw[$i]["value"];
			$description = $aOpcionesClaseRaw[$i]["providerName"] . " - " .  $aOpcionesClaseRaw[$i]["classname"];
			$aOpcionesClase[] = array("value" => $value, "description" => $description);
		}
	}
	$compClase = new SelectComponent();
	$compClase->setLabel("Clase")
			->setMaps('class')
			->setOptions($aOpcionesClase)
			->setOptional(false);
	
	$layout = new GridLayout(2, 1);
	$layout->addComponent($compPlataforma, 1, 1)
			->addComponent($compClase, 2, 1)
			;
	
	$this->addComponent($layout);
	
	$this->setAction($context->getCurrentAction()->getStringCommand());
	return $this;
    // Bouml preserved body end 0018A505
  }

  /**
   * Funci�n invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return ORMObject el objeto ya guardado si todo sali� bien y un FALSE sino.
   */
  public function save($context, $orm)
  {
    // Bouml preserved body begin 0018A585
	return parent::save($context, $orm);
    // Bouml preserved body end 0018A585
  }

  /**
   * Funci�n invocada para borrar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function delete($context, $orm)
  {
    // Bouml preserved body begin 0018A605
	return parent::delete($context, $orm);
    // Bouml preserved body end 0018A605
  }

}
?>