<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';



/**
* Author: Federico G. Bernoldi
* 
*/
class ProvisioningStatusForm extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 0018A805
	parent::__construct($context, $orm);
	
	$this->setMethod("post")->setFormType(Form::FORM_OK_CANCEL);
	$this->setClass("ProvisioningStatus")
			->setTitle("Formulario de Estado de Provisioning");
	
	$compDescription = new TextComponent("Descripción", "description", "description");
	
	$layout = new GridLayout(1, 1);
	$layout->addComponent($compDescription, 1, 1);
	
	$this->addComponent($layout);
	
	$this->setAction($context->getCurrentAction()->getStringCommand());
	return $this;
    // Bouml preserved body end 0018A805
  }

}
?>