<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';



/**
* Author: Federico G. Bernoldi
* 
*/
class ProvisioningOperationTypeForm extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 0018A685
	parent::__construct($context, $orm);
	
	$this->setMethod("post")->setFormType(Form::FORM_OK_CANCEL);
	$this->setClass("ProvisioningOperationType")
			->setTitle("Formulario de Tipos de Operación");
	
	$compDescription = new TextComponent("Descripción", "description", "description");
	$compDescription->setSize(30);
	
	$layout = new GridLayout(1, 1);
	$layout->addComponent($compDescription, 1, 1);
	
	$this->addComponent($layout);
	
	$this->setAction($context->getCurrentAction()->getStringCommand());
	return $this;
    // Bouml preserved body end 0018A685
  }

}
?>