<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/orm/ORMObject.php';



/**
* Author: Federico G. Bernoldi
* 
*/
class ProvisionableClassForm extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 0018A385
	parent::__construct($context, $orm);
	
	$this->setMethod("post")->setFormType(Form::FORM_OK_CANCEL);
	$this->setClass("ProvisionableClass");
	
	$compDescription = new TextComponent("Nombre", "classname", "classname");
	
	$aOpciones = $orm->query("Provider")->attributes("id as value", "name as description")->find();
	$compProvider = new SelectComponent();
	$compProvider->setLabel("Provider")
			->setMaps('provider')
			->setOptions($aOpciones)
			->setOptional(false);
	
	$layout = new GridLayout(2, 1);
	$layout->addComponent($compDescription, 1, 1)
			->addComponent($compProvider, 2, 1)
			;
	
	$this->addComponent($layout);
	
	$this->setAction($context->getCurrentAction()->getStringCommand());
	return $this;
    // Bouml preserved body end 0018A385
  }

  /**
   * Funci�n invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return ORMObject el objeto ya guardado si todo sali� bien y un FALSE sino.
   */
  public function save($context, $orm)
  {
    // Bouml preserved body begin 0018A405
	return parent::save($context, $orm);
    // Bouml preserved body end 0018A405
  }

  /**
   * Funci�n invocada para borrar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function delete($context, $orm)
  {
    // Bouml preserved body begin 0018A485
	return parent::delete($context, $orm);
    // Bouml preserved body end 0018A485
  }

}
?>