<?php
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/web/ABMFormMinimal.php';



/**
* Author: Federico G. Bernoldi
* 
*/
class DialPlanForm extends ABMFormMinimal {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 0016D985
	parent::__construct($context, $orm);
	
	$this->setMethod("post")->setFormType(Form::FORM_OK_CANCEL);
	
	$compCity = new TextComponent("Ciudad", "city");
	
	$compDialPlan = new TextComponent("DialPlan", "dialplan");
	$compDialPlan->setSize(60)->setMaxlength("500");
	
	$compPrefijo = new TextComponent("Prefijo", "prefix");
	$compPrefijo->setSize(50)->setValidate(array("numeric", "required"));
	
	$selModel = new SelectComponent('Modelo', 'model');
	$selModel->setOptions($orm->query("TelephoneModel")->attributes("id AS value", "model as description")->find());
	$selModel->setValidate("required");
	
	$layout = new GridLayout(4, 1);
	$layout->addComponent($compPrefijo, 1, 1)
		   ->addComponent($selModel, 2, 1)
		   ->addComponent($compCity, 3, 1)
		   ->addComponent($compDialPlan, 4, 1);
	
	$this->addComponent($layout);
	
	$this->setAction($context->getCurrentAction()->getStringCommand());
	return $this;
    // Bouml preserved body end 0016D985
  }

  /**
   * Funci�n invocada para modificar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function modify($context, $orm)
  {
    // Bouml preserved body begin 0016DC85
	/*
	 * Tomo el ID hago la consulta y meto los datos
	 */
	$conn = $orm->getDatabase()->getConnection();
	$prefix = $this->getValueOf("prefix");
	$model = $this->getValueOf("model");
	
	if (($prefix != "") && ($model != ""))  {
		$sql = 'SELECT	CD.PREFIJO "prefix",
						CD.CIUDAD "city",
						CD.DIALPLAN "dialplan",
						CD.TELEFONO_ID "model"
				FROM CAP_DIALPLAN CD
				WHERE PREFIJO = :pre AND TELEFONO_ID = :te '; 
		
		$ostmt = $conn->prepareStatement($sql);
		$bindeo = $conn->bind($ostmt, ":te", $model);
		$bindeo = $conn->bind($ostmt, ":pre", $prefix);
		$orst = $conn->execute($ostmt);
		$aDato = $conn->fetch($ostmt);
		if (is_array($aDato) && (count($aDato) > 0)) {
			$this->setValueOf("prefix", $aDato["prefix"]);
			$this->setValueOf("city", $aDato["city"]);
			$this->setValueOf("dialplan", $aDato["dialplan"]);
			$this->setValueOf("model", $aDato["model"]);
		} else {
			throw new Exception("Registro no encontrado para modificacion");
		}
	} else {
		throw new Exception("Registro para modificacion no seleccionado correctamente");
	}
	return true;
	
    // Bouml preserved body end 0016DC85
  }

  /**
   * Funci�n invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return ORMObject el objeto ya guardado si todo sali� bien y un FALSE sino.
   */
  public function saveNew($context, $orm)
  {
    // Bouml preserved body begin 0016E005
	$conn = $orm->getDatabase()->getConnection();
	$prefix = $this->getValueOf("prefix");
	$model = $this->getValueOf("model");
	$city = $this->getValueOf("city");
	$dialplan = $this->getValueOf("dialplan");
		
	$sql = 'INSERT INTO CAP_DIALPLAN 
				(CIUDAD, DIALPLAN, PREFIJO, TELEFONO_ID)
			VALUES
				(:ci, :di, :pre, :te)'; 

	$ostmt = $conn->prepareStatement($sql);
	$bindeo = $conn->bind($ostmt, ":ci", $city);
	$bindeo = $conn->bind($ostmt, ":di", $dialplan);
	$bindeo = $conn->bind($ostmt, ":te", $model);
	$bindeo = $conn->bind($ostmt, ":pre", $prefix);
	$orst = $conn->execute($ostmt);
	if (!$orst)
		throw new Exception("No se pudo crear el registro: " . $conn->lastError());
	
	return true;
    // Bouml preserved body end 0016E005
  }

  /**
   * Funci�n invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return ORMObject el objeto ya guardado si todo sali� bien y un FALSE sino.
   */
  public function saveModify($context, $orm)
  {
    // Bouml preserved body begin 0016DD05
	$conn = $orm->getDatabase()->getConnection();
	$prefix = $this->getValueOf("prefix");
	$model = $this->getValueOf("model");
	$city = $this->getValueOf("city");
	$dialplan = $this->getValueOf("dialplan");
	
	if (($prefix != "") && ($model != ""))  {
		
		$sql = 'UPDATE CAP_DIALPLAN
				SET CIUDAD = :ci, DIALPLAN = :di
				WHERE PREFIJO = :pre AND TELEFONO_ID = :te'; 
		
		$ostmt = $conn->prepareStatement($sql);
		$bindeo = $conn->bind($ostmt, ":ci", $city);
		$bindeo = $conn->bind($ostmt, ":di", $dialplan);
		$bindeo = $conn->bind($ostmt, ":te", $model);
		$bindeo = $conn->bind($ostmt, ":pre", $prefix);
		$orst = $conn->execute($ostmt);
		if (!$orst)
			throw new Exception("No se pudo modificar el registro: " . $conn->lastError());
	} else {
		throw new Exception("No se encuentran los identificadores del registro");
	}
	return true;
    // Bouml preserved body end 0016DD05
  }

  /**
   * Funci�n invocada para borrar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function delete($context, $orm)
  {
    // Bouml preserved body begin 0016DD85
	$conn = $orm->getDatabase()->getConnection();
	$prefix = $this->getValueOf("prefix");
	$model = $this->getValueOf("model");
	if (($prefix != "") && ($model != ""))  {
		$sql = 'DELETE FROM CAP_DIALPLAN WHERE PREFIJO = :pre AND TELEFONO_ID = :te '; 
		$ostmt = $conn->prepareStatement($sql);
		$bindeo = $conn->bind($ostmt, ":te", $model);
		$bindeo = $conn->bind($ostmt, ":pre", $prefix);
		$orst = $conn->execute($ostmt);
		if (!$orst)
			throw new Exception("No se pudo eliminar el registro: " . $conn->lastError());
	} else {
		throw new Exception("No se encuentran los identificadores del registro");
	}
	return true;
    // Bouml preserved body end 0016DD85
  }

  /**
   * Solicita al formulario que realice la tarea para la que est� configurado.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo. Puede omitirse si anteriormente se llam� a Form::setContext()
   * @param ORM $orm el ORM para trabajar
   * @param ORM $orm el ORM a usar
   * 
   * @return Renderable la pantalla que debe mostrar.
   */
  public function deploy(&$context = null, &$orm = null)
  {
    // Bouml preserved body begin 0016DE85
	return parent::deploy($context, $orm);
    // Bouml preserved body end 0016DE85
  }

  /**
   * Funci�n invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return ORMObject el objeto ya guardado si todo sali� bien y un FALSE sino.
   */
  public function fresh($context, $orm)
  {
    // Bouml preserved body begin 0016E105
    // Bouml preserved body end 0016E105
  }

}
?>