<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/orm/ORMObject.php';



/**
* Author: Federico G. Bernoldi
* 
*/
class AsignarRouter extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 00198705
	parent::__construct($orm, $context);
	
	$this->setClass("Router")
			->setMethod("post")->setTitle("Asignar Router")
			->setFormType(Form::FORM_SAVE_BACK)
			->setId("id_form_asignar");
	
	
	$modelo = new SelectComponent();
	$modelo->setLabel("Modelo")
			    ->setMaps('hardware')
				->setOptions($orm->query('RouterEquipos')->attributes('id AS value', 'descripcion as description')->find());
	
	$serial = new TextComponent();
	$serial->setLabel("Serial Number")->setMaps("serialNumber")->setSize(20);
	
	$tracking = new TextComponent();
	$tracking->setLabel("Tracking Number")->setMaps("trackingNumber")->setSize(20);
	
	$oLayout1 = new GridLayout(7, 1);
	$oLayout1->addComponent(new LabelComponent("Suscripción", "id", "id"), 1, 1)
			 ->addComponent(new LabelComponent("IP", "ip", "ip"), 2, 1)
			 ->addComponent(new LabelComponent("Netmask", "mask", "mask"), 3, 1)
			 ->addComponent(new LabelComponent("Gateway", "gateway", "gateway"), 4, 1)
			 ->addComponent($serial, 5, 1)
			 ->addComponent($tracking, 6, 1)
			 ->addComponent($modelo, 7, 1);
	
	$this->addComponent($oLayout1);
	
	$this->setAction($context->getCurrentAction()->getStringCommand());
	return $this;
    // Bouml preserved body end 00198705
  }

  /**
   * Funci�n invocada para modificar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function modify($context, $orm)
  {
    // Bouml preserved body begin 00198785
	return parent::modify($context, $orm);
    // Bouml preserved body end 00198785
  }

  /**
   * Funci�n invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return ORMObject el objeto ya guardado si todo sali� bien y un FALSE sino.
   */
  public function save($context, $orm)
  {
    // Bouml preserved body begin 00198805
	//Aca va lo piola
	require_once 'iplan/models/provisioning/ProvisioningPlataformas.php';
	
	$id = $this->getValueOf('id');
	
	$valido = $this->validate();
	if ($id === null) {
		// NO HAGO ALTASSSSSSSSSSSSS
		return false;
	} else {
		//Caso modificar
		$oRouter = $orm->load($this->getClass(), $id);

		//Cargo los datos que voy a modificar en el router
		$serialNumber = $this->getValueOf('serialNumber');
		$trackingNumber = $this->getValueOf('trackingNumber');
		$hardware = $this->getValueOf('hardware');
		
		$oRouterEquipo = $orm->load("RouterEquipos", $hardware);
	
		$oRouter->setSerialNumber($serialNumber);
		$oRouter->setTrackingNumber($trackingNumber);
		$oRouter->setHardware($oRouterEquipo);
		
		$this->setValueOf("ip", $oRouter->getIp());
		$this->setValueOf("mask", $oRouter->getMask());
		$this->setValueOf("gateway", $oRouter->getGateway());
		
	}
	if ($valido === true) {
		
		if (($oRouter->getTrackingNumber() != "") && ($oRouter->getSerialNumber()  != "")) {
			
			$aRespuesta = ProvisioningPlataformas::getDatosRouter($oRouter->getTrackingNumber());
			
			
			if ($aRespuesta["codigo"] === 0) {
				
				if ($oRouterEquipo->getFilename()) {
			
					$oServiceOrderTask = $orm->query("ServiceOrder")
											->attributes("cgp", "sellOrder")
											->filterBy("subscriptionId", "=", $id)
											->findOne();

					if ($oServiceOrderTask) {

						$cgp = $oServiceOrderTask["cgp"];
						$tenfoldId = ProvisioningPlataformas::des_cgpear($cgp);
						$ordenDeVenta = $oServiceOrderTask["sellOrder"];
						$ssid_default = "IPLAN-".substr($cgp,-4);
						$pass_default = $cgp;

						$params_template = array();

						$params_template['#!USUARIO!#'] = $oRouter->getUserRouter();
						$params_template['#!PASSWORD!#'] = $oRouter->getPassRouter();
						$params_template['#!IP!#'] = $oRouter->getIp();
						$params_template['#!TR069CONREQURL!#'] = $oRouter->getIp();
						$params_template['#!PORT!#'] = $oRouter->getPort();
						$params_template['#!MASK!#'] = $oRouter->getMask();
						$params_template['#!GATEWAY!#'] = $oRouter->getGateway();
						$params_template['#!SSID1!#'] = (strlen($oRouter->getSsid1())>0)?$oRouter->getSsid1():$ssid_default;
						$params_template['#!PASS1!#'] = (strlen($oRouter->getSsid1())>0)?$oRouter->getPass_wifi1():$pass_default;
						$params_template['#!SSID2!#'] = (strlen($oRouter->getSsid2())>0)?$oRouter->getSsid2():$ssid_default.'-2';
						$params_template['#!PASS2!#'] = (strlen($oRouter->getSsid2())>0)?$oRouter->getPass_wifi2():$pass_default;
						$params_template['#!SSID3!#'] = (strlen($oRouter->getSsid3())>0)?$oRouter->getSsid3():$ssid_default.'-3';
						$params_template['#!PASS3!#'] = (strlen($oRouter->getSsid3())>0)?$oRouter->getPass_wifi3():$pass_default;
						$params_template['#!SSID4!#'] = (strlen($oRouter->getSsid4())>0)?$oRouter->getSsid4():$ssid_default.'-4';
						$params_template['#!PASS4!#'] = (strlen($oRouter->getSsid4())>0)?$oRouter->getPass_wifi4():$pass_default;

						if ($oRouterEquipo) {
							$cTemplate = file_get_contents(str_replace("//", "/", ProvisioningPlataformas::ROUTER_TEMPLATE_ORIGEN_PATH . '/' . $oRouterEquipo->getFilename()));
							if ($cTemplate !== false) {
								$cTemplateModificado = str_replace(array_keys($params_template), array_values($params_template), $cTemplate);
								$cFilename = ProvisioningPlataformas::ROUTER_TEMPLATE_DESTINO_PATH . $oRouter->getSerialNumber() . '_' . $oRouterEquipo->getFilename();
								$res = file_put_contents($cFilename, $cTemplateModificado);
								if ($res === false) {
									$aErrores = array(	"title" => "Equipo",
														"messages" => array(array("descriptions" => "No se pudo crear Template")));
									$context->set("errors", $aErrores);
									return false;
								} else {
									$oRouter->setFilename(basename($cFilename));
								}
							} else {
								$aErrores = array(	"title" => "Equipo",
													"messages" => array(array("descriptions" => "No existe template generico")));
								$context->set("errors", $aErrores);
								return false;
							}
						} else {
							$aErrores = array(	"title" => "Equipo",
												"messages" => array(array("descriptions" => "No tiene un equipo asignado en el router")));
							$context->set("errors", $aErrores);
							return false;
						}
					} else {
						$aErrores = array(	"title" => "Error al consultar Tarea",
										"messages" => array(array("descriptions" => "No se encontro una tarea asociada a la subscripción")));
						$context->set("errors", $aErrores);
						return false;
					}
					
				}
				
			} else {
				$aErrores = array(	"title" => "Error al verificar Tracking Number",
									"messages" => array(array("descriptions" => $aRespuesta["Detalles"])));
				$context->set("errors", $aErrores);
				return false;
			}
		
		} else {
			
			$aErrores = array(	"title" => "Datos Incompletos",
								"messages" => array(array("descriptions" => array("Debe completar Serial Number y Tracking Number"))));
			$context->set("errors", $aErrores);
			
			return false;
		}
	} else {
		return $valido;
	}
	
	$orm->save($oRouter);
	
	/*El número de tracking <032178> ingresado, corresponde al hardware Asga-DataCom MA-IP-Minimux con el número serial <000037>
	El template de configuracion <1015374XXXF-A9000554asdd_ct5374_20110921_wifi02.conf> se ha generado correctamente */
	
	$aMsgs = array();
	$aMsgs[] = "El número de tracking <".$oRouter->getTrackingNumber()."> ingresado, corresponde al hardware ".$aRespuesta["Producto"]." con el número serial <".$aRespuesta["SerialNumber"].">";
	
	if ($oRouterEquipo->getFilename()) {
		$aMsgs = "El template de configuracion <" . $oRouter->getSerialNumber() . '_' . $oRouterEquipo->getFilename() . "> se ha generado correctamente";
	} else {
		$aMsgs[] = "El modelo " . $oRouterEquipo->getDescripcion() . " no genera template.";
	}
	
	$aErrores = array(	"title" => "Template generado",
							"messages" => array(array("descriptions" => $aMsgs)));
	
	$context->set("errors", $aErrores);

	return false;
	
    // Bouml preserved body end 00198805
  }

  /**
   * Funci�n invocada para borrar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function delete($context, $orm)
  {
    // Bouml preserved body begin 00198885
	return parent::delete($context, $orm);
    // Bouml preserved body end 00198885
  }

  /**
   * Esta función se encarga de validar si un usuario tiene acceso a trabajar con una cierta entidad. La intención es verificar en este paso que el usuario tiene permiso para crear, editar o borrar la entidad que solicitó.
   * 
   * @param ApplicationContext $context el contexto en el cual se mandó a ejecutar la acción. De aquí se puede obtener la información de User, Domain y Provider.
   * @param ORM $orm la instancia del ORM
   * @param string $action un texto que indica lo que se pretende hacer. Puede tomar valores de: 'NEW', 'MODIFY', 'SAVE' o 'DELETE'.
   * @param mixed $id el identificador de la entidad que se pasó por parámetro
   * 
   * @return boolean La función debe devolver True si el usuario puede realizar la acción o arrojar una excepción con la descripción del problema.
   */
  public function checkAccess(&$context, &$orm, $action, $id = null)
  {
    // Bouml preserved body begin 001CA905
	return parent::checkAccess($context, $orm, $action, $id);
    // Bouml preserved body end 001CA905
  }

}
?>