<?php
require_once 'iplan/web/ABMForm.php';
require_once 'iplan/orm/ORM.php';
require_once 'iplan/security/ApplicationContext.php';
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/database/OracleConnection.php';
require_once 'iplan/web/Form.php';
require_once 'iplan/models/provisioning/TelephoneLine.php';



/**
* Author: Federico G. Bernoldi
* 
*/
class AsignarHardware extends ABMForm {
  /**
   * Crea un formulario de ABM
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * @return ABMForm la pantalla que debe mostrar.
   */
  public function __construct(&$orm, &$context)
  {
    // Bouml preserved body begin 0015FF85
	parent::__construct($orm, $context);
	
	$this->setClass("TelephoneLine")
			->setMethod("post")->setTitle("Asignar Hardware")
			->setFormType(Form::FORM_OK_CANCEL)
			->setId("id_form_asignar");
	
	$modelo = new SelectComponent();
	$modelo->setLabel("Modelo")
			    ->setMaps('model')
				->setOptions($orm->query('TelephoneModel')->attributes('id AS value', 'model as description')->find())
				->addEvent(Component::EVENT_CHANGE, "getListadoPuertos", $orm);
	$mac = new TextComponent("MAC-ADDRESS", "mac", "mac");
	$mac->setSize(17)->setMaxlength(17)
		->addEvent(Component::EVENT_KEYPRESS, "getMacModel", $orm, "test_mac");
	
	$radio = new RadioComponent();
	
	$radio->setLabel("Puerto")
			->setMaps("port")
			->setName("port");
	
	//$file = new FileComponent("Archivo", "templatexd", "templatexd");
	
	
	/*$aPuertos = array(array("value" => "1", "description" => "Puerto 1"),
						array("value" => "2", "description" => "Puerto 2", "disabled" => true),
						array("value" => "3", "description" => "Puerto 3"),
						array("value" => "4", "description" => "Puerto 4", "disabled" => false)
						);*/
	
	$radio->setOptions(array());
	
	$oLayout1 = new GridLayout(5, 1);
	$oLayout1->addComponent(new LabelComponent("Linea", "id", "id"), 1, 1)
			 ->addComponent(new LabelComponent("Interno", "internal", "internal"), 2, 1)
			 ->addComponent($mac, 3, 1)
			 ->addComponent($modelo, 4, 1)
			 ->addComponent($radio, 5, 1)/*
			->addComponent($file, 6, 1)*/;
	
	
	$this->addComponent($oLayout1);
	
	//$this->addEventListener('ModelChange', "getListadoPuertos");
	
	$this->setAction($context->getCurrentAction()->getStringCommand());
	return $this;
    // Bouml preserved body end 0015FF85
  }

  /**
   * Funci�n invocada para modificar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function modify($context, $orm)
  {
    // Bouml preserved body begin 00160005
	if (parent::modify($context, $orm)) {
		//cargar el port
		$idLinea = $this->getValueOf('id');
		$mac = $this->getValueOf('mac');
		
		$oLine = $orm->retrieve("TelephoneLine", $idLinea);
		if (!$oLine) $oLine = $orm->load("TelephoneLine", $idLinea);

		$portSeleccionado = (int)$oLine->getPort();

		$aPuertosSiteMac = $orm->query("TelephoneLine")
										->attributes("port")
										->filterBy("mac", "=", $oLine->getMac())
										->filterBy("site.id", "=", $oLine->getSite()->getId())
										->filterBy("id", "!=", $idLinea)
										->find();
		
		$aPuertos = array();
		for ($i = 0; $i < count($aPuertosSiteMac); $i++) {
			$aPuertos[] = $aPuertosSiteMac[$i]["port"];
		}

		$sels = array();
		$oTelephoneModel = $oLine->getModel();
		if ($oTelephoneModel) {
			$nLineas = $oTelephoneModel->getNumberLines();
			for ($i = 1; $i <= $nLineas; $i++) {
				$disabled = array_search($i, $aPuertos, true) === false ? false : true;
				$disabled = ($i === $portSeleccionado) ? false : $disabled;
				$aItem = array("value" => $i, "description" => "Puerto $i", "disabled" => $disabled);
				$sels[] = $aItem;
			}
		}
		$this->getComponent("port")->setOptions($sels);
		$this->getComponent("port")->setSelected($portSeleccionado);
	}
	return false;
    // Bouml preserved body end 00160005
  }

  /**
   * Funci�n invocada para guardar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return ORMObject el objeto ya guardado si todo sali� bien y un FALSE sino.
   */
  public function save($context, $orm)
  {
    // Bouml preserved body begin 00160085
	require_once 'iplan/models/provisioning/ProvisioningPlataformas.php';
	
	$conn = $orm->getDatabase()->getConnection();
	$id = $this->getValueOf('id');

	$valido = $this->validate();
	
	if ($id === null) {
			// No hago altas
		return false;
	}
	
	if ($valido === true) {

		//Caso modificar
		$oLine = $orm->load("TelephoneLine", $id);
		
		$mac = $this->getValueOf('mac');
		$mac_address = strtolower(str_replace(":","",str_replace("-","",str_replace(".","",$mac))));
		
		$aValoresViejos = $orm->query("TelephoneLine")
							  ->attributes("mac", "model", "port")
							  ->filterBy("id", "=", $id)
							  ->findOne();
		
		$mod_hw_id = $this->getValueOf('model');
		
		$oLineaCompleta = $orm->load("Line", $id);
		
		$oServiceOrder = $orm->query("ServiceOrder")
							 ->filterBy("code", "=", "MC") //Alta CVI
							 ->filterBy("state", "=", 7) // Completa
							 ->filterBy("subscriptionId", "=", $oLineaCompleta->getSubscription()) // De la suscripcion de la linea
							 ->findOne();
		
		if ($oServiceOrder) {
			//Tiene Permisos sobre la linea, sigo
			
			//Busco si otro cliente tiene la misma mac
			$validacion = $orm->query("TelephoneLine")
							->filterBy("site.clientId", "!=", $oLineaCompleta->getSite()->getClient()->getId())
							->filterBy("mac", "=", $mac_address)
							->find();
			if ($validacion !== false) {
				$aErrores = array(	"title" => "No se pudo concretar la operación",
									"messages" => array(array("descriptions" => array("La MAC-ADDRESS ya se encuentra utilizada por otro cliente"))));
				$context->set("errors", $aErrores);
				return false;
			}

			//Busco si la mac tiene otro modelo de telefono asignado
			$aTelephoneLines = $orm->query("TelephoneLine")
							->filterBy("mac", "=", $mac_address)->filterBy("id", "!=", $id)
							->find();

			$validacion2 = true;
			if ($aTelephoneLines !== false)
				if (count($aTelephoneLines) > 0)
					foreach($aTelephoneLines as $telephoneLine)
						if ($telephoneLine->getModel()->getId() != $mod_hw_id)
							$validacion2 = false;

			if (!$validacion2) {
				$aErrores = array(	"title" => "No se pudo concretar la operación",
									"messages" => array(array("descriptions" => array("La MAC-ADDRESS ya esta asociada a otra línea con otro modelo"))));
				$context->set("errors", $aErrores);
				return false;
			}
			
			//Viejo Template
			$generacionTemplateAntiguo = false;
			if (($aValoresViejos["mac"]) && ($mac_address != $aValoresViejos["mac"])) {
				try {
					$generacionTemplateAntiguo = self::generateHardwareTemplate($orm, $aValoresViejos["mac"], $aValoresViejos["model"], $id);
				} catch (Exception $e) {
					$aErrores = array(	"title" => "Template Equipo Anterior",
										"messages" => array(array("descriptions" => $e->getMessage()),
															array("descriptions" => "No se puede desasignar una mac si no podemos generar un template para el hardware anterior"))
									);
					$context->set("errors", $aErrores);
				}
			} else {
				$generacionTemplateAntiguo = true;
			}
			
			if (!$generacionTemplateAntiguo) {
				return false;
			}

			$this->setValuesToObject($oLine);
			$oLine->setMac($mac_address);
			$oLine->setState(0);
			$oLine->setDate(null);
			$orm->save($oLine);
			
			//Nuevo Template
			$generacionTemplate = false;
			try {
				$generacionTemplate = self::generateHardwareTemplate($orm, $mac_address);
			} catch (Exception $e) {
				$aErrores = array(	"title" => "Template Equipo",
									"messages" => array(array("descriptions" => $e->getMessage())));
				$context->set("errors", $aErrores);
			}
			
			//Si tenemos los dos templates lo damos por completo
			if (($generacionTemplate === true) && ($generacionTemplateAntiguo === true)) {
				return $oLine;
			} else {
				return false;
			}
		} else {
			//No tiene permisos en la linea.
			
			$aErrores = array(	"title" => "Error de permisos",
								"messages" => array(array("descriptions" => array("Solo se pueden trabajar lineas que esten completadas por autoprovisioning"))));
			$context->set("errors", $aErrores);
			return false;
		}
	} else {
		//Seteo error de contexto de validacion xd.-		
		return $valido;
	}
	
    // Bouml preserved body end 00160085
  }

  /**
   * Bestmatch de DialPlan
   * 
   * @param OracleConnection $conn La conexi�n de base de datos que utiliza
   * @param int $mod_hw_id el ID de TelephoneModel correspondiente para tomar el dialplan
   * @param string $line el ID de TelephoneLine en la cual se quiere tomar el Bestmatch
   * @param int $digitsMatch la cantidad m�xima de d�gitos para tomar el dialplan
   * 
   * @return string El Dialplan
   */
  private static function bestMatchDialPlan(&$conn, $mod_hw_id, $line, $digitsMatch = 6)
  {
    // Bouml preserved body begin 00162485
	$dialplan = "";
	$matched = false;
	while (($digitsMatch > 0) && (!$matched)) {
		$sql = 'SELECT DIALPLAN "dialplan"
				FROM CAP_DIALPLAN
				WHERE TELEFONO_ID = :t_id
				  AND PREFIJO = :p_id'; //
		$ostmt_dp = $conn->prepareStatement($sql);
		$bindeo = $conn->bind($ostmt_dp, ":t_id", $mod_hw_id);
		$bindeo = $conn->bind($ostmt_dp, ":p_id", substr($line, 0, $digitsMatch));
		$orst = $conn->execute($ostmt_dp);
		$dialplanes = $conn->fetch($ostmt_dp);
		$conn->free($ostmt_dp);
		if (is_array($dialplanes) && (count($dialplanes) > 0) && (isset($dialplanes["dialplan"]))) {
			$dialplan = $dialplanes["dialplan"];
			$matched = true;
		}
		$digitsMatch--;
	}
	return $dialplan;
    // Bouml preserved body end 00162485
  }

  /**
   * Funci�n invocada para borrar el objeto que representa el formulario.
   * 
   * @param ApplicationContext $context el contexto en el cual el Form debe hacer su trabajo.
   * @param ORM $orm el ORM a usar
   * 
   * @return boolean un TRUE si todo sali� bien y un FALSE sino.
   */
  public function delete($context, $orm)
  {
    // Bouml preserved body begin 00164185
	$aErrores = array(	"title" => "No se pudo concretar la operación",
						"messages" => array(array("descriptions" => array("No se puede eliminar"))));
	$context->set("errors", $aErrores);
	return false;
    // Bouml preserved body end 00164185
  }

  /**
   * Devuelve el Listado de Puertos para cuando se cambia de TelephoneModel.
   * 
   * @param ApplicationContext $context
   * @param Form $form
   * @param ORM $orm
   * 
   */
  public function getListadoPuertos($context, $form, $orm)
  {
    // Bouml preserved body begin 00198505
	$id = $this->getValueOf('id');
	$model = (int)$this->getValueOf('model');

	$oTelephoneLine = $orm->load("TelephoneLine", $id);

	$sels = array();
	if ($model > 0) {
		$oTelephoneModel = $orm->load("TelephoneModel", $model);
		if ($oTelephoneModel) { //Si esta cargado el modelo
			$nLineas = $oTelephoneModel->getNumberLines();
			for ($i = 1; $i <= $nLineas; $i++) {
				$aItem = array("value" => $i, "description" => "Puerto $i");
				$sels[] = $aItem;
			}
		}
	}
	$this->getComponent("port")->setOptions($sels)->setSelected($oTelephoneLine->getPort());
	$this->updated("port");
    // Bouml preserved body end 00198505
  }

  /**
   * Selecciona el Modelo y los puertos ubicados para macs existentes, si no existe la mac devulve los puertos del modelo seleccionado
   * 
   * @param ApplicationContext $context
   * @param Form $form 
   * @param ORM $orm 
   */
  public function getMacModel($context, $form, $orm)
  {
    // Bouml preserved body begin 00198585
	$id = (int)$this->getValueOf('id');
	$mac = $this->getValueOf('mac');

	$mac_address = strtolower(str_replace(":","",str_replace("-","",str_replace(".","",$mac))));
	$oTelephoneLine = $orm->load("TelephoneLine", $id);
	$macLineModel = $orm->query("TelephoneLine")->filterBy("mac", "=", $mac_address)->findOne();
	$aLineModel["modelid"] = $macLineModel->getModel()->getId();

	$aPuertos = array();
	$sels = array();

	$cModel = $this->getComponent("model");

	if ($macLineModel) { //Mac Existente
		//Seteo la mac en el combo
		$cModel->setSelected($aLineModel["modelid"]);
		$aPuertosSiteMac = $orm->query("TelephoneLine")
							->attributes("port")
							->filterBy("mac", "=", $mac_address)
							->find();
		for ($i = 0; $i < count($aPuertosSiteMac); $i++) {
			$aPuertos[] = $aPuertosSiteMac[$i]["port"];
		}
		
		$oTelephoneModel = $orm->load("TelephoneModel", $aLineModel["modelid"]);
		if ($oTelephoneModel) { //Si esta cargado el modelo
			$nLineas = $oTelephoneModel->getNumberLines();
			for ($i = 1; $i <= $nLineas; $i++) {
				$disabled = array_search($i, $aPuertos, true) === false ? false : true;
				$aItem = array("value" => $i, "description" => "Puerto $i", "disabled" => $disabled);
				$sels[] = $aItem;
			}
		}
	} else {
		//Selecciono nada y limpio puertos (dejo vacio el array)
		$cModel->setSelected();
		$cModel->setDisabled(false);
	}
	$this->getComponent("port")->setOptions($sels)->setSelected($oTelephoneLine->getPort());
	$this->updated("model", "port");
    // Bouml preserved body end 00198585
  }

  /**
   * Carga el Puerto
   * 
   * @param ORM $orm el ORM
   * @param TelephoneLine $oTelephoneLine la linea que se cargan los puertos
   * @param int $mod_hw_id el ID de Modelo
   */
  public function loadPort($orm, $oTelephoneLine, $mod_hw_id)
  {
    // Bouml preserved body begin 00198605
	$sels = array();
	if ($mod_hw_id > 0) {
		$oTelephoneModel = $orm->load("TelephoneModel", $mod_hw_id);
		if ($oTelephoneModel) { //Si esta cargado el modelo
			$nLineas = $oTelephoneModel->getNumberLines();
			for ($i = 1; $i <= $nLineas; $i++) {
				$aItem = array("value" => $i, "description" => "Puerto $i");
				$sels[] = $aItem;
			}
		}
	}
	$this->getComponent("port")->setOptions($sels)->setSelected($oTelephoneLine->getPort());
	$this->updated("port");
    // Bouml preserved body end 00198605
  }

  /**
   * Genera un template para el mac indicado
   * 
   * @param ORM $orm
   * @param string $mac la MAC Address del equipo para el que se quiere generar el template
   * @param int $modelId el ID del modelo del hardware del teléfono (solo bajas)
   * @param int $ignore_line una línea para ignorar cuando se genera el template.
   * 
   * @return boolean Un TRUE si todo anduvo bien y el string de error
   */
  public static function generateHardwareTemplate($orm, $mac, $modelId = null, $ignore_line = null)
  {
    // Bouml preserved body begin 00198685
	$conn = $orm->getDatabase()->getConnection();
	
	$query = $orm->query("TelephoneLine")
				 ->filterBy("mac", "=", $mac)
				 ->orderBy("port ASC");
	
	if ($ignore_line) $query->filterBy("id", "!=", $ignore_line);
	
	$oLinesConfigurar = $query->find();

	//Preparo los parametros de template para el modelo con todo disabled:
	if (($oLinesConfigurar) && (count($oLinesConfigurar) > 0)) {

		$oLineModel = $orm->query("TelephoneLine")
							->filterBy("mac", "=", $mac)
							->findOne();
		$tel = $oLineModel->getModel();
	} else {
		if (!$modelId) {
			throw new Exception("No se encuentran líneas para configurar o desconfigurar asociadas a la mac");
		}
		$tel = $orm->retrieve("TelephoneModel", $modelId);
		if (!$tel) $tel = $orm->load("TelephoneModel", $modelId);
	}

	for ($r = 1; $r <= $tel->getNumberLines(); $r++) {
		$params_template["#!ENABLE_SIP_$r!#"] =  $tel->getDisableValue();
		$params_template["#!USUARIO_SIP_$r!#"] =  "";
		$params_template["#!PASSWORD_SIP_$r!#"] =  "";
		$params_template["#!DIALPLAN_SIP_$r!#"] =  "";
	}

	$error_sac = false;

	if (($oLinesConfigurar) && (count($oLinesConfigurar) > 0)) {

		foreach ($oLinesConfigurar as $key => $oLine) {
			//$r++;

			//Busco datos de la linea
			$sql = 'SELECT	L.LINEA "linea", 
							L.MAC_ADDRESS "mac_address", 
							S.CGP "cgp", 
							S.SISTEMA_ID "sistema_id", 
							S.ORDENDEVENTA "ordendeventa",
							L.MOD_HW_ID "hwId",
							L.NRO_INTERNO "nro_interno",
							SI.CLIENTE_ID "cliente_id"
				FROM LINEAS L, CAP_SERVICEORDERTASKS S, SITIO SI
				WHERE L.SUBSCRIPTION = S.SUBSCRIPTIONID
				  AND L.SITIO_ID = SI.SITIO_ID
				  AND S.TASKCODE = \'MC\'
				  AND L.ESTADO = 1
				  AND S.ESTADO_ID = 7
				  AND LINEA = :linea_id ';

			$ostmt = $conn->prepareStatement($sql);
			$bindeo = $conn->bind($ostmt, ":linea_id", $oLine->getId());

			$orst = $conn->execute($ostmt);
			$aLineData = $conn->fetch($ostmt);
			$conn->free($ostmt);

			$tenfold = ltrim(substr($aLineData["cgp"], 0, -1), "0");

			$aResultado = ProvisioningPlataformas::getPasswordSac($aLineData["linea"], $aLineData["sistema_id"], $tenfold);

			if (!isset($aResultado["codigo"]) || ($aResultado["codigo"] != 0)) {
				$error_sac = $aResultado;
				$aResultado["value"] = "";
			}

			$puerto = $oLine->getPort();

			//VER QUE PASA SIN PASSWORD
			$params_template['#!USUARIO_SIP_' . $puerto . '!#'] = $aLineData["linea"];
			$params_template['#!PASSWORD_SIP_' . $puerto . '!#'] = $aResultado["value"];
			$params_template['#!ENABLE_SIP_' . $puerto . '!#'] = $tel->getEnableValue();
			$params_template['#!DIALPLAN_SIP_' . $puerto . '!#'] = self::bestMatchDialPlan($conn, $tel->getId(), $aLineData["linea"]);

		}
	}

	/* Preparo el template */
	if ($error_sac === false) {
		$cTemplate = file_get_contents($tel->getTemplate());
		$filename = $mac . $tel->getExtension();
		$fullpath = ProvisioningPlataformas::TELEPHONE_GENERICO_PATH . $filename;
		if ($cTemplate !== false) {
			$cTemplateModificado = str_replace(array_keys($params_template), array_values($params_template), $cTemplate);
			$res = file_put_contents($fullpath, $cTemplateModificado);
			if ($res === false) {
				throw new Exception("No se pudo crear Template");
			}
		} else {
			throw new Exception("No existe template generico");
		}
		if (($oLinesConfigurar) && (count($oLinesConfigurar) > 0)) {
			foreach ($oLinesConfigurar as $key => $oLine) {
				$oLine->setFile($filename);
				$orm->save($oLine);
			}
		}		
		return true;
	} else {
		throw new Exception(implode (",", $error_sac["Detalles"]));
	}
    // Bouml preserved body end 00198685
  }

  /**
   * Esta función se encarga de validar si un usuario tiene acceso a trabajar con una cierta entidad. La intención es verificar en este paso que el usuario tiene permiso para crear, editar o borrar la entidad que solicitó.
   * 
   * @param ApplicationContext $context el contexto en el cual se mandó a ejecutar la acción. De aquí se puede obtener la información de User, Domain y Provider.
   * @param ORM $orm la instancia del ORM
   * @param string $action un texto que indica lo que se pretende hacer. Puede tomar valores de: 'NEW', 'MODIFY', 'SAVE' o 'DELETE'.
   * @param mixed $id el identificador de la entidad que se pasó por parámetro
   * 
   * @return boolean La función debe devolver True si el usuario puede realizar la acción o arrojar una excepción con la descripción del problema.
   */
  public function checkAccess(&$context, &$orm, $action, $id = null)
  {
    // Bouml preserved body begin 001C8E05
	  
	switch($action) {
		case 'NEW':
			throw new Exception("No se pueden crear objetos de este tipo.");
			break;
		case 'MODIFY':
		case 'SAVE':
			$conn = $orm->getDatabase()->getConnection();
			$userid = $context->getUser()->getId();
			$perf = $orm->query("Profile")
							->filterBy("name", "=", "Cliente - Provisioning telefonia")
							->filterBy("provider.id", "=", $context->getProvider()->getId())
							->filterBy("users.id", "=", $userid)
							->findOne();

			if ($perf) {
				//Tengo el perfil limitado entonces filtro xD:
				$oTelephoneLine = $orm->query("Line")
										->filterBy("site.client.user.id", "=", $userid)
										->findOne();
				if (!$oTelephoneLine) {
					$desc = ($action == "MODIFY") ? "modificar" : "eliminar";
					throw new Exception("No tiene acceso a $desc esta línea");
				}
			}
			
			break;
		case 'DELETE':
			throw new Exception("No se pueden eliminar objetos de este tipo.");
			break;
		default:
			break;
	}
	return parent::checkAccess($context, $orm, $action, $id);
    // Bouml preserved body end 001C8E05
  }

}
?>