<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/provisioning/XMLType.php';
require_once 'iplan/models/provisioning/ServiceOrder.php';
require_once 'iplan/models/provisioning/SellOrderXML.php';
require_once 'iplan/models/provisioning/Process.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Federico G. Bernoldi
* 
*/
/**
 * CAP_MENSAJEXML
 */
class XMLMessage extends ORMObject {
  /**
   * @var string la respuesta en XML obtenida
   */
  protected $xml;

  /**
   * @var DateTime la fecha y hora de recibido el XML
   */
  protected $date;

  /**
   * @var XMLType el tipo de XML?
   */
  protected $xmlType;

  /**
   * @var ServiceOrder la orden de servicio a la que pertenece el mensaje
   */
  protected $serviceOrder;

  /**
   * @var SellOrderXML la orden de venta bla
   */
  protected $sellOrderXML;

  /**
   * @var Process el proceso al cual pertenece el mensaje
   */
  protected $process;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 0014BC05
	return parent::define($orm)
					->setTable('CAP_MENSAJEXML')
					->addField('id', 'XML_ID', ORMDefinition::INTEGER, 8, 0)
					->setKey('id')
					->addField('xml', 'XML', ORMDefinition::TEXT)
					->addField('date', 'FECHA', ORMDefinition::DATETIME)
					->addInstance('xmlType', 'T_XML_ID', 'XMLType')
					->addInstance('sellOrderXML', 'XML_ID', 'SellOrderXML')
					->addRelationNxM('process', "CAP_PROCESOXML", "XML_ID", "Process", "PROCESO_ID")
					->addRelationNxM('serviceOrder', "CAP_SERVICEORDERTASKXML", "XML_ID", "ServiceOrder", "SERVICEORDERTASKID");
    // Bouml preserved body end 0014BC05
  }

}
?>