<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/security/User.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Federico G. Bernoldi
* 
*/
class UserSellOrder extends ORMObject {
  /**
   * @var User el usuario al que est� asignada la orden de venta
   */
  protected $user;

  /**
   * @var int El n�mero de orden de venta
   */
  protected $sellOrder;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00162405
	return parent::define($orm)
					->setClass('UserSellOrder')
					->setTable('CAP_USER_ORDENDEVENTA')
					->addField('id', 'ID', ORMDefinition::INTEGER, null, null, false)
					->setKey('id')
					->addField('sellOrder', 'ORDENDEVENTA', ORMDefinition::INTEGER, null, null, false)
					->addInstance("user", 'USER_ID', 'User');
    // Bouml preserved body end 00162405
  }

}
?>