<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Federico G. Bernoldi
* 
*/
class TelephoneSite extends ORMObject {
  /**
   * @var ORMCollection Las lineas que tiene el sitio
   */
  protected $lines;

  /**
   * @var int El numero de cliente
   */
  protected $clientId;

  /**
   * Retorna un objeto de definicin predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definicin
   * @return ORMDefinition la definicin default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00162385
	return parent::define($orm)
					->setClass('TelephoneSite')
					->setTable('SITIO')
					->addField('id', 'SITIO_ID', ORMDefinition::INTEGER, 8, 0, false)
					->setKey('id')
					->addField('clientId', 'CLIENTE_ID', ORMDefinition::INTEGER, 8, 0, false)
					->addRelation1xN('lines', 'LINEA_ID', 'TelephoneLine');
    // Bouml preserved body end 00162385
  }

  /**
   * Verifica si el objeto fue modificado y lo guarda.
   * Este mtodo permite abstraer a las clases descendientes de la necesidad de determinar si el objeto fue alterado o no y oculta la complejidad subyacente a las clases descendientes.
   * @param ORM $orm opcionalmente se debe indicar la instancia del ORM que mantiene el objeto. Esto slo es posible si el objeto es nuevo o DETACHED. En el caso que ya estuviera bajo monitoreo de un ORM arrojar una excepcin.
   * 
   * Se pens en que se podra hacer el cambio de un ORM a otro, pero el ID debera limpiarse, con lo cual slo un INSERT se podra hacer sobre el destino y los objetos relacionados estaran an con otro ORM lo cual es complicado (manejo de objetos distribudos) por lo cual se deja a consideracin de futuras versiones, posiblemente en otra vida =)
   */
  public function save(&$orm = null)
  {
    // Bouml preserved body begin 0016D585
	if (($this->getORMState() == ORM_STATUS::FRESH)) {
		return new Exception("No se puede crear un elemento nuevo de esta clase");
	}
	return parent::save($orm);
    // Bouml preserved body end 0016D585
  }

  /**
   * Borra fsicamente un objeto de la base. Al borrarse el objeto adems se ponen a null los campos de las entidades relacionadas que lo referenciaban y se eliminan los registros de las tablas relacin M:N
   * 
   * @return boolean un booleando TRUE si la operacin fue concretada con xito o FALSE sino.
   */
  public function delete()
  {
    // Bouml preserved body begin 0016D605
	return new Exception("No se puede eliminar un elemento nuevo de esta clase");
    // Bouml preserved body end 0016D605
  }

}
?>