<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/provisioning/TelephoneLine.php';
require_once 'iplan/models/provisioning/DialPlan.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Federico G. Bernoldi
* 
*/
class TelephoneModel extends ORMObject {
  /**
   * @const string Constante de estado que significa que el tel�fono est� activo.
   */
  const TELEPHONE_ACTIVE = '1';

  /**
   * @const string Constante de estado que significa que el tel�fono est� inactivo.
   */
  const TELEPHONE_INACTIVE = '0';

  /**
   * @var string el modelo del tel�fono
   */
  protected $model;

  /**
   * @var int la cantidad de l�neas que se configuraron con este modelo de tel�fono
   */
  protected $numberLines;

  /**
   * @var string una path al template de configuraci�n
   */
  protected $template;

  /**
   * @var string TODO: completar
   */
  protected $extension;

  /**
   * @var string el valor usado para habilitar el tel�fono?
   */
  protected $enableValue;

  /**
   * @var string el valor usado para deshabilitar el tel�fono?
   */
  protected $disableValue;

  /**
   * @var string TODO: completar
   */
  protected $generic;

  /**
   * @var int un c�digo de estado
   */
  protected $state;

  /**
   * @var ORMCollection todas las l�neas que corresponden con el modelo de tel�fono
   */
  protected $lines;

  /**
   * @var ORMCollection la lista de DialPlan's del modelo de tel�fono
   */
  private $dialPlans;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00160205
	return parent::define($orm)
                ->setClass('TelephoneModel')
				->setTable('CAP_TELEFONO')
				->addField('id', 'TELEFONO_ID', ORMDefinition::INTEGER, 8, 0, false)
				->setKey('id')
				->addField('model', 'MODELO', ORMDefinition::STRING, 255, null, true)
				->addField('numberLines', 'CANT_LINEAS', ORMDefinition::INTEGER, 2, 0, true)
				->addField('template', 'TEMPLATE', ORMDefinition::STRING, 4000, null, true)
				->addField('extension', 'EXTENSION', ORMDefinition::STRING, 10, null, true)
				->addField('enableValue', 'ENABLE_VALUE', ORMDefinition::STRING, 10, null, true)
				->addField('disableValue', 'DISABLE_VALUE', ORMDefinition::STRING, 10, null, true)
				->addField('generic', 'GENERICO', ORMDefinition::STRING, 255, null, true)
				->addField('state', 'ESTADO', ORMDefinition::INTEGER, 2, 0, true, 1)
				->addRelation1xN("lines", "MOD_HW_ID", "TelephoneLine")
				;
    // Bouml preserved body end 00160205
  }

}
?>