<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/provisioning/TelephoneModel.php';
require_once 'iplan/models/provisioning/TelephoneSite.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Federico G. Bernoldi
* 
*/
class TelephoneLine extends ORMObject {
  /**
   * @var string la MAC Address del tel�fono
   */
  protected $mac;

  /**
   * @var string el nombre del archivo de configuaric�n
   */
  protected $file;

  /**
   * @var TelephoneModel el modelo del tel�fono
   */
  protected $model;

  /**
   * @var DateTime la fecha en que se registr� el hardware
   */
  protected $date;

  /**
   * @var int el estado del tel�fono
   */
  protected $state;

  /**
   * @var string el nro. de interno
   */
  protected $internal;

  /**
   * @var TelephoneSite El sitio en el que esta registrado el telefono.
   */
  protected $site;

  /**
   * @var int El puerto de la linea
   */
  protected $port;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00160285
	return parent::define($orm)
                ->setClass('TelephoneLine')
				->setTable('LINEAS')
				->addField('id', 'LINEA', ORMDefinition::STRING, 255, 0, false)
				->setKey('id')
				->addField('internal', 'NRO_INTERNO', ORMDefinition::STRING, 255, null, true)
				->addField('mac', 'MAC_ADDRESS', ORMDefinition::STRING, 50, 0, true)
					->addValidation("mac", "mac")
				->addField('state', 'ESTADO_HW', ORMDefinition::INTEGER, 2, 0, true)
				->addField('date', 'FE_HW', ORMDefinition::DATE, null, null, true)
				->addField('file', 'FILE_HW', ORMDefinition::STRING, 255, null, true)
			    ->addField('port', 'PUERTO_HW', ORMDefinition::INTEGER, 2, 0, true)
					->addValidation("port", "required")
				->addInstance('model', 'MOD_HW_ID', 'TelephoneModel', true, null, ORM_LOAD_STYLE::LAZY_LOAD)
				->addInstance('site', 'SITIO_ID', 'TelephoneSite', false)
				;
    // Bouml preserved body end 00160285
  }

  /**
   * Verifica si el objeto fue modificado y lo guarda.
   * Este m�todo permite abstraer a las clases descendientes de la necesidad de determinar si el objeto fue alterado o no y oculta la complejidad subyacente a las clases descendientes.
   * @param ORM $orm opcionalmente se debe indicar la instancia del ORM que mantiene el objeto. Esto s�lo es posible si el objeto es nuevo o DETACHED. En el caso que ya estuviera bajo monitoreo de un ORM arrojar� una excepci�n.
   * 
   * Se pens� en que se podr�a hacer el cambio de un ORM a otro, pero el ID deber�a limpiarse, con lo cual s�lo un INSERT se podr�a hacer sobre el destino y los objetos relacionados estar�an a�n con otro ORM lo cual es complicado (manejo de objetos distribu�dos) por lo cual se deja a consideraci�n de futuras versiones, posiblemente en otra vida =)
   */
  public function save(&$orm = null)
  {
    // Bouml preserved body begin 0016D405
	if (($this->getORMState() == ORM_STATUS::FRESH)) {
		throw new Exception("No se puede crear un elemento nuevo de esta clase");
	}
	return parent::save($orm);
    // Bouml preserved body end 0016D405
  }

  /**
   * Borra f�sicamente un objeto de la base. Al borrarse el objeto adem�s se ponen a null los campos de las entidades relacionadas que lo referenciaban y se eliminan los registros de las tablas relaci�n M:N
   * 
   * @return boolean un booleando TRUE si la operaci�n fue concretada con �xito o FALSE sino.
   */
  public function delete()
  {
    // Bouml preserved body begin 0016D385
	return new Exception("No se puede eliminar un elemento nuevo de esta clase");
    // Bouml preserved body end 0016D385
  }

}
?>