<?php

class ServiceProviderBroadsoft {

	/**
	 *
	 * @var array LineasPSTN del Service Provider
	 */
	private $lineasPSTN;

	/**
	 *
	 * @var string El Service Provider en Broadsoft 
	 */
	private $serviceProviderId;

	public function __construct() {
		return ($this);
	}

	/**
	 * Agrega un numero PSTN
	 * 
	 * @param integer $nro Numero PSTN
	 * @return bool true si pudo, false sino.
	 */
	public function addLineaPSTN($nro) {
		if (is_numeric($nro)) {
			$this->lineasPSTN[] = $nro;
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Elimina un numero PSTN
	 * 
	 * @param integer $nro Numero PSTN
	 */
	public function removeLineaPSTN($nro) {
		$indice = array_search($nro, $this->lineasPSTN, true);
		if ($indice !== false) {
			unset($this->lineasPSTN[$indice]);
		}
	}

	/**
	 * Devuelve las lineas en un arreglo.
	 * 
	 * @return array arreglo de lineas.
	 */
	public function getLineasPSTNArray() {
		return ($this->lineasPSTN);
	}
	
	/**
	 * Setea el arreglo de los numeros resetando los indices a numericos
	 * 
	 * @param array $aNumeros Los numeros pstn
	 */
	public function setLineasPSTNArray($aNumeros) {
		$this->lineasPSTN = array_values($aNumeros);
	}
	
	/**
	 * Devuelve una linea en particular
	 * 
	 * @param integer $index El indice de numero de linea agregado
	 * @return integer El numero de linea pedido
	 */
	public function getLineaPSTN($index) {
		if (($index > 0 ) && (is_array($this->lineasPSTN)) && ($index < count($this->lineasPSTN)) ) {
			return ($this->lineasPSTN[$index]);
		} else {
			return false;
		}
	}

	/**
	 * Devuelve la cantidad de lineas agregadas
	 * 
	 * @return integer La cantidad de lineas.
	 */
	public function getCantidad() {
		return (count($this->lineasPSTN));
	}

	/**
	 * Devuelve el Service Provider ID de broadsoft.
	 * 
	 * @return string El Service Provider.
	 */
	public function getServiceProviderId() {
		return $this->serviceProviderId;
	}
	
	/**
	 * Setea el Service Provider ID de broadsoft.
	 * @param string $serviceProviderId 
	 */
	public function setServiceProviderId($serviceProviderId) {
		$this->serviceProviderId = $serviceProviderId;
	}

}

?>