<?php
require_once 'iplan/models/provisioning/ProcessState.php';
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/provisioning/Process.php';
require_once 'iplan/models/provisioning/System.php';
require_once 'iplan/models/provisioning/Log.php';
require_once 'iplan/models/provisioning/XMLMessage.php';
require_once 'iplan/models/googleapps/GoogleTransaction.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Federico G. Bernoldi
* 
*/
/**
 * 
 * @method ProcessState getState()
 * @method ServiceOrder setState()
 * @method string getCode()
 * @method ServiceOrder setCode()
 * @method Process getProcess()
 * @method ServiceOrder setProcess()
 * @method int getNumber()
 * @method ServiceOrder setNumber()
 * @method int getSubscriptionId()
 * @method ServiceOrder setSubscrioptionId()
 * @method int getServiceTypeId()
 * @method ServiceOrder setServiceTypeId()
 * @method string getServiceTypeCode()
 * @method ServiceOrder setServiceTypeCode()
 * @method string getFeatureTypeCode()
 * @method ServiceOrder setFeatureTypeCode()
 * @method string getMeasureUnitCode()
 * @method ServiceOrder setMeasureUnitCode()
 * @method string getMeasureUnitValue()
 * @method ServiceOrder setMeasureUnitValue()
 * @method string getStatusCode()
 * @method ServiceOrder setStatusCode()
 * @method string getDescription()
 * @method ServiceOrder setDescription()
 * @method int getSellOrder()
 * @method ServiceOrder setSellOrder()
 * @method int getSubscriptionServiceId()
 * @method ServiceOrder setSubscriptionServiceId()
 * @method DateTime getDate()
 * @method ServiceOrder setDate()
 * @method string getCgp()
 * @method ServiceOrder setCgp()
 * @method string getRazonSocial()
 * @method ServiceOrder setRazonSocial()
 */
class ServiceOrder extends ORMObject {
  /**
   * @var ProcessState Estado de la tarea
   */
  protected $state;

  /**
   * @var string el código de tarea
   */
  protected $code;

  /**
   * @var Process el proceso al que pertenece la tarea
   */
  protected $process;

  /**
   * @var int el número de orden de servicio
   */
  protected $number;

  /**
   * @var int un número que representa el código de suscripción en 10fold
   */
  protected $subscriptionId;

  /**
   * @var int 
   */
  protected $serviceTypeId;

  /**
   * @var string el código de tipo de servicio
   */
  protected $serviceTypeCode;

  /**
   * @var string 
   */
  protected $featureTypeCode;

  /**
   * @var string código de la unidad de medida
   */
  protected $measureUnitCode;

  /**
   * @var string 
   */
  protected $measureUnitValue;

  /**
   * @var string 
   */
  protected $statusCode;

  /**
   * @var string 
   */
  protected $description;

  /**
   * TODO: esto es un CLOB!!
   * @var string información acerca de la orden de servicio
   */
  protected $metadata;

  /**
   * @var int el número de orden de venta
   */
  protected $sellOrder;

  /**
   * @var int El número de subscripción de servicio.
   */
  protected $subscriptionServiceId;

  /**
   * @var DateTime la fecha en que se leyó la tarea.
   */
  protected $date;

  /**
   * @var string el código de CGP
   */
  protected $cgp;

  /**
   * @var string la razón social del cliente
   */
  protected $razonSocial;

  /**
   * @var System el sistema sobre el cual se efectua la tarea?? Na sabemos que no es así, esto en realidad es para diferenciar el producto: central virtual, próximo, router, pero es herencia y por ahora no se toca...
   */
  protected $system;

  /**
   * @var ORMCollection la lista de logs de la tarea
   */
  protected $logs;

  /**
   * @var ORMCollection la lista de mensajes que se intercambiaron al realizar las transacciones
   */
  protected $xmlMessages;

  /**
   * @var ORMCollection la lista de transacciones de Google Apps asociadas a esta novedad
   */
  protected $googleAppsTransactions;

  /**
   * Retorna un objeto de definicin predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definicin
   * @return ORMDefinition la definicin default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 00155B05
	return parent::define($orm)
					->setTable('CAP_SERVICEORDERTASKS')
					->addField('id', 'SERVICEORDERTASKID', ORMDefinition::INTEGER, 8)
					->setKey('id')
					->addField('code', 'TASKCODE', ORMDefinition::STRING, 255)
					->addField('number', 'SERVICEORDERNUMBER', ORMDefinition::STRING, 255)
					->addField('subscriptionId', 'SUBSCRIPTIONID', ORMDefinition::INTEGER, 8)
					->addField('serviceTypeId', 'SERVICETYPESPSID', ORMDefinition::INTEGER, 8)
					->addField('serviceTypeCode', 'SERVICETYPECODE', ORMDefinition::STRING, 255)
					->addField('featureTypeCode', 'FEATURETYPECODE', ORMDefinition::STRING, 255)
					->addField('measureUnitCode', 'UNITOFMEASURECODE', ORMDefinition::STRING, 2)
					->addField('measureUnitValue', 'VALUEOFMEASURECODE', ORMDefinition::STRING, 2)
					->addField('statusCode', 'STATUSCODE', ORMDefinition::STRING, 2)
					->addField('description', 'DESCRIPTION', ORMDefinition::STRING, 255)
					->addField('metadata', 'METADATA', ORMDefinition::TEXT)
					->addField('sellOrder', 'ORDENDEVENTA', ORMDefinition::INTEGER)
					->addField('subscriptionServiceId', 'SUBSCRIPTIONSERVICEID', ORMDefinition::INTEGER, 10)
					->addField('date', 'FECHA', ORMDefinition::DATETIME)
					->addField('cgp', 'CGP', ORMDefinition::STRING, 20)
					->addField('razonSocial', 'RAZONSOCIAL', ORMDefinition::STRING, 255)
					->addInstance("state", "ESTADO_ID", "ProcessState")
					->addInstance("process", "PROCESO_ID", "Process")
					->addInstance("system", "SISTEMA_ID", "System")
					->addRelationNxM('logs', "CAP_SERVICEORDERTASKLOG", "LOG_ID", "Log", "SERVICEORDERTASKID")
					->addRelationNxM('xmlMessages', "CAP_SERVICEORDERTASKXML", "XML_ID", "XMLMessage", "SERVICEORDERTASKID")
					->addRelation1xN('googleAppsTransactions', 'SERVICEORDERTASKID', "GoogleTransaction");
			;
    // Bouml preserved body end 00155B05
  }

}
?>