<?php

require_once("Feature.php");

/**
 * Clase de servicio de Features para la comoda organizacion y lindo manejo xd
 */
class ServiceFeatures {

	/**
	 *
	 * @var array Arreglo de features
	 */
	private $aFeatures = array();

	/**
	 * Agrega un Feature a la instancia de la clase
	 * 
	 * @param Feature $feature el feature a agregar
	 */
	public function addFeature($feature) {
		$this->aFeatures[] = $feature;
	}

	/**
	 * Busca los features por tipo en la lista interna de features
	 * 
	 * @param string $tipo El tipo de feature
	 * @return array Un arreglo de los features que coinciden con el tipo buscado 
	 */
	public function getFeaturesByTipo($tipo) {
		$res = array();
		if (is_array($this->aFeatures) && (count($this->aFeatures) > 0 )) {
			foreach($this->aFeatures as $feature) {
				if ($feature->getTipo() == $tipo) {
					$res[] = $feature;
				}
			}
		}
		return($res);
	}
	/**
	 * Busca los features por unidad de medida en la lista interna de features
	 * 
	 * @param string $unidad la unidad de medida a buscar
	 * @return array Un arreglo de los features que coinciden con la unidad buscada
	 */
	public function getFeaturesByUnidad($unidad) {
		$res = array();
		if (is_array($this->aFeatures) && (count($this->aFeatures) > 0 )) {
			foreach($this->aFeatures as $feature) {
				if ($feature->getUnidad() == $unidad) {
					$res[] = $feature;
				}
			}
		}
		return($res);
	}
	
	public function existFeatureId($id) {
		if (is_array($this->aFeatures) && (count($this->aFeatures) > 0 )) {
			foreach($this->aFeatures as $feature) {
				if ($feature->getId() == $id) {
					return (true);
				}
			}
		}
		return (false);
	}
	
	/**
	 * Devuelve un arreglo con los features agregados
	 * 
	 * @return array Array de Features
	 */
	public function getFeaturesArray() {
		return $this->aFeatures;
	}
	
}

?>