<?php
require_once 'iplan/models/provisioning/XMLMessage.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';



/**
* Author: Federico G. Bernoldi
* 
*/
class SellOrderXML extends ORMObject {
  /**
   * @var ORMCollection la lista de mensajes de la orden de venta
   */
  private $messages;

  /**
   * @var DateTime la fecha de alta
   */
  protected $date;

  /**
   * @var int el número de orden de venta
   */
  protected $sellOrder;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 001C1985
	return parent::define($orm)
					->setTable('CAP_ORDENESXML')
					->addField('id', 'XML_ID', ORMDefinition::INTEGER, 8, 0)
					->setKey('id')
					->addField('sellOrder', 'ORDENDEVENTA', ORMDefinition::INTEGER)
					->addField('date', 'FECHA', ORMDefinition::DATETIME)
					->addInstance('messages', 'XML_ID', 'XMLMessage');
    // Bouml preserved body end 001C1985
  }

}
?>