<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/models/provisioning/Log.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Federico G. Bernoldi
* 
*/
/**
 * Esta clase mantiene informacion acerca del proceso de una Orden de Venta
 */
class SellOrderLog extends ORMObject {
  /**
   * @var Date la fecha en que fue creado el log
   */
  protected $date;

  /**
   * @var ORMCollection la lista de logs que forman el log de la Orden de Venta
   */
  protected $logs;

  /**
   * @var int El codigo de orden de venta al que pertenece el log
   */
  protected $sellOrder;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 0015AC85
	return parent::define($orm)
					->setTable('CAP_ORDENESLOG')
					->addField('id', 'LOG_ID', ORMDefinition::INTEGER, 8, 0)
					->setKey('id')
					->addField('sellOrder', 'ORDENDEVENTA', ORMDefinition::INTEGER)
					->addField('date', 'FECHA', ORMDefinition::DATETIME)
					->addInstance('logs', 'LOG_ID', 'Log');
    // Bouml preserved body end 0015AC85
  }

}
?>