<?php
require_once 'iplan/orm/ORMObject.php';
require_once 'iplan/orm/ORMDefinition.php';
require_once 'iplan/orm/ORM.php';

require_once "iplan/orm/ORMDefinition.php";

/**
* Author: Federico G. Bernoldi
* 
*/
class RouterEquipos extends ORMObject {
  /**
   * @var string la descripci�n del equipo
   */
  protected $descripcion;

  /**
   * @var string el path al archivo de configuraci�n para el router
   */
  protected $pathTemplate;

  /**
   * @var string el nombre del archivo de configuraci�n
   */
  protected $filename;

  /**
   * @var int el estado del registro de datos
   */
  protected $state;

  /**
   * @var boolean indica si soporta TR069
   */
  protected $tr069;

  /**
   * Retorna un objeto de definici�n predeterminado al cual hay que agregarle los mapeos pertinentes.
   * @param iplan\orm\ORM $orm el manejador de objetos para el cual se registra la definici�n
   * @return ORMDefinition la definici�n default
   */
  public static function define(&$orm = null)
  {
    // Bouml preserved body begin 0015AE05
	return parent::define($orm)
					->setTable('CAP_ROUTER_EQUIPOS')
					->addField('id', 'EQUIPO_ID', ORMDefinition::INTEGER, 8, 0)
					->setKey('id')
					->addField('descripcion', 'DESCRIPCION', ORMDefinition::STRING, 4000)
					->addField('pathTemplate', 'PATH_TEMPLATE', ORMDefinition::STRING, 4000)
					->addField('filename', 'FILENAME', ORMDefinition::STRING, 4000)
					->addField('state', 'ESTADO', ORMDefinition::INTEGER)
					->addField('tr069', 'TR069', ORMDefinition::INTEGER);
    // Bouml preserved body end 0015AE05
  }

}
?>